/*======================================================================
**ļƣSTM32L431RCTX_FLASH.ldļ
**λSD-Arm(sumcu.suda.edu.cn)
**¼¼20181201-20200627
**======================================================================*/

ENTRY(Reset_Handler)

/*1䶯س*/
 MCU_SECTORSIZE =2048;     
 MCU_FLASH_ADDR_START = 0x8000000;  /*STM32L431RCFLASH*/
 MCU_IRQ_NUM = 99;                  /*STM32L431RCж*/
 GEC_BIOS_SECTOR_START =0;          /*BIOSʼ*/
 GEC_BIOS_SECTOR_END =13;           /*BIOSĽ*/
 GEC_DYNAMIC_START =14;             /*̬ʼ*/
 GEC_DYNAMIC_END =18;               /*̬*/
 GEC_COMPONENT_LST_START =19;       /*бʼ*/
 GEC_COMPONENT_LST_END =20;         /*б*/
 GEC_COMPONENT_FUN_START =21;       /*뿪ʼ*/
 GEC_COMPONENT_FUN_END =25;         /**/
 GEC_BIOS_RAM_START =0x20000200;    /*BIOS RAMʼַ*/
 GEC_BIOS_RAM_END =0x2000ffff;      /*BIOS RAMַ*/
 _estack =  0x2000ffff;	            /*BIOS RAMַSTM32ļ*/
/*2̶MEMORYζ*/
MEMORY
{
	/*ж*/
	INTVEC(rx) : ORIGIN =MCU_SECTORSIZE * GEC_BIOS_SECTOR_START 
	                     + MCU_FLASH_ADDR_START,
	              LENGTH = MCU_SECTORSIZE
    /*Flash*/
    FLASH (rx) : ORIGIN = MCU_SECTORSIZE * ( GEC_BIOS_SECTOR_START + 1 ) 
                          + MCU_FLASH_ADDR_START,
                  LENGTH = MCU_SECTORSIZE * ( GEC_BIOS_SECTOR_END 
                          - GEC_BIOS_SECTOR_START )
    /*̬*/
    DY_CMD (rx) : ORIGIN = MCU_SECTORSIZE * GEC_DYNAMIC_START + 
                              MCU_FLASH_ADDR_START,
                     LENGTH =MCU_SECTORSIZE * ( GEC_DYNAMIC_END 
                             - GEC_DYNAMIC_START + 1 )
    /*бô*/
    CPT_LST(rx) : ORIGIN = MCU_SECTORSIZE * GEC_COMPONENT_LST_START 
                            + MCU_FLASH_ADDR_START,
                   LENGTH =MCU_SECTORSIZE * ( GEC_COMPONENT_LST_END 
                           - GEC_COMPONENT_LST_START + 1 )
   /*ô*/
    CPT_FUN(rx) : ORIGIN = MCU_SECTORSIZE * GEC_COMPONENT_FUN_START + 
                            MCU_FLASH_ADDR_START,
                   LENGTH =MCU_SECTORSIZE * ( GEC_COMPONENT_FUN_END 
                           - GEC_COMPONENT_FUN_START + 1 )
    /*BIOSRAM*/
    RAM (rwx) : ORIGIN = GEC_BIOS_RAM_START, 
                  LENGTH = GEC_BIOS_RAM_END - GEC_BIOS_RAM_START + 1
}
/*3䶯SECTIONSζ*/
SECTIONS
{
/* 3.1̶ж */
  .isr_vector :
  {
    __VECTOR_TABLE = .;
    . = ALIGN(4);
    KEEP(*(.isr_vector)) 
    . = ALIGN(4);
  } >INTVEC

/*3.2̶̬*/
    .dynamic_command :
  {
    . = ALIGN(1);
    KEEP(*(.dynamic_command))
    . = ALIGN(1);
  } > DY_CMD
  
/*3.3̶б*/
.component_list :
  {
    . = ALIGN(1);
    KEEP(*(.component_list))
    . = ALIGN(1);
  } > CPT_LST
  
/*3.4̶*/
.component_fun :
  {
    . = ALIGN(1);
    KEEP(*(.component_fun))
    . = ALIGN(1);
  } > CPT_FUN
  

  /*3.5䶯ΪSTM32*/
  
  /* The program code and other data into "FLASH" Rom type memory */
  .text :
  {
    . = ALIGN(4);
    *(.text)           /* .text sections (code) */
    *(.text*)          /* .text* sections (code) */
    *(.rodata)         /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)        /* .rodata* sections (constants, strings, etc.) */
    *(.glue_7)         /* glue arm to thumb code */
    *(.glue_7t)        /* glue thumb to arm code */
    *(.eh_frame)

    KEEP (*(.init))
    KEEP (*(.fini))

    . = ALIGN(4);
    /*_etext = .;         define a global symbols at end of code */
  } >FLASH

  /* Constant data into "FLASH" Rom type memory */
  .rodata :
  {
    . = ALIGN(4);
    *(.rodata)         /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)        /* .rodata* sections (constants, strings, etc.) */
    . = ALIGN(4);
  } >FLASH

  .ARM.extab   : { 
  	. = ALIGN(4);
  	*(.ARM.extab* .gnu.linkonce.armextab.*)
  	. = ALIGN(4);
  } >FLASH
  
  .ARM : {
    . = ALIGN(4);
    __exidx_start = .;
    *(.ARM.exidx*)
    __exidx_end = .;
    . = ALIGN(4);
  } >FLASH

  .preinit_array     :
  {
    . = ALIGN(4);
    PROVIDE_HIDDEN (__preinit_array_start = .);
    KEEP (*(.preinit_array*))
    PROVIDE_HIDDEN (__preinit_array_end = .);
    . = ALIGN(4);
  } >FLASH
  
  .init_array :
  {
    . = ALIGN(4);
    PROVIDE_HIDDEN (__init_array_start = .);
    KEEP (*(SORT(.init_array.*)))
    KEEP (*(.init_array*))
    PROVIDE_HIDDEN (__init_array_end = .);
    . = ALIGN(4);
  } >FLASH
  
  .fini_array :
  {
    . = ALIGN(4);
    PROVIDE_HIDDEN (__fini_array_start = .);
    KEEP (*(SORT(.fini_array.*)))
    KEEP (*(.fini_array*))
    PROVIDE_HIDDEN (__fini_array_end = .);
    . = ALIGN(4);
  } >FLASH
  
  __etext = .;    /* define a global symbol at end of code */
  __DATA_ROM = .; /* Symbol is used by startup for data initialization */

  /* Used by the startup to initialize data */
  _sidata = LOADADDR(.data);

  /* Initialized data sections into "RAM" Ram type memory */
  .data : 
  {
    . = ALIGN(4);
    _sdata = .;        /* create a global symbol at data start */
    *(.data)           /* .data sections */
    *(.data*)          /* .data* sections */

    . = ALIGN(4);
    _edata = .;        /* define a global symbol at data end */
    
  } >RAM AT> FLASH
  
  
  /* Uninitialized data section into "RAM" Ram type memory */
  . = ALIGN(4);
  .bss :
  {
    /* This is used by the startup in order to initialize the .bss secion */
    _sbss = .;         /* define a global symbol at bss start */
    __bss_start__ = _sbss;
    *(.bss)
    *(.bss*)
    *(COMMON)

    . = ALIGN(4);
    _ebss = .;         /* define a global symbol at bss end */
    __bss_end__ = _ebss;
  } >RAM


  /* Remove information from the compiler libraries */
  /DISCARD/ :
  {
    libc.a ( * )
    libm.a ( * )
    libgcc.a ( * )
  }

  .ARM.attributes 0 : { *(.ARM.attributes) }
}
