//===========================================================================
//ļƣflash.h
//ܸҪflashײͷļ
//ȨУݴѧǶʽϵͳо(sumcu.suda.edu.cn)
//¼¼2013-06-06 V1.0; 2016-06-06 V6.0; 2019-05-28
//оƬKL25KL26KW01STM32L433
//===========================================================================

#ifndef _FLASH_H
#define _FLASH_H

#include "mcu.h" 
#include "string.h"


#define USE_BIOS_FLASH    (0) //1̳BIOS0ʹԴ

#if(USE_BIOS_FLASH==0)

#define FLASH_KEY1       0x45670123U          //FlashƼĴ(CR)Կ1
#define FLASH_KEY2       0xCDEF89ABU          //FlashƼĴ(CR)Կ2

#define FLASH_PDKEY1     0x04152637U          //FlashģʽµԿ1
#define FLASH_PDKEY2     0xFAFBFCFDU          //FlashģʽµԿ2

#define FLASH_OPTKEY1    0x08192A3BU          //FlashѡĴ(OPTR)Կ1
#define FLASH_OPTKEY2    0x4C5D6E7FU          //FlashѡĴ(OPTR)Կ2

#define FLASH_PAGE_SIZE  ((uint32_t)0x800)     //FlashÿС(STM32L433Ϊ 2KB)

//======================================================================
//ƣflash_init
//أ
//˵
//ܸҪʼflashģ
//======================================================================
void flash_init();

//======================================================================
//ƣflash_erase
//أִִ״̬0=1=쳣
//˵sectĿţΧȡʵоƬ STM32L433:0~127,ÿ2KB;
//ܸҪflash洢sect
//======================================================================
uint8_t flash_erase(uint16_t sect);

//======================================================================
//ƣflash_write
//أִ״̬0=1=쳣
//˵sectţΧȡʵоƬ STM32L433:0~127,ÿ2KB
//        offset:дڲƫƵַ0~2044ҪΪ0,4,8,12......
//        NдֽĿ4~2048,ҪΪ4,8,12,......
//        bufԴݻ׵ַ
//ܸҪbufʼNֽд뵽flash洢sect offset
//=======================================================================
uint8_t flash_write(uint16_t sect,uint16_t offset,uint16_t N,uint8_t *buf);

//=======================================================================
//ƣflash_write_physical
//أִ״̬0=0=쳣
//˵ addrĿַҪΪ4ıҴFlash׵ַ
//              磺0x08000004Flash׵ַΪ0x08000000
//       cntдֽĿ8~512
//       bufԴݻ׵ַ
//ܸҪflashд
//=======================================================================
uint8_t flash_write_physical(uint32_t addr,uint16_t N,uint8_t buf[]);

//=======================================================================
//ƣflash_read_logic
//أ
//˵destݴŴַĿǴݣRAM
//       sectţΧȡʵоƬ STM32L433:0~127,ÿ2KB
//       offset:ڲƫƵַ0~2024ҪΪ0,4,8,12......
//       NֽĿ4~2048,ҪΪ4,8,12,......//
//ܸҪȡflash洢sect offsetʼNֽڣRAMdest
//=======================================================================
void flash_read_logic(uint8_t *dest,uint16_t sect,uint16_t offset,uint16_t N);


//=======================================================================
//ƣflash_read_physical
//أ
//˵destݴŴַĿǴݣRAM
//       addrĿַҪΪ4ı磺0x00000004
//       NֽĿ0~1020,ҪΪ48,12,......
//ܸҪȡflashַָ
//=======================================================================
void flash_read_physical(uint8_t *dest,uint32_t addr,uint16_t N);


//======================================================================
//ƣflash_protect
//أ
//˵MKL25:ֵʵʱM~M+3,M=0,4,8,......,124
//         KL36(64):ֵʵʱM~M+1,M=0,2,4,6,......,62
//ܸҪflash
//˵        KL25(128)ÿñһΣ4M~M+3128/32=4
//       KL36(64)ÿñһΣ2M~M+1 63/32=2
//======================================================================
void flash_protect(uint8_t M);
void flash_unprotect(uint8_t M);
//======================================================================
//ƣflash_isempty
//أ1=ĿΪգ0=Ŀǿա
//˵Ҫ̽flashʼַ
//ܸҪflashпղ
//======================================================================
uint8_t flash_isempty(uint16_t sect,uint16_t N);

//========================================================================
//ƣflashCtl_isSectorProtected
//أ1=0=δ
//˵Ҫ
//ܸҪжflashǷ񱻱
//=========================================================================
uint8_t flash_isSectorProtected(uint16_t sect);
//=======================ע==================================


//============================================================

#elif (USE_BIOS_FLASH == 1)
#define flash_init ((void (*)())(component_fun[23]))
#define flash_erase ((uint8_t (*)(uint16_t sect))(component_fun[24]))
#define flash_write ((uint8_t (*)(uint16_t sect,uint16_t offset,uint16_t N,uint8_t *buf))(component_fun[25]))
#define flash_write_physical ((uint8_t (*)(uint32_t destaddr,uint16_t N,uint8_t *buf))(component_fun[26]))
#define flash_read_logic ((void (*)(uint8_t *dest,uint16_t sect,uint16_t offset,uint16_t N))(component_fun[27]))
#define flash_read_physical ((void (*)(uint8_t *dest,uint32_t addr,uint16_t N))(component_fun[28]))
#define flash_protect ((void (*)(uint8_t sect))(component_fun[29]))
#define flash_isempty ((uint8_t (*)(uint16_t sect,uint16_t offset,uint16_t N))(component_fun[30]))
#endif

#endif //_FLASH_H

//======================================================================
//
//1ǿԴ룬ڱṩӲϵͳͨϷ׸ᣬ
//    ֮ӭָ
//2ʹ÷ǱӲϵͳûֲʱϸԼӲƥ䡣
//
//ݴѧǶʽϵͳо,0512-65214835  http://sumcu.suda.edu.cn

