///=====================================================================
//ļƣueupdate.cļ
//λSD-Arm(sumcu.suda.edu.cn)
//¼¼20181201-20200627
//ֲ򣺡̶
///=====================================================================

#include "ueupdate.h"

uint8_t uStartNo;    //ûʼ
uint8_t uEndNo;      //û
uint16_t uSectSize;  //MCUС
uint8_t uSectNo;     //µĴռ
uint16_t uFrameNum;  //֡
uint16_t uCurFrame;  //ǰ֡
uint8_t uStyle;      //·ʽ0滻£1屣£2
uint8_t uCheck[32];  //֡״̬飬ÿһλʾһ֡״̬һɱʾ32*8256֡״̬
uint8_t uCheckFlag;  //¼־ܽи²
uint8_t uUpdateFlag; //½ձ־0½ղɹ½ղʧ

//========================ڲ=====================================
uint8_t ueupdate_replaceRecv(uint8_t *buf,uint16_t len);
uint8_t ueupdate_reserveRecv(uint8_t *buf,uint16_t len);
void flagSet(uint8_t *flagBuf,uint16_t flag);
uint8_t flagGet(uint8_t *flagBuf,uint16_t flag);
uint8_t ueupdate_update();
//======================================================================

//======================================================================
//ƣueupdate_init
//startSectorûʼţendSectorû+1
//       sectSizeоƬС
//أ
//ܸҪʵն˳¹ܳʼûʼͽ
//       flashģĳʼ֡־ʼ
//======================================================================
void ueupdate_init(uint8_t startSector,uint8_t endSector,uint16_t sectSize)
{
	//1
	uint8_t i;

	//2ʼļȫֱ
	uStartNo = startSector;  //ûʼ
	uEndNo = endSector;      //û
	uSectSize = sectSize;    //оƬС
	uFrameNum = 0;           //ʼ֡Ϊ0
	uCurFrame = 0;           //ʼǰ֡Ϊ0
	for(i = 0;i < sizeof(uCheck);i++)
		uCheck[i] = 0;       //֡־ʼΪ0
	uCheckFlag = 0;          //ʼ¼־Ϊ0

	//3ʼģ
	flash_init();
}

//======================================================================
//ƣueupdate_reinit
//buf:յĸ;len:յĸݳ
//أ
//       1ʼ滻£
//       4֡
//ܸҪݿʼ֡³ʼUeupdateú滻ΪUser
//       BIOSueupdateĳʼ״̬δܱҪ³ʼ״̬
//======================================================================
uint8_t ueupdate_reinit(uint8_t *buf,uint16_t len)
{
	//1
	uint8_t i;
	uint8_t rv;
	uint32_t codeSize;

	rv = 0;
	//2
	//2.1յ¿ʼ֡
	if(buf[0] == 0)
	{
		if(len == sizeof(struct startData))  //ݳ¿ʼ֡
		{
			//³ʼ֡־Ϊ0
			for(i = 0;i < sizeof(uCheck);i++)
				uCheck[i] = 0;
			//ȡ¿ʼ֡
			uStyle = ((struct startData *)buf)->style;
			uFrameNum = ((struct startData *)buf)->frameNum;
			uCurFrame = ((struct startData *)buf)->curFrame;
			codeSize = ((struct startData *)buf)->codeSize;
			//´ռ
			if(codeSize%uSectSize == 0)
				uSectNo = codeSize/uSectSize;
			else
				uSectNo = codeSize/uSectSize+1;
			//ݸ·ʽĲͬвͬ
			if(uStyle == 0)
			{
				rv = 1;  //ʼ滻
			}
			//޸ĵǰ֡״̬
			flagSet(uCheck,uCurFrame);
		}
	}
	else
	{
		rv = 4;  //֡ݶʧ״̬
	}
	uUpdateFlag = rv;  //ʾ·
	return rv;
}

//======================================================================
//ƣueupdate_reframe
//buf:յĸ;len:յĸݳ
//أ0ղִи²ɹ
//       1ʼ滻£
//       2ʼ£¡£
//       3жϣ֪ͨλ¿ʼ
//       4֡
//       5֡ʶ
//       6滻²ɹ
//       7²ɹ
//ܸҪղݣӦĲ¿ʼ¸ơ²롢¼顢
//======================================================================
uint8_t ueupdate_reframe(uint8_t *buf,uint16_t len)
{
	//1
	uint8_t i;
	uint8_t rv;
	uint8_t flag;
	uint32_t codeSize;

	rv = 0;
	//2
	//2.1յ¿ʼ֡
	if(buf[0] == 0)
	{
		if(len == sizeof(struct startData))  //ݳ¿ʼ֡
		{
			//³ʼ֡־Ϊ0
			for(i = 0;i < sizeof(uCheck);i++)
				uCheck[i] = 0;
			//ȡ¿ʼ֡
			uStyle = ((struct startData *)buf)->style;
			uFrameNum = ((struct startData *)buf)->frameNum;
			uCurFrame = ((struct startData *)buf)->curFrame;
			codeSize = ((struct startData *)buf)->codeSize;
			//´ռ
			if(codeSize%uSectSize == 0)
				uSectNo = codeSize/uSectSize;
			else
				uSectNo = codeSize/uSectSize+1;
			//ݸ·ʽĲͬвͬ
			if(uStyle == 0)
			{
				//滻£ֱӽUserд
				for(i = uStartNo;i < (uStartNo+uSectNo);i++)
					flash_erase(i);
				rv = 1;  //ʼ滻
			}
			else
			{
				//£User֮³ɹ帲
				for(i = uEndNo+1;i < (uEndNo+uSectNo+1);i++)
					flash_erase(i);
				rv = 2;  //ʼ£¡£
			}
			//޸ĵǰ֡״̬
			flagSet(uCheck,uCurFrame);
		}
	}
	//2.2յݣ¸֡²֡ ¼֡֡
	else
	{
		//ݸ·ʽĲͬвͬ
		if(uStyle == 0)  //滻
		{
			flag = ueupdate_replaceRecv(buf,len);
			//췵ֵӦòж
			switch(flag)
			{
			case 0: rv = 0;break;  //ǰ²ɹ
			case 1: rv = 3;break;  //жϣ֪ͨλ¿ʼ
			case 2: rv = 4;break;  //֡
			case 3: rv = 6;break;  //滻²ɹ
			case 4: rv = 5;break;  //֡ʶ
			}
		}
		else  //
		{
			flag = ueupdate_reserveRecv(buf,len);
			//췵ֵӦòж
			switch(flag)
			{
			case 0: rv = 0;break;  //ǰ²ɹ
			case 1: rv = 3;break;  //жϣ֪ͨλ¿ʼ
			case 2: rv = 4;break;  //֡
			case 3: rv = 7;break;  //²ɹ
			case 4: rv = 5;break;  //֡ʶ
			}
		}
	}

	uUpdateFlag = rv;  //ʾ·
	return rv;
}

//======================================================================
//ƣueupdate_replaceRecv
//buf:յĸ;len:յĸݳ
//أ0ղִ滻²ɹ
//       1жϣ֪ͨλ¿ʼ
//       2֡
//       3滻ϣ
//       4֡ʶ
//ܸҪոݲ滻²²롢¼顢
//======================================================================
uint8_t ueupdate_replaceRecv(uint8_t *buf,uint16_t len)
{
	//1
	uint8_t i;
	uint8_t rv;
	uint8_t segNum;
	uint32_t insertTo;
	uint16_t insertLen;
	uint16_t insertCurLen;
	uint8_t *iData;

	rv = 0;
	//2֡ʶи²
	switch(buf[0])
	{
	case 0:  //¿ʼ֡
		//и¿ʼ֡
		break;
	case 1:  //¸֡
		//滻޸¸֡
		break;
	case 2:  //²֡
		if(len == sizeof(struct insertData))  //ݳ²֡
		{
			//ȡ²֡
			uCurFrame = ((struct insertData *)buf)->curFrame;
			segNum = ((struct insertData *)buf)->segNum;
			//жϣ֪ͨλ¿ʼ
			if(uFrameNum == 0 || uCurFrame >= uFrameNum)
			{
				rv = 1;
				goto ueupdate_replaceRecv_EXIT;
			}
			//д
			insertCurLen = 0;
			for(i = 0;i < segNum;i++)
			{
				insertTo = ((struct insertData *)buf)->addInfo[i];  //Ŀַ
				insertLen = ((struct insertData *)buf)->lenInfo[i];   //ݳ
				iData = ((struct insertData *)buf)->data + insertCurLen;        //
				//
				flash_write_physical(insertTo,insertLen,iData);
				insertCurLen += insertLen;
			}
			//޸ĵǰ֡״̬
			flagSet(uCheck,uCurFrame);
		}
		break;
	case 3:  //¼֡
		if(len == sizeof(struct checkData))  //ݳ¼֡
		{
			//ȡ¼֡
			uCurFrame = ((struct checkData *)buf)->curFrame;
			//жϣ֪ͨλ¿ʼ
			if(uFrameNum == 0 || uCurFrame >= uFrameNum)
			{
				rv = 1;
				goto ueupdate_replaceRecv_EXIT;
			}
			//޸ĵǰ֡״̬
			flagSet(uCheck,uCurFrame);
			//Ƿ֡
			for(i = 0;i < uFrameNum-1;i++)
			{
				if(flagGet(uCheck,i) == 0)  //ֶ֡״
				{
					rv = 2;
					goto ueupdate_replaceRecv_EXIT;
				}
			}
			//ø¼־
			uCheckFlag = 1;
		}
		break;
	case 4:  //֡
		if(len == sizeof(struct updateData))  //ݳ֡
		{
			if(uCheckFlag == 1)  //Ը
			{
				rv = 3;
				goto ueupdate_replaceRecv_EXIT;
			}
		}
		break;
	default:  //֡ʶ
		rv = 4;
		goto ueupdate_replaceRecv_EXIT;
	}

	ueupdate_replaceRecv_EXIT:
	return rv ;
}
//======================================================================
//ƣueupdate_reserveRecv
//buf:յĸ;len:յĸݳ
//أ0ղִб²ɹ
//       1жϣ֪ͨλ¿ʼ
//       2֡
//       3뱣ϣ
//       4֡ʶ
//ܸҪոݲб²¸ơ²롢¼顢
//======================================================================
uint8_t ueupdate_reserveRecv(uint8_t *buf,uint16_t len)
{
	//1
	uint8_t i;
	uint8_t rv;
	uint8_t segNum;
	uint32_t copyFrom;
	uint32_t copyTo;
	uint16_t copyLen;
	uint8_t cData[512];
	uint32_t insertTo;
	uint16_t insertLen;
	uint16_t insertCurLen;
	uint8_t *iData;

	rv = 0;
	//2֡ʶи²
	switch(buf[0])
	{
	case 0:  //¿ʼ֡
		//и¿ʼ֡
		break;
	case 1:  //¸֡
		if(len == sizeof(struct copyData))  //ݳ¸֡
		{
			//ȡ¸֡
			uCurFrame = ((struct copyData *)buf)->curFrame;
			segNum = ((struct copyData *)buf)->segNum;
			//жϣ֪ͨλ¿ʼ
			if(uFrameNum == 0 || uCurFrame >= uFrameNum)
			{
				rv = 1;
				goto ueupdate_reserveRecv_EXIT;
			}

			//д븴Ʋ
			for(i = 0;i < segNum;i++)
			{
				copyFrom = ((struct copyData *)buf)->addInfo[i*2];  //Դַ
				copyTo = ((struct copyData *)buf)->addInfo[i*2+1];  //Ŀַ
				copyLen = ((struct copyData *)buf)->lenInfo[i];     //ݳ
				//£Ŀַһĵַƫ
				copyTo += (uEndNo-uStartNo+1)*uSectSize;
				//ֿ鸴ݣÿ512ֽ
				while(copyLen)
				{
					if(copyLen > 512)  //ǰƳȴ512512ֽ
					{
						flash_read_physical(cData,copyFrom,512);
						flash_write_physical(copyTo,512,cData);
						copyFrom += 512;
						copyTo += 512;
						copyLen -= 512;
					}
					else  //ǰƳС512ȫ
					{
						flash_read_physical(cData,copyFrom,copyLen);
						flash_write_physical(copyTo,copyLen,cData);
						copyLen = 0;
					}
				}
			}
			//޸ĵǰ֡״̬
			flagSet(uCheck,uCurFrame);
		}
		break;
	case 2:  //²֡
		if(len == sizeof(struct insertData))  //ݳ²֡
		{
			//ȡ²֡
			uCurFrame = ((struct insertData *)buf)->curFrame;
			segNum = ((struct insertData *)buf)->segNum;
			//жϣ֪ͨλ¿ʼ
			if(uFrameNum == 0 || uCurFrame >= uFrameNum)
			{
				rv = 1;
				goto ueupdate_reserveRecv_EXIT;
			}
			//д
			insertCurLen = 0;
			for(i = 0;i < segNum;i++)
			{
				insertTo = ((struct insertData *)buf)->addInfo[i];  //Ŀַ
				insertLen = ((struct insertData *)buf)->lenInfo[i];   //ݳ
				iData = ((struct insertData *)buf)->data + insertCurLen;        //
				//£Ŀַһĵַƫ
				insertTo += (uEndNo-uStartNo+1)*uSectSize;
				//
				flash_write_physical(insertTo,insertLen,iData);
				insertCurLen += insertLen;
			}
			//޸ĵǰ֡״̬
			flagSet(uCheck,uCurFrame);
		}
		break;
	case 3:  //¼֡
		if(len == sizeof(struct checkData))  //ݳ¼֡
		{
			//ȡ¼֡
			uCurFrame = ((struct checkData *)buf)->curFrame;
			//жϣ֪ͨλ¿ʼ
			if(uFrameNum == 0 || uCurFrame >= uFrameNum)
			{
				rv = 1;
				goto ueupdate_reserveRecv_EXIT;
			}
			//޸ĵǰ֡״̬
			flagSet(uCheck,uCurFrame);
			//Ƿ֡
			for(i = 0;i < uFrameNum-1;i++)
			{
				if(flagGet(uCheck,i) == 0)  //ֶ֡״
				{
					rv = 2;
					goto ueupdate_reserveRecv_EXIT;
				}
			}
			//ø¼־
			uCheckFlag = 1;
		}
		break;
	case 4:  //֡
		if(len == sizeof(struct updateData))  //ݳ֡
		{
			if(uCheckFlag == 1)  //Ը
			{
				rv = 3;
				ueupdate_update();
				goto ueupdate_reserveRecv_EXIT;
			}
		}
		break;
	default:  //֡ʶ
		rv = 4;
		goto ueupdate_reserveRecv_EXIT;
	}

	ueupdate_reserveRecv_EXIT:
	return rv;
}


//======================================================================
//ƣueupdate_backGet
//buf:·ݣlen:·ݳ
//أ
//ܸҪյݣлӦʾλ²ִ״̬
//======================================================================
uint8_t ueupdate_backGet(uint8_t *buf,uint16_t *len)
{
	//1
	uint8_t rv;
	struct backData bdata;

	rv = 0;
	//2·ֵ֡
	bdata.type = 5;
	bdata.curFrame = uCurFrame;
	bdata.flag = uUpdateFlag;

	//3
	*len = sizeof(struct backData);
	memcpy(buf,(uint8_t *)&bdata,*len);

	return rv;
}

//======================================================================
//ƣueupdate_checkGet
//buf:¼ݣlen:¼ݳ
//أ
//ܸҪظ¼֡ݣʾλ¹еĶ֡״̬
//======================================================================
uint8_t ueupdate_checkGet(uint8_t *buf,uint16_t *len)
{
	//1
	uint8_t i;
	uint8_t rv;
	uint8_t loseNum;
	struct checkData cdata;

	rv = 0;
	loseNum = 0;
	//2¼ֵ֡
	cdata.type = 3;
	cdata.curFrame = uCurFrame;
	//֡״̬飬Ҷ֡
	for(i = 0;i < uFrameNum-1;i++)
	{
		if(flagGet(uCheck,i) == 0)  //ֶ֡״
		{
			cdata.loseFrame[loseNum++] = i;
		}
	}
	cdata.loseNum = loseNum;

	//3
	*len = sizeof(struct checkData);
	memcpy(buf,(uint8_t *)&cdata,*len);

	return rv;
}

//======================================================================
//ƣueupdate_dataJudge
//data:յλݣlen:ݳ
//أ0֡ṹݲ֡ṹ
//ܸҪ鴫Ƿλ
//======================================================================
uint8_t ueupdate_dataJudge(uint8_t *data,uint16_t len)
{
	//1
	uint8_t rv;

	rv = 0;  // Ĭϳɹ
	//2жǷ¿ʼ֡
	if(len == sizeof(struct startData) && data[0] == 0)  //Ǹ¿ʼ֡
		goto ueupdate_dataJudge_EXIT;
	//3жǷ¸֡
	else if(len == sizeof(struct copyData) && data[0] == 1)  //Ǹ¸֡
		goto ueupdate_dataJudge_EXIT;
	//4жǷ²֡
	else if(len == sizeof(struct insertData) && data[0] == 2)  //Ǹ²֡
		goto ueupdate_dataJudge_EXIT;
	//5жǷ¼֡
	else if(len == sizeof(struct checkData) && data[0] == 3)  //Ǹ¼֡
		goto ueupdate_dataJudge_EXIT;
	//6жǷ֡
	else if(len == sizeof(struct updateData) && data[0] == 4)  //Ǹ֡
		goto ueupdate_dataJudge_EXIT;
	else
		rv= 1;  //Ϊ֡

ueupdate_dataJudge_EXIT:
	return rv;
}


//ڲ
//======================================================================
//ƣueupdate_update
//
//أ
//ܸҪ´븴ƵUserָλãϵͳλ
//======================================================================
uint8_t ueupdate_update()
{
	//1
	uint8_t i;
	uint32_t j;
	uint32_t userAddress,updateAddress;
	uint8_t data[512];

	//2ȡUser͸³׵ַ
	userAddress = uStartNo*uSectSize;
	updateAddress = (uEndNo+1)*uSectSize;

	//3ɾUser
	for(i = uStartNo;i <= uEndNo;i++)
		flash_erase(i);

	//4flash
	for(j = 0;j < uSectNo*(uSectSize/512);j++)  //ֿ鸴ƣÿ512ֽ
	{
		flash_read_physical(data,updateAddress+j*512,512);
		flash_write_physical(userAddress+j*512,512,data);
	}

//	//5ϵͳλ
//	NVIC_SystemReset();

	return 0;
}

//======================================================================
//ƣflagSet
//flagBuf:־;flag:־λ
//أ
//ܸҪλķʽñ־flagBuf[0]е8λֱ0~7״̬
//       flagBuf[1]е8λֱ8~15״̬...
//======================================================================
void flagSet(uint8_t *flagBuf,uint16_t flag)
{
	uint16_t i;
	uint8_t j;

	i = flag/8;  //־ֽ
	j = flag%8;  //ֽλ

	flagBuf[i] |= (1 << j);  //ñ־λ
}

//======================================================================
//ƣflagGet
//flagBuf:־;flag:־λ
//أflagλı־״̬
//ܸҪȡflagBufַʼĵflagλ״̬
//======================================================================
uint8_t flagGet(uint8_t *flagBuf,uint16_t flag)
{
	uint16_t i;
	uint8_t j;

	i = flag/8;  //־ֽ
	j = flag%8;  //ֽλ

	return flagBuf[i] & (1 << j);
}

//=========================================================================
//ƣupdateJudge
//˵
//أ0£1ڸ£2Զ̸£3User
//ܸҪи״̬жϣһȷǴڸ»Զ̸
//=========================================================================
uint8_t updateJudge()
{
    
	//1
	uint8_t uflag;     //½ձ־
	uint32_t msp;      //flashеջָ
	uint8_t rv;        //ֵ
	uint8_t buf[100];  //100ֽڴŷ
	uint16_t bufLen;   //ݳ

	rv = 0;  //Ĭ
	if (dynamic_cmd(gcRecvBuf,&gcRecvLen))  return 1;
	//2ǷҪи²
	if(strcmp((char*)gcUpdateFlag,"uart") == 0)  //дڸ²
	{
		gcUpdateFlag[0] = 0; //uart־
		//BIOSueupdate³ʼ
		ueupdate_init(GEC_USER_SECTOR_START,GEC_USER_SECTOR_END,MCU_SECTORSIZE);
		uflag = ueupdate_reinit((uint8_t*)gcRecvBuf,gcRecvLen);
		if(uflag == 1) //յ¿ʼ󣬷Ϣʾλɷ
		{
			ueupdate_backGet(buf,&bufLen);
			for (int ys=0;ys<4000;ys++) {__asm ( "nop");}   //ʱС2000ȡ4000
			emuart_sendN(bufLen,buf);  //Ϣ
		}
		gcRecvLen = 0;
		rv = 1;  //дڸ
	}
	else if(strcmp((char*)gcUpdateFlag,"RESET>=6") == 0)  //60Ƿ񰴡λť5
	{
		rv = 3;  //User
	}
	else if(strcmp((char*)gcUpdateFlag,"BIOSUPDA") == 0)  //BIOS
	{
		rv = 3;  //User
	}
	//-------------------
	else      //User
	{
		//ȡUserж׵ַ
		flash_read_logic((uint8_t*)&msp,GEC_USER_SECTOR_START,0,4);
		//жUserǷڣmspջûû
		if(msp == MCU_STACKTOP)  //User
		{
			rv = 0;  //ҴUser
		}
		else         //User
		{
			gcRecvLen = 0;
			rv = 3;  //User
		}
	}
	return rv;
}

