//ͷļ
#include "flash.h"
#include "string.h"
#if(USE_BIOS_FLASH==0)//1̳BIOS0ʹԴ
//=================ڲú=====================================
//======================================================================
//ƣflash_write_DoubleWord
//أ0-ɹ 1-ʧ
//˵addrĿַҪΪ4ıҴFlash׵ַ
//              磺0x08000004Flash׵ַΪ0x08000000
//       dataд˫
//ܸҪFlash˫д
//======================================================================
uint8_t flash_write_DoubleWord(uint32_t addr,uint32_t data_l,uint32_t data_h);
//======================================================================
//ƣflash_Best
//أ0-ɹ 1-ʧ
//˵sect:д
//			offset:дλõƫƵַ
//			Nдֽ
//			buf:дݵ׵ַ
//ܸҪλַµд
//======================================================================
uint8_t flash_Best(uint16_t sect,uint16_t offset,uint16_t N,uint8_t *buf);
//======================================================================
//======================================================================

//=================ⲿӿں=========================================
//======================================================================
//ƣflash_init
//أ
//˵
//ܸҪʼflashģ
//======================================================================
void flash_init(void)
{
    //֮ǰı̵µд־λ
	FLASH->SR &= 0xFFFFFFUL;
    //FlashƼĴ(CR)
    if((FLASH->CR & FLASH_CR_LOCK) != 0U)
    {
        FLASH->KEYR = (uint32_t)FLASH_KEY1;
        FLASH->KEYR = (uint32_t)FLASH_KEY2;
    }
    
    //ȴ֮ǰһflash
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    
    //ݻ
    FLASH->ACR &= ~FLASH_ACR_DCEN_Msk;
    //漴ʱλ
    FLASH->CR &= ~FLASH_CR_PG_Msk;
}
//======================================================================
//ƣflash_erase
//أִִ״̬0=1=쳣
//˵sectĿţΧȡʵоƬ STM32L433:0~127,ÿ2KB;
//ܸҪflash洢sect
//======================================================================
uint8_t flash_erase(uint16_t sect)
{
	
    //ȴ֮ǰһflash
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    //֮ǰı̵µд־λ
	FLASH->SR &= 0xFFFFFFUL;
    //漴ʱλ
    FLASH->CR &= ~FLASH_CR_PG;
    
    //ʹ
    FLASH->CR |= FLASH_CR_PER;
    //ò
    FLASH->CR &= ~FLASH_CR_PNB;
    FLASH->CR |= (uint32_t)(sect << 3u);
    //ʼ
    FLASH->CR |= FLASH_CR_STRT;
    //ȴ
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    //ֹ
    FLASH->CR &= ~FLASH_CR_PER;
    
    return 0;  //ɹ
}
//======================================================================
//ƣflash_write
//أִ״̬0=1=쳣
//˵sectţΧȡʵоƬ STM32L433:0~127,ÿ2KB
//        offset:дڲƫƵַ0~2044ҪΪ0,4,8,12......
//        NдֽĿ4~2048,ҪΪ4,8,12,......
//        bufԴݻ׵ַ
//ܸҪbufʼNֽд뵽flash洢sect offset
//=======================================================================
uint8_t flash_write(uint16_t sect,uint16_t offset,uint16_t N,uint8_t *buf)
{
    uint16_t i;
	
    //֮ǰı̵µд־λ
	FLASH->SR &= 0xFFFFFFUL;
	
    //дֽ
    if(offset+N>MCU_SECTORSIZE)
    {
        //дһ
        flash_write(sect,offset,MCU_SECTORSIZE-offset,buf);
        //дڶ
        flash_write(sect+1,0,N-(MCU_SECTORSIZE-offset),buf+(MCU_SECTORSIZE-offset));
    }
    //дֽ
    else
    {
//        //ǰַ˫ֶ룬ֱд
//        if(offset%8==0&&N%8==0)
//        {
//            flash_Best(sect,offset,N,buf);
//        }
//        //ǰַֻҪһ
//        else
//        {	
            uint8_t data[MCU_SECTORSIZE]; //洢ǰȫֵ
            flash_read_logic(data,sect,0,MCU_SECTORSIZE); //ǰȫֵ
            //ҪдնӦλд
            for(i = 0;i<N;i++)
            {
                data[offset+i] = buf[i];
            }
            //
            flash_erase(sect);
            //д
            flash_Best(sect,0,MCU_SECTORSIZE,data);
//        }
    }
    
	//ȴд
	while( (FLASH->SR & FLASH_SR_BSY) != 0U);
	return 0;  //ɹִ
}

//==========================================================================
//ƣflash_write_physical
//أִ״̬0=0=쳣
//˵ addrĿַҪΪ4ıҴFlash׵ַ
//              磺0x08000004Flash׵ַΪ0x08000000
//       cntдֽĿ8~512
//       bufԴݻ׵ַ
//ܸҪflashд
//==========================================================================
uint8_t flash_write_physical(uint32_t addr,uint16_t N,uint8_t buf[])
{
    uint16_t sect;   //
    uint16_t offset;	// ƫƵַ
    sect = (addr-MCU_FLASH_ADDR_START)/MCU_SECTORSIZE;
    offset = addr-(sect*MCU_SECTORSIZE)-MCU_FLASH_ADDR_START;
    flash_write(sect,offset,N,buf);
    
	//ȴд
	while( (FLASH->SR & FLASH_SR_BSY) != 0U);
	return 0;  //ɹִ
}

//======================================================================
//ƣflash_read_logic
//أ
//˵destݴŴַĿǴݣRAM
//       sectţΧȡʵоƬ STM32L433:0~127,ÿ2KB
//       offset:ڲƫƵַ0~2024ҪΪ0,4,8,12......
//       NֽĿ4~2048,ҪΪ4,8,12,......//
//ܸҪȡflash洢sect offsetʼNֽڣRAMdest
//=======================================================================
void flash_read_logic(uint8_t *dest,uint16_t sect,uint16_t offset,uint16_t N)
{
    uint8_t *src;
    src=(uint8_t *)(FLASH_BASE+sect*FLASH_PAGE_SIZE+offset);
    memcpy(dest,src,N);
}

//======================================================================
//ƣflash_read_physical
//أ
//˵destݴŴַĿǴݣRAM
//       addrĿַҪΪ4ı磺0x00000004
//       NֽĿ0~1020,ҪΪ48,12,......
//ܸҪȡflashַָ
//======================================================================
void flash_read_physical(uint8_t *dest,uint32_t addr,uint16_t N)
{
    uint8_t *src;
    src=(uint8_t *)addr;
    memcpy(dest,src,N);
}

//======================================================================
//ƣflash_protect
//أ
//˵M
//ܸҪflash
//======================================================================
void flash_protect(uint8_t M)
{
    uint32_t temp;
    temp = M|((M+1)<<16);
    if((FLASH->CR & FLASH_CR_OPTLOCK) != 0U)
    {
        FLASH->OPTKEYR = (uint32_t)FLASH_OPTKEY1;
        FLASH->OPTKEYR = (uint32_t)FLASH_OPTKEY2;
    }
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    //ؼĴ
    FLASH->WRP1AR &= 0x0;
    FLASH->WRP1AR |= temp;
    FLASH->CR |= FLASH_CR_OPTSTRT;
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    FLASH->CR &= ~FLASH_CR_OPTSTRT;

}


//======================================================================
//ƣflash_unprotect
//أ
//˵MⱣ
//ܸҪflashⱣ
//˵        
//======================================================================
void flash_unprotect(uint8_t M)
{
    uint32_t temp;
    
    temp = 0xff00ffff;
    
    if((FLASH->CR & FLASH_CR_OPTLOCK) != 0U)
    {
        FLASH->OPTKEYR = (uint32_t)FLASH_OPTKEY1;
        FLASH->OPTKEYR = (uint32_t)FLASH_OPTKEY2;
    }
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    //ؼĴ
    FLASH->WRP1AR &= 0x0;
    FLASH->WRP1AR |= temp;
    FLASH->CR |= FLASH_CR_OPTSTRT;
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    FLASH->CR &= ~FLASH_CR_OPTSTRT;
}

//======================================================================
//ƣflash_isempty
//أ1=ĿΪգ0=Ŀǿա
//˵Ҫ̽flashʼַ
//ܸҪflashпղ
//======================================================================

uint8_t flash_isempty(uint16_t sect,uint16_t N)
{
    uint16_t i,flag;
    uint8_t dest[N];
    uint8_t *src;
    flag = 1;
    src=(uint8_t *)(FLASH_BASE+sect*FLASH_PAGE_SIZE);
    memcpy(dest,src,N);
    for(i = 0; i<N; i++)   //ֽ
    {
        if(dest[i]!=0xff)   //ǿ
        {
            flag=0;
            break;
        }
    }
    return flag;
}
//========================================================================
//ƣflashCtl_isSectorProtected
//أ1=0=δ
//˵Ҫ
//ܸҪжflashǷ񱻱
//=========================================================================
uint8_t flash_isSectorProtected(uint16_t sect)
{
    uint8_t STRT,END;
    uint32_t temp;
    temp = FLASH->WRP1AR;
    STRT = temp;
    END = temp>>16;
    if(sect>=STRT && sect<END)
    return 1;
    
    temp = FLASH->WRP1BR;
    STRT = temp;
    END = temp>>16;
    if(sect>=STRT && sect<END)
    return 1;
    
    return 0;
}

//----------------------ΪڲŴ----------------------------
//======================================================================
//ƣflash_write_DoubleWord
//أ0-ɹ 1-ʧ
//˵addrĿַҪΪ4ıҴFlash׵ַ
//              磺0x08000004Flash׵ַΪ0x08000000
//       dataд˫
//ܸҪFlash˫дSTM32L433ÿֻʵ˫д룬дλ֣дλ֣
//======================================================================
uint8_t flash_write_DoubleWord(uint32_t addr,uint32_t data_l,uint32_t data_h)
{
    //ݻ
    if((FLASH->ACR & FLASH_ACR_DCEN) != 0U)
    {
        FLASH->ACR &= ~FLASH_ACR_DCEN;
    }
    
    //ʹFlashʱ
    FLASH->CR |= FLASH_CR_PG;
    
    //дλ
    *(__IO uint32_t*)addr = data_l;
    
    //дλ
    *(__IO uint32_t*)(addr+4U) = data_h;
    
    //ֹFlashʱ
    FLASH->CR &= ~FLASH_CR_PG;
    
    return 0;    //سɹ
}
#endif


//======================================================================
//ƣflash_Best
//أ0-ɹ 1-ʧ
//˵sect:д
//			offset:дλõƫƵַ
//			Nдֽ
//			buf:дݵ׵ַ
//ܸҪλַµд
//======================================================================
uint8_t flash_Best(uint16_t sect,uint16_t offset,uint16_t N,uint8_t *buf)
{
    uint32_t temp_l,temp_h;
    uint32_t addr;
    uint16_t i;
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    //˫дԵַ
    addr = (uint32_t)(FLASH_BASE+sect*FLASH_PAGE_SIZE+offset);
    //ѭд˫֣ÿ8дһ
    for(i = 0; i < N; i+=8)
    {
        //λֵָ
        temp_l = (uint32_t)((buf[i])|(buf[i+1]<<8)|(buf[i+2]<<16)|(buf[i+3]<<24));
        //λֵָ
        temp_h = (uint32_t)((buf[i+4])|(buf[i+5]<<8)|(buf[i+6]<<16)|(buf[i+7]<<24));
        //ھԵַ(addr+i)ʵ˫д
        flash_write_DoubleWord((addr+i),temp_l,temp_h);
    }
    while( (FLASH->SR & FLASH_SR_BSY) != 0U);
    return 0;
}






