//======================================================================
//ļƣuart.c
//ܸҪuartײԴļ
//ȨУݴѧǶʽϵͳо(sumcu.suda.edu.cn)
//¼¼2019-05-20 V1.0 GXY
//======================================================================
#include "uart.h"

#if(USE_BIOS_UART==0)//1̳BIOS0ʹԴ

USART_TypeDef *USART_ARR[] = {(USART_TypeDef*)USART1_BASE, 
              (USART_TypeDef*)USART2_BASE, (USART_TypeDef*)USART3_BASE};

//====崮IRQŶӦ====
IRQn_Type table_irq_uart[3] = {USART1_IRQn, USART2_IRQn, USART3_IRQn};
//ڲ
uint8_t uart_is_uartNo(uint8_t uartNo);

//======================================================================
//ƣuart_init
//ܸҪʼuartģ
//˵uartNo:ںţUART_1UART_2UART_3
//          baud:ʣ300600120024004800960019200115200...
//أ
//======================================================================
void uart_init(uint8_t uartNo, uint32_t baud_rate)
{
	uint16_t usartdiv; //BRRĴӦֵ
    //жϴ봮ںŲǷ,ֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		return;
	}

	//UARTģGPIOģΧʱӣʹŵUART
	switch(uartNo)
	{
	case UART_1:  //Ϊ1
#ifdef UART1_GROUP
		//ѡʹܶӦʱӣöӦΪUART_1
		switch(UART1_GROUP)
		{
		case 0:
			//ʹUSART1GPIOAʱ
			RCC->APB2ENR |= RCC_APB2ENR_USART1EN;
			RCC->AHB2ENR |= RCC_AHB2ENR_GPIOAEN;
			//ʹPTA9,PTA10ΪUSART(Tx,Rx)
			GPIOA->MODER &= ~(GPIO_MODER_MODE9|GPIO_MODER_MODE10);
			GPIOA->MODER |= (GPIO_MODER_MODE9_1|GPIO_MODER_MODE10_1);
			GPIOA->AFR[1] &= ~(GPIO_AFRH_AFSEL9|GPIO_AFRH_AFSEL10);
			GPIOA->AFR[1] |= ((GPIO_AFRH_AFSEL9_0 | GPIO_AFRH_AFSEL9_1 
			                 | GPIO_AFRH_AFSEL9_2)|(GPIO_AFRH_AFSEL10_0 
			                 | GPIO_AFRH_AFSEL10_1| GPIO_AFRH_AFSEL10_2));
			break;
		case 1:
			//ʹUSART1GPIOBʱ
			RCC->APB2ENR |= RCC_APB2ENR_USART1EN;
			RCC->AHB2ENR |= RCC_AHB2ENR_GPIOBEN;
			//ʹPTB6,PTB7ΪUSART(Tx,Rx)
			GPIOB->MODER &= ~(GPIO_MODER_MODE6|GPIO_MODER_MODE7);
			GPIOB->MODER |= (GPIO_MODER_MODE6_1|GPIO_MODER_MODE7_1);
			GPIOB->AFR[0] &= ~(GPIO_AFRL_AFSEL6|GPIO_AFRL_AFSEL7);
			GPIOB->AFR[0] |= ((GPIO_AFRL_AFSEL6_0 | GPIO_AFRL_AFSEL6_1 
			              | GPIO_AFRL_AFSEL6_2)	|(GPIO_AFRL_AFSEL7_0 
			              | GPIO_AFRL_AFSEL7_1 | GPIO_AFRL_AFSEL7_2));
			break;
		default:
			break;
		}
#endif
		break;

	case UART_2:  //Ϊ2
#ifdef UART2_GROUP
		//ѡʹܶӦʱӣöӦΪUART_2
		switch(UART2_GROUP)
		{
		case 0:
			//ʹUSART2GPIOAʱ
			RCC->APB1ENR1 |= RCC_APB1ENR1_USART2EN;
			RCC->AHB2ENR |= RCC_AHB2ENR_GPIOAEN;
			//ʹPTA2,PTA3ΪUSART(Tx,Rx)
			GPIOA->MODER &= ~(GPIO_MODER_MODE2|GPIO_MODER_MODE3);
			GPIOA->MODER |= (GPIO_MODER_MODE2_1|GPIO_MODER_MODE3_1);
			GPIOA->AFR[0] &= ~(GPIO_AFRL_AFSEL2|GPIO_AFRL_AFSEL3);
			GPIOA->AFR[0] |= ((GPIO_AFRL_AFSEL2_0 | GPIO_AFRL_AFSEL2_1 
			              | GPIO_AFRL_AFSEL2_2)	|(GPIO_AFRL_AFSEL3_0 
			              | GPIO_AFRL_AFSEL3_1 | GPIO_AFRL_AFSEL3_2));
			break;
		default:
			break;
		}
#endif
		break;

	case UART_3:  //Ϊ3
#ifdef UART3_GROUP
		//ѡʹܶӦʱӣöӦΪUART_3
		switch(UART3_GROUP)
		{
		case 0:
			//ʹUSART3GPIOBʱ
			RCC->APB1ENR1 |= RCC_APB1ENR1_USART3EN;
			RCC->AHB2ENR |= RCC_AHB2ENR_GPIOBEN;
			//ʹPTB10,PTB11ΪUSART(Tx,Rx)
			GPIOB->MODER &= ~(GPIO_MODER_MODE10|GPIO_MODER_MODE11);
			GPIOB->MODER |= (GPIO_MODER_MODE10_1|GPIO_MODER_MODE11_1);
			GPIOB->AFR[1] &= ~(GPIO_AFRH_AFSEL10|GPIO_AFRH_AFSEL11);
			GPIOB->AFR[1] |= ((GPIO_AFRH_AFSEL10_0 | GPIO_AFRH_AFSEL10_1 
			              | GPIO_AFRH_AFSEL10_2)|(GPIO_AFRH_AFSEL11_0 
			              | GPIO_AFRH_AFSEL11_1 | GPIO_AFRH_AFSEL11_2));
			break;
		case 1:
			//ʹUSART3GPIOCʱ
			RCC->APB1ENR1 |= RCC_APB1ENR1_USART3EN;
			RCC->AHB2ENR |= RCC_AHB2ENR_GPIOCEN;
			//ʹPTC10,PTC11ΪUSART(Tx,Rx)
			GPIOC->MODER &= ~(GPIO_MODER_MODE10|GPIO_MODER_MODE11);
			GPIOC->MODER |= (GPIO_MODER_MODE10_1|GPIO_MODER_MODE11_1);
			GPIOC->AFR[1] &= ~(GPIO_AFRH_AFSEL10|GPIO_AFRH_AFSEL11);
			GPIOC->AFR[1] |= ((GPIO_AFRH_AFSEL10_0 | GPIO_AFRH_AFSEL10_1 
			              | GPIO_AFRH_AFSEL10_2)|(GPIO_AFRH_AFSEL11_0 
			              | GPIO_AFRH_AFSEL11_1 | GPIO_AFRH_AFSEL11_2));
			break;
		default:
			break;
		}
#endif
		break;
	}
	//ʱUART
	USART_ARR[uartNo-1]->CR1 &= ~USART_CR1_UE;
	//ʱرմڷչ
	USART_ARR[uartNo-1]->CR1 &= ~(USART_CR1_TE_Msk|USART_CR1_RE_Msk);
	//ôڲ
	if((USART_ARR[uartNo-1]->CR1 & USART_CR1_OVER8_Msk) == USART_CR1_OVER8_Msk)
	    usartdiv = (uint16_t)((SystemCoreClock/baud_rate)*2);
	else
	    usartdiv = (uint16_t)(SystemCoreClock/baud_rate);
	USART_ARR[uartNo-1]->BRR = usartdiv;
	//ʼƼĴж״̬Ĵ־λ
	USART_ARR[uartNo-1]->ISR = 0;
	USART_ARR[uartNo-1]->CR2 &= ~(USART_CR2_LINEN | USART_CR2_CLKEN);
	USART_ARR[uartNo-1]->CR3 &= ~(USART_CR3_SCEN | USART_CR3_HDSEL 
	                            | USART_CR3_IREN);
	//ڷչ
	USART_ARR[uartNo-1]->CR1 |= (USART_CR1_TE|USART_CR1_RE);
	//UART
	USART_ARR[uartNo-1]->CR1 |= USART_CR1_UE;
}

//======================================================================
//ƣuart_send1
//˵uartNo: ں:UART_1UART_2UART_3
//          ch:Ҫ͵ֽ
//أִ״̬1=ͳɹ0=ʧܡ
//ܸҪз1ֽ
//======================================================================
uint8_t uart_send1(uint8_t uartNo, uint8_t ch)
{
	uint32_t t;

	//жϴ봮ںŲǷֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		return 0;
	}

	for (t = 0; t < 0xFBBB; t++)//ѯָ
	{
		//ͻΪ
		if ( USART_ARR[uartNo-1]->ISR & USART_ISR_TXE_Msk )
		{
			USART_ARR[uartNo-1]->TDR = ch;
			break;
		}
	}//end for
	if (t >= 0xFBBB)
		return 0; //ͳʱʧ
	else
		return 1; //ɹ
}

//======================================================================
//ƣuart_sendN
//˵uartNo: ں:UART_1UART_2UART_3
//         buff: ͻ
//         len:ͳ
//أ ִ״̬1=ͳɹ0=ʧ
//ܸҪ nֽ
//======================================================================
uint8_t uart_sendN(uint8_t uartNo ,uint16_t len ,uint8_t* buff)
{
    uint16_t i;

    //жϴ봮ںŲǷֱ˳
    if(!uart_is_uartNo(uartNo))
    {
        return 0;
    }

    for (i = 0; i < len; i++)
    {
        if (!uart_send1(uartNo, buff[i])) //һֽݣʧѭ
        {
            break;
        }
    }
    if(i<len)
        return 0;    //ͳ
    else
        return 1;    //ͳ
}

//======================================================================
//ƣuart_send_string
//˵uartNo:UARTģ:UART_1UART_2UART_3
//          buff:Ҫ͵ַ׵ַ
//أ ִ״̬1=ͳɹ0=ʧ
//ܸҪָUART˿ڷһ'\0'ַ
//======================================================================
uint8_t uart_send_string(uint8_t uartNo, uint8_t* buff)
{
    uint16_t i = 0;
    uint8_t *buff_ptr = (uint8_t *)buff;     //ָָҪַ׵ַ

    //жϴ봮ںŲǷֱ˳
    if(!uart_is_uartNo(uartNo))
    {
        return 0;
    }

    for(i = 0; buff_ptr[i] != '\0'; i++)   //ַַ
    {
        if (!uart_send1(uartNo,buff_ptr[i]))//ָӦַ
            return 0;  //ʧ,
    }
    return 1;          //ͳɹ
}

//======================================================================
//ƣuart_re1
//˵uartNo: ں:UART_1UART_2UART_3
//        *fp:ճɹ־ָ:*fp=1:ճɹ*fp=0:ʧ
//أշֽ
//ܸҪн1ֽ
//======================================================================
uint8_t uart_re1(uint8_t uartNo,uint8_t *fp)
{
    uint32_t t;
    uint8_t  dat;

	//жϴ봮ںŲǷֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		*fp=0;
		return 0;
	}

	for (t = 0; t < 0xFBBB; t++)//ѯָ
	{
		//жϽջǷ
		if (USART_ARR[uartNo-1]->ISR & USART_ISR_RXNE_Msk)
		{
			dat=USART_ARR[uartNo-1]->RDR;    //ȡ,жλ
			*fp = 1;  //ճɹ
			break;
		}
	}//end for
	if(t >= 0xFBBB)
	{
		dat = 0xFF;
		*fp = 0;    //δյ
	}
	return dat;    //ؽյ
}

//======================================================================
//ƣuart_reN
//˵uartNo: ں:UART_1UART_2UART_3
//          buff: ջ
//          len:ճ
//أִ״̬ 1=ճɹ;0=ʧ
//ܸҪ nֽ,buff
//======================================================================
uint8_t uart_reN(uint8_t uartNo ,uint16_t len ,uint8_t* buff)
{
	uint16_t i;
	uint8_t flag = 0;

	//жϴ봮ںŲǷֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		return 0;
	}

	//жǷܽ
	for (i = 0; i < len && flag==1; i++)
	{
		buff[i] = uart_re1(uartNo, &flag); //
	}
	if (i < len)
		return 0; //ʧ
	else
		return 1; //ճɹ
}

//======================================================================
//ƣuart_enable_re_int
//˵uartNo: ں:UART_1UART_2UART_3
//أ
//ܸҪڽж
//======================================================================
void uart_enable_re_int(uint8_t uartNo)
{
	//жϴ봮ںŲǷֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		return;
	}

	USART_ARR[uartNo-1]->CR1 |= USART_CR1_RXNEIE_Msk;    //UARTж
	NVIC_EnableIRQ(table_irq_uart[uartNo-1]);    //жϿIRQж
}

//======================================================================
//ƣuart_disable_re_int
//˵uartNo: ں :UART_1UART_2UART_3
//أ
//ܸҪشڽж
//======================================================================
void uart_disable_re_int(uint8_t uartNo)
{
	//жϴ봮ںŲǷֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		return;
	}

	USART_ARR[uartNo-1]->CR1 &= ~USART_CR1_RXNEIE_Msk;    //ֹUARTж
	NVIC_DisableIRQ(table_irq_uart[uartNo-1]);    //ֹжϿIRQж
}

//======================================================================
//ƣuart_get_re_int
//˵uartNo: ں :UART_1UART_2UART_3
//أжϱ־ 1=нж;0=޽ж
//ܸҪȡڽжϱ־,ͬʱ÷ж
//======================================================================
uint8_t uart_get_re_int(uint8_t uartNo)
{
	//жϴ봮ںŲǷֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		return 0;
	}

	//ȡжϱ־ͬʱжRXNERXNEIE
	if(((USART_ARR[uartNo-1]->ISR & USART_ISR_RXNE_Msk) == USART_ISR_RXNE_Msk)
			&& ((USART_ARR[uartNo-1]->CR1 & USART_CR1_RXNEIE_Msk) == USART_CR1_RXNEIE_Msk))
		return 1;
	else
		return 0;
}


//======================================================================
//ƣuart_deinit
//˵uartNo: ں :UART_1UART_2UART_3
//أ
//ܸҪuartʼرմʱ
//======================================================================
void uart_deinit(uint8_t uartNo)
{
	//жϴ봮ںŲǷ,ֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		return;
	}

	//UARTģGPIOģΧʱӣʹŵUART
	switch(uartNo)
	{
	case UART_1:  //Ϊ1
#ifdef UART1_GROUP
		//ѡرնӦʱӣֹӦΪUART_1
		switch(UART1_GROUP)
		{
		case 0:
			//رUSART1GPIOAʱ
			RCC->APB2ENR &= ~RCC_APB2ENR_USART1EN;
			RCC->AHB2ENR &= ~RCC_AHB2ENR_GPIOAEN;
			//ֹPTA9,PTA10ΪUSART(Tx,Rx)
			GPIOA->MODER &= ~(GPIO_MODER_MODE9|GPIO_MODER_MODE10);
			GPIOA->AFR[1] &= ~(GPIO_AFRH_AFSEL9|GPIO_AFRH_AFSEL10);
			break;
		case 1:
			//رUSART1GPIOBʱ
			RCC->APB2ENR &= ~RCC_APB2ENR_USART1EN;
			RCC->AHB2ENR &= ~RCC_AHB2ENR_GPIOBEN;
			//ֹPTB6,PTB7ΪUSART(Tx,Rx)
			GPIOB->MODER &= ~(GPIO_MODER_MODE6|GPIO_MODER_MODE7);
			GPIOB->AFR[0] &= ~(GPIO_AFRL_AFSEL6|GPIO_AFRL_AFSEL7);
			break;
		default:
			break;
		}
#endif
		break;

	case UART_2:  //Ϊ2
#ifdef UART2_GROUP
		//ѡرնӦʱӣֹӦΪUART_2
		switch(UART2_GROUP)
		{
		case 0:
			//رUSART2GPIOAʱ
			RCC->APB1ENR1 &= ~RCC_APB1ENR1_USART2EN;
			RCC->AHB2ENR &= ~RCC_AHB2ENR_GPIOAEN;
			//ֹPTA2,PTA3ΪUSART(Tx,Rx)
			GPIOA->MODER &= ~(GPIO_MODER_MODE2|GPIO_MODER_MODE3);
			GPIOA->AFR[0] &= ~(GPIO_AFRL_AFSEL2|GPIO_AFRL_AFSEL3);
			break;
		default:
			break;
		}
#endif
		break;

	case UART_3:  //Ϊ3
#ifdef UART3_GROUP
		//ѡرնӦʱӣֹӦΪUART_3
		switch(UART3_GROUP)
		{
		case 0:
			//رUSART3GPIOBʱ
			RCC->APB1ENR1 &= ~RCC_APB1ENR1_USART3EN;
			RCC->AHB2ENR &= ~RCC_AHB2ENR_GPIOBEN;
			//ֹPTB10,PTB11ΪUSART(Tx,Rx)
			GPIOB->MODER &= ~(GPIO_MODER_MODE10|GPIO_MODER_MODE11);
			GPIOB->AFR[1] &= ~(GPIO_AFRH_AFSEL10|GPIO_AFRH_AFSEL11);
			break;
		case 1:
			//رUSART3GPIOCʱ
			RCC->APB1ENR1 &= ~RCC_APB1ENR1_USART3EN;
			RCC->AHB2ENR &= ~RCC_AHB2ENR_GPIOCEN;
			//ֹPTC10,PTC11ΪUSART(Tx,Rx)
			GPIOC->MODER &= ~(GPIO_MODER_MODE10|GPIO_MODER_MODE11);
			GPIOC->AFR[1] &= ~(GPIO_AFRH_AFSEL10|GPIO_AFRH_AFSEL11);
			break;
		default:
			break;
		}
#endif
		break;
	}
}

//----------------------ΪڲŴ--------------------------------------
//=====================================================================
//ƣuart_is_uartNo
//أ1:ںںΧڣ0ںŲ
//˵ںuartNo  :UART_1UART_2UART_3
//ܸҪΪ׳ԶжuartNoǷڴַΧ
//=====================================================================
uint8_t uart_is_uartNo(uint8_t uartNo)
{
    if(uartNo < UART_1 || uartNo > UART_3)
        return 0;
    else
        return 1;
}

#endif
