#ifndef __LCD_H
#define __LCD_H

#include "mcu.h"
#include "gpio.h"
#include "wdog.h"
#include "gec.h"
#include "spi.h"
/******************************************************
߷ʽ
VCC=3.3V
GND=GND
PD5=RES
PD4=DC
PD1=CLK
PD2=MOSI
BLK,MISOԲ
******************************************************/

#define LCD_RS    (PTB_NUM|4)    //LCDλ
#define LCD_DC    (PTB_NUM|5)    //LCD/
#define LCD_SCK   (PTB_NUM|13)    //LCDʱ
#define LCD_SDI   (PTB_NUM|15)    //LCD
#define LCD_CS    (PTB_NUM|6)    //ģSPICS

#define LCD_SPI  SPI_2

//LCDĳߴ磨240*320أ
#define LCD_W 240    
#define LCD_H 320

//=====================================================================
//ƣLcd_Init
//أ
//˵
//ܸҪLCDʼ
//޸ļ¼˻2018723գó飬LCD_Init
//=====================================================================
void LCD_Init(void);    //LCDʼ

//=====================================================================
//ƣLCD_Clear
//أ
//˵background:ɫʹñļ󻭱ɫ궨壩
//ܸҪLCD
//=====================================================================
void LCD_Clear(uint16_t background);    //LCD

//=====================================================================
//ƣLCD_DrawPoint
//أ
//˵x,y:(240*320),
//       color:ɫʹñļ󻭱ɫ궨壩
//ܸҪָλûһ
//=====================================================================
void LCD_DrawPoint(uint16_t x,uint16_t y,uint16_t color);    //

//=====================================================================
//ƣLCD_DrawPoint_big
//أ
//˵x,y:(240*320)
//       color:ɫʹñļ󻭱ɫ궨壩
//ܸҪָλûһ,ķΧʵһx-1,y-1ΪϽ⣬x+1,y+1Ϊ½ǵС
//       9㣨3*3Ĵ㡣
//=====================================================================
void LCD_DrawPoint_big(uint16_t x,uint16_t y,uint16_t color);    //һ

//=====================================================================
//ƣDraw_Circle
//أ
//˵x,y:ĵ(240*320),
//       r:Բİ뾶,
//       color:ɫʹñļ󻭱ɫ궨壩
//ܸҪָλûһָСԲ
//=====================================================================
void LCD_DrawCircle(uint16_t x,uint16_t y,uint8_t r,uint16_t color);  //Բ

//=====================================================================
//ƣLCD_DrawLine
//أ
//˵x1,y1:(240*320),x2,y2:յ(240*320),
//       color:ɫʹñļ󻭱ɫ궨壩
//ܸҪָ仭һָɫֱ
//=====================================================================
void LCD_DrawLine(uint16_t x1,uint16_t y1,
	 uint16_t x2, uint16_t y2,uint16_t color);    //

//=====================================================================
//ƣLCD_DrawRectangle
//أ
//˵x1,y1:Ͻǵ(240*320),x2,y2:½ǵ(240*320),
//       color:ɫʹñļ󻭱ɫ궨壩
//ܸҪָϽ½ǻһָɫľ
//=====================================================================
void LCD_DrawRectangle(uint16_t x1, uint16_t y1,
     uint16_t x2, uint16_t y2,uint16_t color);    //

//=====================================================================
//ƣLCD_DrawSurface
//أ
//˵x1,y1:(240*320),x2,y2:յ(240*320),
//       color:ɫʹñļ󻭱ɫ궨壩
//ܸҪָɫ
//=====================================================================
void LCD_DrawSurface(uint16_t x1,uint16_t y1,
     uint16_t x2,uint16_t y2,uint16_t color);    //

//ƣLCD_ShowCharactor
//أ
//˵x,y:(240*320),indexֿе,fontcolor:ɫ,
//       groundbackcolor:ɫp:ֿʼַ
//ܸҪָλʾһ(16*16С),Ҫдֿȡ
//=====================================================================
void LCD_ShowCharactor(uint16_t  x,uint16_t y,uint16_t fontcolor,
	 uint16_t groundbackcolor,const char *p);    //ʾ16*16


//ƣLCD_ShowString
//أ
//˵x,y:(240*320),p:ַʼַ԰ģӦںģУ
//       color:ɫʹñļ󻭱ɫ궨壩
//ܸҪָλʾַָʾɫͱɫ
//                   ĴСΪ16*16,ӢĴСΪ8*16
//=====================================================================
void LCD_ShowString(uint16_t  x,uint16_t y,uint16_t fontcolor,
	 uint16_t groundbackcolor,const char *p);

//=====================================================================
//ƣLCD_aotu
//أ
//˵x,y:(240*320),x1,y1:½(240*320)
//ܸҪָλʾһ͹ť
//=====================================================================
void LCD_aotu(uint16_t x,uint16_t y,uint16_t x1,uint16_t y1,uint8_t s); //͹ť

// ------------------  ģݽṹ ------------------------ //
typedef struct typFNT_GB16                 // ģݽṹ
{
       signed char Index[2];               // 
       char Msk[32];                              // 
} typFNT_GB16;

//=====================================================================
//struct _HEADCOLOR
//scan: ɨģʽ
//Bit7: 0:ɨ裬1:ɨ衣
//Bit6: 0:Զɨ裬1:Եɨ衣
//Bit5: 0:ֽݴӸλλУ1:ֽݴӵλλС
//Bit4: 0:WORD͸ߵλֽ˳PCͬ1:WORD͸ߵλֽ˳PC෴
//Bit3~2: 
//Bit1~0: [00]ˮƽɨ裬[01]ֱɨ裬[10]ˮƽ,ֽڴֱ[11]ݴֱ,ֽˮƽ
//gray: Ҷֵ
// 1:ɫ2:Ļң4:ʮң8:256ɫ12:4096ɫ16:16λɫ24:24λɫ32:32λɫ
//w: ͼĿȡ
//h: ͼĸ߶ȡ
//is565: 4096ɫģʽΪ0ʾʹ[16bits(WORD)]ʽʱͼÿWORDʾһأ
//Ϊ1ʾʹ[12bits(ֽ)]ʽʱеÿ12Bitsһء
//16λɫģʽΪ0ʾR G BɫռõλΪ5BitsΪ1ʾR G Bɫռõλ
//ֱΪ5Bits,6Bits,5Bits
//18λɫģʽΪ0ʾ"6Bits in Low Byte"Ϊ1ʾ"6Bits in High Byte"
//24λɫ32λɫģʽis565Ч
//rgb: R G Bɫ˳rgbÿ2Bitsʾһɫ[00]ʾհף[01]ʾ
//Red[10]ʾGreen[11]ʾBlue
//=====================================================================
typedef struct _HEADCOLOR
{
   unsigned char scan;
   unsigned char gray;
   unsigned short w;
   unsigned short h;
   unsigned char is565;
   unsigned char rgb;
}HEADCOLOR;


void LCD_WR_DATA8(uint8_t da); //-8λ
void Address_set(uint16_t x1,uint16_t y1,uint16_t x2,uint16_t y2);

//ɫ


#define WHITE       0xFFFF
#define BLACK       0x0000
#define BLUE        0x001F
#define BRED        0XF81F
#define GRED        0XFFE0
#define GBLUE       0X07FF
#define RED         0xF800
#define MAGENTA     0xF81F
#define GREEN       0x07E0
#define CYAN        0x7FFF
#define YELLOW      0xFFE0
#define BROWN       0XBC40  //ɫ
#define BRRED       0XFC07  //غɫ
#define GRAY        0X8430  //ɫ

//GUIɫ
#define DARKBLUE      0X01CF   //ɫ
#define LIGHTBLUE     0X7D7C   //ǳɫ
#define GRAYBLUE      0X5458   //ɫ
//ɫΪPANELɫ

#define LIGHTGREEN    0X841F  //ǳɫ
#define LGRAY         0XC618  //ǳɫ(PANNEL),屳ɫ

#define LGRAYBLUE     0XA651  //ǳɫ(мɫ)
#define LBBLUE        0X2B12  //ǳɫ(ѡĿķɫ)

//=====================================================================
// ------------------  ASCIIģݱ ------------------------
// 0x20~0x7e
//ȥǰ32޷ʾַ
//=====================================================================
const static char  nAsciiDot[] =              // ASCII
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // (գ
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x18,0x3C,0x3C,0x3C,0x18,0x18,  //!̾ţ
	0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00,

	0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,  //"˫ţ
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x36,0x36,0x7F,0x36,0x36,  //#ţ
	0x36,0x7F,0x36,0x36,0x00,0x00,0x00,0x00,

	0x18,0x18,0x3E,0x63,0x43,0x03,0x3E,0x60,  //$Ԫ
	0x61,0x63,0x3E,0x18,0x18,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x43,0x63,0x30,0x18,  //%ٷֺţ
	0x0C,0x06,0x63,0x61,0x00,0x00,0x00,0x00,

	0x00,0x00,0x1C,0x36,0x36,0x1C,0x6E,0x3B,  //&룩
	0x33,0x33,0x33,0x6E,0x00,0x00,0x00,0x00,

	0x00,0x0C,0x0C,0x0C,0x06,0x00,0x00,0x00,  //'ţ
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x30,0x18,0x0C,0x0C,0x0C,0x0C,  //(ţ
	0x0C,0x0C,0x18,0x30,0x00,0x00,0x00,0x00,

	0x00,0x00,0x0C,0x18,0x30,0x30,0x30,0x30,  //)ţ
	0x30,0x30,0x18,0x0C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x66,0x3C,0xFF,  //*Ǻţ
	0x3C,0x66,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7E,  //+Ӻţ
	0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //,ţ
	0x00,0x18,0x18,0x18,0x0C,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,  //-ţ
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //.㣩
	0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x18,  ///бܣ
	0x0C,0x06,0x03,0x01,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3E,0x63,0x63,0x73,0x6B,0x6B,  //00
	0x67,0x63,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x18,0x1C,0x1E,0x18,0x18,0x18,  //11
	0x18,0x18,0x18,0x7E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3E,0x63,0x60,0x30,0x18,0x0C,  //22
	0x06,0x03,0x63,0x7F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3E,0x63,0x60,0x60,0x3C,0x60,  //33
	0x60,0x60,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x30,0x38,0x3C,0x36,0x33,0x7F,  //44
	0x30,0x30,0x30,0x78,0x00,0x00,0x00,0x00,

	0x00,0x00,0x7F,0x03,0x03,0x03,0x3F,0x70,  //55
	0x60,0x60,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x1C,0x06,0x03,0x03,0x3F,0x63,  //66
	0x63,0x63,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x7F,0x63,0x60,0x60,0x30,0x18,  //77
	0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3E,0x63,0x63,0x63,0x3E,0x63,  //88
	0x63,0x63,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3E,0x63,0x63,0x63,0x7E,0x60,  //99
	0x60,0x60,0x30,0x1E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,  //:ðţ
	0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,  //;ֺţ
	0x00,0x18,0x18,0x0C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x06,  //<Сںţ
	0x0C,0x18,0x30,0x60,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,  //=ںţ
	0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,  //>ںţ
	0x30,0x18,0x0C,0x06,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3E,0x63,0x63,0x30,0x18,0x18,  //?ʺţ
	0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x3E,0x63,0x63,0x7B,0x7B,  //@ط
	0x7B,0x3B,0x03,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x08,0x1C,0x36,0x63,0x63,0x7F,  //AĸA
	0x63,0x63,0x63,0x63,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3F,0x66,0x66,0x66,0x3E,0x66,  //BĸB
	0x66,0x66,0x66,0x3F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3C,0x66,0x43,0x03,0x03,0x03,  //CĸC
	0x03,0x43,0x66,0x3C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x1F,0x36,0x66,0x66,0x66,0x66,  //DĸD
	0x66,0x66,0x36,0x1F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x7F,0x66,0x46,0x16,0x1E,0x16,  //EĸE
	0x06,0x46,0x66,0x7F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x7F,0x66,0x46,0x16,0x1E,0x16,  //FĸF
	0x06,0x06,0x06,0x0F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3C,0x66,0x43,0x03,0x03,0x7B,  //GĸG
	0x63,0x63,0x66,0x5C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x63,0x63,0x63,0x63,0x7F,0x63,  //HĸH
	0x63,0x63,0x63,0x63,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,  //IĸI
	0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x78,0x30,0x30,0x30,0x30,0x30,  //JĸJ
	0x33,0x33,0x33,0x1E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x67,0x66,0x36,0x36,0x1E,0x1E,  //KĸK
	0x36,0x66,0x66,0x67,0x00,0x00,0x00,0x00,

	0x00,0x00,0x0F,0x06,0x06,0x06,0x06,0x06,  //LĸL
	0x06,0x46,0x66,0x7F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x63,0x77,0x7F,0x7F,0x6B,0x63,  //MĸM
	0x63,0x63,0x63,0x63,0x00,0x00,0x00,0x00,

	0x00,0x00,0x63,0x67,0x6F,0x7F,0x7B,0x73,  //NĸN
	0x63,0x63,0x63,0x63,0x00,0x00,0x00,0x00,

	0x00,0x00,0x1C,0x36,0x63,0x63,0x63,0x63,  //OĸO
	0x63,0x63,0x36,0x1C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3F,0x66,0x66,0x66,0x3E,0x06,  //PĸP
	0x06,0x06,0x06,0x0F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3E,0x63,0x63,0x63,0x63,0x63,  //QĸQ
	0x63,0x6B,0x7B,0x3E,0x30,0x70,0x00,0x00,

	0x00,0x00,0x3F,0x66,0x66,0x66,0x3E,0x36,  //RĸR
	0x66,0x66,0x66,0x67,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3E,0x63,0x63,0x06,0x1C,0x30,  //SĸS
	0x60,0x63,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,  //TĸT
	0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x63,0x63,0x63,0x63,0x63,0x63,  //UĸU
	0x63,0x63,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x63,0x63,0x63,0x63,0x63,0x63,  //VĸV
	0x63,0x36,0x1C,0x08,0x00,0x00,0x00,0x00,

	0x00,0x00,0x63,0x63,0x63,0x63,0x63,0x6B,  //WĸW
	0x6B,0x7F,0x36,0x36,0x00,0x00,0x00,0x00,

	0x00,0x00,0x63,0x63,0x36,0x36,0x1C,0x1C,  //XĸX
	0x36,0x36,0x63,0x63,0x00,0x00,0x00,0x00,

	0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x18,  //YĸY
	0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x7F,0x63,0x61,0x30,0x18,0x0C,  //ZĸZ
	0x06,0x43,0x63,0x7F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,  //[ţ
	0x0C,0x0C,0x0C,0x3C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x01,0x03,0x07,0x0E,0x1C,  //\бܣ
	0x38,0x70,0x60,0x40,0x00,0x00,0x00,0x00,

	0x00,0x00,0x3C,0x30,0x30,0x30,0x30,0x30,  //]ţ
	0x30,0x30,0x30,0x3C,0x00,0x00,0x00,0x00,

	0x08,0x1C,0x36,0x63,0x00,0x00,0x00,0x00,  //^˷ȷ
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //_»ߣ
	0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,

	0x0C,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,  //`
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x1E,0x30,0x3E,  //aĸa
	0x33,0x33,0x33,0x6E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x07,0x06,0x06,0x1E,0x36,0x66,  //bĸb
	0x66,0x66,0x66,0x3B,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x3E,0x63,0x03,  //cĸc
	0x03,0x03,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x38,0x30,0x30,0x3C,0x36,0x33,  //dĸd
	0x33,0x33,0x33,0x6E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x3E,0x63,0x7F,  //eĸe
	0x03,0x03,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x1C,0x36,0x26,0x06,0x0F,0x06,  //fĸf
	0x06,0x06,0x06,0x0F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x6E,0x33,0x33,  //gĸg
	0x33,0x33,0x33,0x3E,0x30,0x33,0x1E,0x00,

	0x00,0x00,0x07,0x06,0x06,0x36,0x6E,0x66,  //hĸh
	0x66,0x66,0x66,0x67,0x00,0x00,0x00,0x00,

	0x00,0x00,0x18,0x18,0x00,0x1C,0x18,0x18,  //iĸi
	0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x60,0x60,0x00,0x70,0x60,0x60,  //jĸj
	0x60,0x60,0x60,0x60,0x66,0x66,0x3C,0x00,

	0x00,0x00,0x07,0x06,0x06,0x66,0x36,0x1E,  //kĸk
	0x1E,0x36,0x66,0x67,0x00,0x00,0x00,0x00,

	0x00,0x00,0x1C,0x18,0x18,0x18,0x18,0x18,  //lĸl
	0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x37,0x7F,0x6B,  //mĸm
	0x6B,0x6B,0x6B,0x6B,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x3B,0x66,0x66,  //nĸn
	0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x3E,0x63,0x63,  //oĸo
	0x63,0x63,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x3B,0x66,0x66,  //pĸp
	0x66,0x66,0x66,0x3E,0x06,0x06,0x0F,0x00,

	0x00,0x00,0x00,0x00,0x00,0x6E,0x33,0x33,  //qĸq
	0x33,0x33,0x33,0x3E,0x30,0x30,0x78,0x00,

	0x00,0x00,0x00,0x00,0x00,0x3B,0x6E,0x46,  //rĸr
	0x06,0x06,0x06,0x0F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x3E,0x63,0x06,  //sĸs
	0x1C,0x30,0x63,0x3E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x08,0x0C,0x0C,0x3F,0x0C,0x0C,  //tĸt
	0x0C,0x0C,0x6C,0x38,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x33,0x33,0x33,  //uĸu
	0x33,0x33,0x33,0x6E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,  //vĸv
	0x66,0x66,0x3C,0x18,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x63,0x63,0x63,  //wĸw
	0x6B,0x6B,0x7F,0x36,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x63,0x36,0x1C,  //xĸx
	0x1C,0x1C,0x36,0x63,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x63,0x63,0x63,  //yĸy
	0x63,0x63,0x63,0x7E,0x60,0x30,0x1F,0x00,

	0x00,0x00,0x00,0x00,0x00,0x7F,0x33,0x18,  //zĸz
	0x0C,0x06,0x63,0x7F,0x00,0x00,0x00,0x00,

	0x00,0x00,0x70,0x18,0x18,0x18,0x0E,0x18,  //{ţ
	0x18,0x18,0x18,0x70,0x00,0x00,0x00,0x00,

	0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,  //|ߣ
	0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,

	0x00,0x00,0x0E,0x18,0x18,0x18,0x70,0x18,  //}Ҵţ
	0x18,0x18,0x18,0x0E,0x00,0x00,0x00,0x00,

	0x00,0x00,0x6E,0x3B,0x00,0x00,0x00,0x00,  //~˺ţ
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x08,0x1C,0x36,0x63,  //ո
	0x63,0x63,0x7F,0x00,0x00,0x00,0x00,0x00,
};

 //=====================================================================
  // ģ
  // ֿ: 壨16*16 ȡģҸλ,:Ҵϵ
  // ֱ
  //     «
  //=====================================================================
#define ChineseCharacterLength (sizeof(GB_16)/sizeof(typFNT_GB16))   //¼ֵĸ
const static typFNT_GB16  GB_16[] =         // ݱ
{
	{{""}, {0x80,0x00,0x80,0x00,0x40,0x01,0x20,0x02,
	0x10,0x04,0x08,0x0A,0xF4,0x77,0x83,0x20,
	0x80,0x00,0xF8,0x0F,0x80,0x00,0x88,0x08,
	0x90,0x04,0xA0,0x12,0xFE,0x3F,0x00,0x00}},

	{{""}, {0x20,0x02,0x20,0x22,0xFF,0x7F,0x20,0x02,
	0x10,0x3E,0x90,0x22,0xFE,0x23,0x10,0x3E,
	0x50,0x22,0xFC,0x22,0x44,0x3E,0x44,0x22,
	0x44,0x22,0x7C,0x22,0x44,0x29,0x80,0x10}},

	{{"«"}, {0x10,0x04,0x10,0x24,0xFF,0x7F,0x10,0x04,
	0x80,0x10,0xFC,0x3F,0x04,0x10,0x04,0x10,
	0xFC,0x1F,0x04,0x10,0x04,0x00,0x04,0x00,
	0x04,0x00,0x02,0x00,0x02,0x00,0x01,0x00}}
};


#endif

