//======================================================================
//ļƣadc.c
//ṩݴѧǶʽ(sumcu.suda.edu.cn)
//汾£2019-9-20 V1.1
//̵<01_Doc>ļReadme.txtļ
//======================================================================
#include "includes.h"

//======================================================================
//ƣadc_init
//ܸҪʼһADͨɼģʽ
//˵ChannelͨţѡΧADC_CHANNEL_VREFINT
//         ADC_CHANNEL_TEMPSENSORADC_CHANNEL_x(1=<x<=16)ADC_CHANNEL_VBAT
//         diffѡ=1(AD_DIFF 1)֣=0(AD_SINGLE);
//         ˣADC_CHANNEL_VREFINTADC_CHANNEL_TEMPSENSORADC_CHANNEL_VBAT
//         ǿΪˣADC_CHANNEL_x(1=<x<=16)ѡ˻߲ģʽ
//======================================================================

void adc_init(uint16_t Channel,uint8_t Diff)
{
    //1ADCʱӣƵ=ʱ/4,48MHzADCʱӲ14MHz
    RCC->AHB2ENR |= RCC_AHB2ENR_ADCEN;
    ADC1_COMMON->CCR |= ADC_CCR_CKMODE;
    //2˳״̬ʹѹ,ADCĬϴڵ״̬Խ͹
    ADC1->CR &= ~ADC_CR_DEEPPWD;
    ADC1->CR |= ADC_CR_ADVREGEN;
    //3ʹADCڲɼ
    if(Channel == 0)
    {
        ADC1_COMMON->CCR |= ADC_CCR_VREFEN;  //ʹܲοѹɼ
    }
    else if(Channel == 17)
    {
        ADC1_COMMON->CCR |= ADC_CCR_TSEN;    //ʹ¶Ȳɼ
    }
    else if(Channel == 18)
    {
        ADC1_COMMON->CCR |= ADC_CCR_VBATEN;  //ʹܻ׼ѹɼ
    }
    
    //4ʼADCƼĴ,λ
    ADC1->CR &= 0x3fffffc0;
    //5˲ѡ
    if (Diff)
    {
        BSET(Channel,ADC1->DIFSEL);  
    }
    else
    {
        BCLR(Channel,ADC1->DIFSEL);	
    }
    
    //6ADC
    ADC1->CR |= ADC_CR_ADEN;
    //7òʱΪ12.5ʱ
    if((int)Channel >= 0 && (int)Channel <= 9 )
    {
        BCLR(Channel*3,ADC1->SMPR1);
        BSET(Channel*3+1,ADC1->SMPR1);
        BCLR(Channel*3+2,ADC1->SMPR1);
    }
    if((int)Channel >= 10 && (int)Channel <= 18 )
    {
        BCLR((Channel%10)*3,ADC1->SMPR2);
        BSET((Channel%10)*3+1,ADC1->SMPR2);
        BCLR((Channel%10)*3+2,ADC1->SMPR2);
    }
    //8üĴCFGR12λҶ롢εͨת
    ADC1->CFGR &= 0xffffffe7;         //Ϊ12λ
    ADC1->CFGR &= 0xffffffdf;         //ݶ뷽ʽҶ
    ADC1->CFGR |= ADC_CFGR_DISCEN;    //תģʽ
    ADC1->CFGR &= ~ADC_CFGR_CONT;     //תģʽ
    ADC1->CFGR &= ~ADC_CFGR_DISCNUM;  //һͨ
    ADC1->CFGR &= ~ADC_CFGR_EXTEN;    //ֹӲ
    //11ͨгΪ1
    ADC1->SQR1 &= ~ADC_SQR1_L;	   
}

//============================================================================
//ƣadc_read
//ܸҪʼһADͨŲɼģʽ
//˵diffѡ=1(AD_DIFF 1)֣=0(AD_SINGLE);
//         ˣDC_CHANNEL_VREFINTADC_CHANNEL_TEMPSENSORADC_CHANNEL_VBAT
//         ǿΪˣADC_CHANNEL_x(1=<x<=16)ѡ˻߲ģʽ
//============================================================================
uint16_t adc_read(uint8_t Channel)
{
    uint16_t ADCResult;   //ڴADֵ
    int i,t;
    ADCResult=0;
    //1ADC,ʹѹ
    ADC1->CR |= ADC_CR_ADEN;
    ADC1->CR |= ADC_CR_ADVREGEN;
    //2յһת
    ADC1->SQR1 &= 0xFFFFF83F; 
    //3ѡͨһת
    ADC1->SQR1 |=((uint32_t)Channel<<6);
    //4ʼת
    ADC1->CR |= ADC_CR_ADSTART;
    //5ȴתɣȡת
    for (i=0;i<=50;i++) __asm("nop");
    for (t = 0; t < 0xFBBB; t++)//ѯָ
    {
        //жתǷ
        if (BGET(2,ADC1->ISR)==1)  //ת
        {
            ADCResult = ADC1->DR;   //ȡ,תɱ־λ
            break;
        }
    } 
    return ADCResult;
}




////============================================================================
////ƣTempRegression
////ܸҪĻ¶ADֵתΪʵ¶
////˵tmpADͨadc_readõADֵ
////أʵ¶ֵ
////============================================================================
//float TempRegression(uint16_t tmpAD)
//{
//    float v1,v2,S,T;
//    v1 = ((float)tmpAD*3300)/4096;   //ADֵΪѹ(mV)
//    v2=3300 - v1;                    //ѹ˵ѹ(mV)
//    S = v1/v2;                       //ѹ
//    T = (1/(log(S)/3950.0 + (1/(273.15 + 25)))) - 273.15 + 0.5;
//    return T;
//}


//============================================================================
//ƣTempTrans
//ܸҪmcu¶ADֵתΪʵ¶
//˵mcu_temp_ADͨadc_readõADֵ
//أʵ¶ֵ
//============================================================================
float TempTrans(uint16_t mcu_temp_AD)
{
	float mcu_temp_result;
	mcu_temp_result=(float)(55+(100*((float)(mcu_temp_AD) - AD_CAL1))/(AD_CAL2 - AD_CAL1));
	return mcu_temp_result;
}
