//======================================================================
//ļƣwifi.cwifiԴļ
//λմarm(sumcu.suda.edu.cn)
//¼¼20190513
//======================================================================
#include "wifi.h"
#include "stdio.h"
#include "string.h"
#include "printf.h"

//wifiָ
#define WIFI_MODE_SET "AT+CWMODE="
#define WIFI_LINK_AP  "AT+CWJAP="         //AP
#define WIFI_QUIT_AP  "AT+WJAPQ\r"      //ϿAP
#define WIFI_DHCP     "AT+WDHCP=ON\r"     //DHCP

//wifi͸
#define WIFI_CIP_MODE0 "+++\r" //͸ģʽ
#define WIFI_CIP_MODE1 "AT+CIPSENDRAW\r" //͸ģʽ

//wifiָͨ
#define WIFI_STATUS "AT+CIPSTATUS\r\n"    //ѯ״̬
#define WIFI_START "AT+CIPSTART="         //
#define WIFI_CLOSE "AT+CIPSTOP=1\r"      //ر
#define WIFI_SEND "AT+CIPSEND\r\n"        //ָ
#define WIFI_PING "AT+PING="              //pingָip
#define WIFI_DOMAIN_RESOLVE "AT+CIPDOMAIN="  //

//ͨŲúͲѯָ
#define WIFI_STA_MAC_Q "AT+CIPSTAMAC?\r\n"//ѯstationģʽµmacַ
#define WIFI_STA_MAC_S "AT+CIPSTAMAC="    //stationģʽµmacַ
#define WIFI_STA_IP    "AT+CIPSTA="       //stationģʽµIPַ
#define WIFI_SET_AP    "AT+CWSAP="        //APģʽĲ

//ģʽ
#define WIFI_RECV_DATA 0
#define WIFI_RECV_CMD  1
#define WIFI_RECV_RST  2

//͸ģʽ
#define WIFI_NONE_PASS_THROUGH 0
#define WIFI_PASS_THROUGH 1

//Դ
#define WIFI_ON  1
#define WIFI_OFF 0

//ڲʹ
uint8_t wifi_send_cmd(uint8_t* cmdstring);
uint8_t wifi_check_mac(uint8_t* mac);
uint8_t wifi_check_ip(uint8_t* ip);
uint8_t wifi_check_port(uint8_t* port);
uint8_t wifi_disconnect();
uint8_t wifi_mode_set(uint8_t modetype);
uint8_t wifi_set_send_mode(uint8_t mode);
uint8_t wifi_set_ap_para(uint8_t* ssid,uint8_t* pssword,uint8_t chn);
void wifi_power_ctr(uint8_t state);
void wifi_frameEncode(uint8_t *imsi,uint8_t *data,uint16_t dlen,
                 uint8_t *frame,uint16_t *framelen);
uint8_t wifi_rebootcheck(uint8_t ch);
uint8_t uecom_recv(uint8_t ch,uint16_t *dataLen, uint8_t *data);
uint8_t wifi_returncheck(uint8_t ch);
uint16_t crc16(uint8_t *ptr,uint16_t len);

//WIFI ָͨȫֱ
static uint8_t  WIFI_CMD[400];   //ݽջ
static uint16_t WIFI_CMDLENGTH;  //ǰַȣ\0ַ
static uint8_t  WIFI_CMD_FLAG;


static uint8_t  WIFI_RECVSTOP;    //ģʽ־

static uint8_t  WIFI_ERR_STOP[16]; //ʧ֡β
static uint8_t  WIFI_OK_STOP[21]; //ɹ֡β

//֡ȫֱ
static uint8_t frameHead[2] = "V!"; //֡ͷ
static uint8_t frameTail[2] = "S$"; //֡β

static uint8_t MODE_TYPE;
static uint8_t WIFI_CONNECT_STATE;  //״̬
static uint8_t WIFI_AP_STATE;       //WIFI״̬
static uint8_t WIFI_SEND_STATE;     //WIFIģʽ
static uint8_t WIFI_BOOTFLAG;
MAC WIFI_MAC;
//======================================================================
//ƣwifi_init
//ܸҪʼwifiģ
//˵mode_type:ģΪͻ˻AP;
//         mode_name:ģAPģʽµSSID;
//         pssword:Ҫõַ64λASCIIַ;
//         chn:wifiŵţ1~13ֻ1611ŵ;
//         ip:Wi-FiģSTAģʽµIPַ,Ϊ0.0.0.0ʾDHCP
//أ
//======================================================================
void wifi_init(uint8_t mode_type,uint8_t* mode_name,uint8_t* pssword,uint8_t chn,uint8_t* ip)
{
	//ֲ
	//1.ʼȫֱ
	WIFI_RECVSTOP = 0;                     //ģʽ־
	WIFI_CMDLENGTH = 0;                    //س
	WIFI_CONNECT_STATE=0;                  //TCP״̬
	WIFI_AP_STATE=0;                       //Wi-Fi״̬
	WIFI_SEND_STATE=0;                     //͸ģʽ·ģʽ״̬־
	WIFI_BOOTFLAG = 0;                     //ɱ־
	WIFI_CMD_FLAG = 0;                     //״̬־
	//2.ʼͨôڲWIFIԴ
	uart_init(UART_WIFI,115200);           //ʼͨŴڣ115200
	uart_enable_re_int(UART_WIFI);         //򿪴ڽж
	gpio_init(POWER_PIN,GPIO_OUTPUT,0);
	WIFI_RECVSTOP = 2;                     //õǰģʽ
	wifi_power_ctr(WIFI_ON);               //Wi-FiģԴ
	//for(;!WIFI_BOOTFLAG;);                 //ȴ
	//3.ģ鹤
	strcpy((char*)WIFI_OK_STOP,"OK");              //ùʽɹ֡βOK
	strcpy((char*)WIFI_ERR_STOP,"ERROR");          //ùʽʧ֡βOK
	switch(mode_type)
	{
	    //3.1 óSTAģʽ,ֻAP
	    case WIFI_STATION:
	    	while(wifi_mode_set(WIFI_STATION));     //Wi-FiģΪSTAģʽ
	    	MODE_TYPE = 0;                          //ǵǰģʽΪSTAģʽ
	    	wifi_send_cmd((uint8_t*)"AT+CWAUTOCONN=1\r\n");   //wifiģԶ
	    	//STAģʽIP
	    	if(wifi_check_ip(ip))
	    	{
	    		//ipֵΪ"0.0.0.0"
	    		if(ip[0] == '0' && ip[1] == '.' &&
	    		ip[2] == '0' && ip[3] == '.' &&
				ip[4] == '0' && ip[5] == '.' && ip[6] == '0')
	    		{
	    			wifi_send_cmd((uint8_t*)WIFI_DHCP);       //DHCP
	    		}
	    		else
	    			wifi_set_ip(ip);                //Ϊ̶IP
	    	}
	    	else
	    		wifi_send_cmd((uint8_t*)WIFI_DHCP);
	    	break;
	    //3.2 óAPģʽ,ֻΪAP豸
	    case WIFI_AP:
	    	while(wifi_mode_set(WIFI_AP));            //Wi-FiģΪAPģʽ
	    	wifi_set_ap_para(mode_name,pssword,chn);  //APģʽSSID͹ŵ
	    	MODE_TYPE = 1;                            //ǵǰģʽΪAPģʽ
	    	break;
	    //3.3 óɻģʽ,ȿAPҲΪAP
	    case WIFI_ST_AP:
		    while(wifi_mode_set(WIFI_ST_AP));         //Wi-FiģΪģʽ
		    wifi_set_ap_para(mode_name,pssword,chn);  //ûģʽAPSSID͹ŵ
		    MODE_TYPE = 2;                            //ǵǰģʽΪģʽ
	    	if(wifi_check_ip(ip))
	    	{
	    		//ipֵΪ"0.0.0.0"
	    		if(ip[0] == '0' && ip[1] == '.' &&
	    		ip[2] == '0' && ip[3] == '.' &&
				ip[4] == '0' && ip[5] == '.' && ip[6] == '0')
	    		{
	    			wifi_send_cmd((uint8_t*)WIFI_DHCP);
	    		}
	    		else
	    			wifi_set_ip(ip);
	    	}
	    	else
	    		wifi_send_cmd((uint8_t*)WIFI_DHCP);
		    break;
	    default:
	    	return;
	}
	//4.ģ
	wifi_reset();
}

//======================================================================
//ƣwifi_reset
//ܸҪWi-Fiģ
//˵
//أ
//======================================================================
void wifi_reset()
{
	//1.ʼȫֱ
	WIFI_RECVSTOP = 0;                     //ģʽ־
	WIFI_CMDLENGTH = 0;                    //س
	WIFI_CONNECT_STATE=0;                  //TCP״̬
	WIFI_AP_STATE=0;                       //Wi-Fi״̬
	WIFI_SEND_STATE=0;                     //͸ģʽ·ģʽ״̬־
	WIFI_BOOTFLAG = 0;                     //ɱ־
	WIFI_CMD_FLAG = 0;                     //״̬־
	uart_init(UART_WIFI,115200);           //ʼͨŴڣ115200
	uart_enable_re_int(UART_WIFI);         //򿪴ڽж
	//2.
	//2.1 ɹ֡βʧ֡β
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
	//2.2 ر
	wifi_send_cmd((uint8_t*)"AT+UARTE=OFF\r");
	//2.3 رջط¼
	wifi_send_cmd((uint8_t*)"AT+CIPEVENT=OFF\r");
}

//======================================================================
//ƣwifi_resolve_domain
//ܸҪap󣬽
//˵domain:,retVal:ŵĻ
//أǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_resolve_domain(uint8_t* domain,uint8_t* retVal)
{
	uint8_t flag,*cmd;
	uint16_t i;
	cmd=malloc((sizeof(domain)-1)+(sizeof(WIFI_DOMAIN_RESOLVE)-1)+5);
	if(cmd==NULL)
		return WIFI_ERROR;
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
	sprintf((char*)cmd,"%s\"%s\"\r\n",WIFI_DOMAIN_RESOLVE,domain);
	flag=wifi_send_cmd(cmd);
	free(cmd);
	for(i=0;i<WIFI_CMDLENGTH;i++)
		retVal[i]=WIFI_CMD[i];
	return flag;
}

//======================================================================
//ƣwifi_ping
//ܸҪappingָipҲ
//˵address:ҪpingĿַ,timepingͨʱ
//أǷpingͨ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_ping(uint8_t* address,uint8_t* time)
{
	uint8_t flag,*cmd;
	uint16_t i;
	cmd=malloc((sizeof(address)-1)+(sizeof(WIFI_PING)-1)+5);
	if(cmd==NULL)
		return WIFI_ERROR;
	sprintf((char*)cmd,"%s\"%s\"\r\n",WIFI_PING,address);
	flag=wifi_send_cmd(cmd);
	free(cmd);
	if(flag==WIFI_OK)
		for(i=0;i<WIFI_CMDLENGTH;i++)
			time[i]=WIFI_CMD[i];
	return flag;
}

//======================================================================
//ƣwifi_get_mac
//ܸҪȡmac
//˵mac:ػȡmacֵ
//أȡɹ1ʧܷ0
//======================================================================
uint8_t wifi_get_mac(MAC* mac)
{
	uint8_t *addr,i;
	wifi_send_cmd((uint8_t*)"AT+CIFSR\r\n");
	addr=(uint8_t*)strstr((char*)WIFI_CMD,(char*)"APMAC");
	if(addr!=NULL)
	{
		i=0;
		addr+=7;
		while(*addr!='\"')
	    {
			WIFI_MAC.apmac[i++]=*addr;
			addr++;
		}
		WIFI_MAC.apmac[i]='\0';
	}
	addr=(uint8_t*)strstr((char*)WIFI_CMD,(char*)"STAMAC");
    if(addr!=NULL)
    {
	    i=0;
	    addr+=8;
	    while(*addr!='\"')
	    {
	    	WIFI_MAC.stamac[i++]=*addr;
		    addr++;
	    }
	    WIFI_MAC.stamac[i]='\0';
    }
	switch(MODE_TYPE)
	{
	    case 0:strcpy((char*)mac,(char*)WIFI_MAC.stamac);break;
	    case 1:strcpy((char*)mac,(char*)WIFI_MAC.apmac);break;
	    case 2:strcpy((char*)mac->stamac,(char*)WIFI_MAC.stamac);
	           strcpy((char*)mac->apmac,(char*)WIFI_MAC.apmac);
	           break;
	    default:return 0;
	}
	return 1;
}


//======================================================================
//ƣwifi_int_re
//ܸҪжϽַ
//˵ch:Ҫַܵ*dataLen:洢յݳȣ
//      *data:յݴŵ;
//أ
//======================================================================
void wifi_int_re(uint8_t ch,uint16_t *dataLen, uint8_t *data)
{
	//ֲ
	//1.WIFI_ACKSTOPʱָ
	switch(WIFI_RECVSTOP)
	{
	    //ݽģʽ
	    case 0:uecom_recv(ch,dataLen,data);
	    	break;
	    //ؽģʽ
	    case 1:if(WIFI_CMDLENGTH<400)
               {
 	               wifi_returncheck(ch);
 	               WIFI_CMD[WIFI_CMDLENGTH+1]=0;
               }
	    	   break;
	    //ģʽ
	    case 2:WIFI_BOOTFLAG = wifi_rebootcheck(ch);
	           if(WIFI_BOOTFLAG)
	        	   WIFI_RECVSTOP = 0;
	           break;                        //ȴ
	    case 3:
	    break;
	}
}

//======================================================================
//ƣwifi_get_state
//ܸҪȡģ״̬
//˵
//أ=0δWIFIͷ,=1WIFIδӷ,=3WIFIͷ
//======================================================================
uint8_t wifi_get_state()
{
	return (WIFI_CONNECT_STATE<<1)|(WIFI_AP_STATE);
}

//======================================================================
//ƣwifi_linktossid
//ܸҪָwifi
//˵ssid:,password:
//أǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_linktossid(uint8_t* ssid,uint8_t* password)
{
	//ֲ
	uint8_t cmd[40],flag;
	//2.֡β
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
	strcpy((char*)cmd,"AT+WJAP=");
	strcat((char*)cmd,(char*)ssid);
	strcat((char*)cmd,",");
	strcat((char*)cmd,(char*)password);
	strcat((char*)cmd,"\r");
	//3.ָ
	flag=wifi_send_cmd(cmd);
	if(flag==WIFI_NORESPONSE)
		wifi_send_cmd((uint8_t*)"AT+WJAP=?\r");
	if(strstr((char*)WIFI_CMD,(char*)WIFI_OK_STOP)!=NULL)
		flag=WIFI_OK;
	if(flag==WIFI_OK)
		WIFI_AP_STATE=1;
	return (flag);
}

//======================================================================
//ƣwifi_quitssid
//ܸҪϿwifi
//˵
//أϿǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_quitssid()
{
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
	return (wifi_send_cmd((uint8_t*)WIFI_QUIT_AP));
}

//======================================================================
//ƣwifi_con_srv
//ܸҪ
//˵ip:IPַ,port:˿ںţΪַʽ,
//       ʽ"xxx.xxx.xxx.xxx",xxxȡֵΧ0-255
//أ=0ӳɹ,=1ʧ,=2ڷģʽ
//======================================================================
uint8_t wifi_con_srv(uint8_t* ip,uint8_t* port)
{
	//ֲ
	uint8_t flag,cmd[100];
	//1.wifiģ鵱ǰ״̬Ƿڷģʽ
	if(WIFI_SEND_STATE==1)
		return 2;
	//2.ipַǷϷ
	if(!wifi_check_ip(ip))
		return WIFI_ERROR;
	//3.portֵǷϷ
	if(!wifi_check_port(port))
	    return WIFI_ERROR;
	//4.֡β
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
	//5.Ͽ
	wifi_disconnect();
	//6.ƴָ

	port[5]=0;
	strcpy((char*)cmd,(char*)WIFI_START);
	strcat((char*)cmd,"1,tcp_client,");
	strcat((char*)cmd,(char*)(ip));
	strcat((char*)cmd,",");
	strcat((char*)cmd,(char*)(port));
	strcat(((char*)cmd),"\r");

	//7.ָ
	flag=wifi_send_cmd(cmd);
	return flag;
}

//======================================================================
//ƣwifi_sendN
//ܸҪӽNַ,ǵһη,Ὺģʽ,
//ģʽ󲿷ֺ᲻,뿴˵
//˵data:Ҫ͵ַ,length:ݳ,IMSI:IMSI
//أǷɹ=0ɹ,=1ģʽʧ
//======================================================================
uint8_t wifi_sendN(uint8_t* data,uint16_t length,uint8_t* IMSI)
{
	uint8_t buf[400], cmd[20], strlength[5];
	if(WIFI_SEND_STATE==0)
	{
		//3.ƴӷ֡β
		strcpy((char*)WIFI_OK_STOP,"OK");
		strcpy((char*)WIFI_ERR_STOP,"ERROR");
		WIFI_SEND_STATE=1;
	}

	wifi_frameEncode(IMSI,data,length,buf,&length);
	//5.
	itoa(length,(char*)strlength,10);
	strcpy((char*)cmd,"AT+CIPSEND=1,");
	strcat((char*)cmd,(char*)strlength);
	strcat((char*)cmd,"\r");
	uart_send_string(UART_WIFI,(uint8_t*)cmd);
	uart_sendN(UART_WIFI,length,buf);
	return WIFI_OK;
}

//======================================================================
//ƣwifi_set_ip
//ܸҪstaģʽWiFiģIPַ
//˵ip:ҪõIPַ
//أ=0óɹ=1ʧܣ=2WiFiģӦ
//======================================================================
uint8_t wifi_set_ip(uint8_t* ip)
{
	uint8_t cmd[30];
	if(!wifi_check_ip(ip))
	{
		return WIFI_ERROR;
	}
	sprintf((char*)cmd,"%s\"%s\"\r\n",WIFI_STA_IP,ip);
	return wifi_send_cmd(cmd);
}



//===========================ڲ====================================
//======================================================================
//ƣwifi_check_port
//ܸҪ˿ںǷϷ
//˵port:ҪĶ˿ںַ,˿ںŷΧӦΪ0-65535
//أ=1Ϸ=0Ϸ
//======================================================================
uint8_t wifi_check_port(uint8_t* port)
{
	//ֲ
	uint8_t length,maxlength;
	uint32_t num;
	maxlength=5;    //˿ַ5
	for(length=0,num=0;*port!='\0'&&length<maxlength;length++)
	{
		//µnumֵ򷵻0
		if(*port>='0'&&*port<='9')
			num=num*10+(*port-'0');
		else return 0;
		port++;
	}
	//0
	if(length>maxlength)
		return 0;
	//˿ֵΧ
	if(num>65535)
		return 0;
	return 1;
}

//======================================================================
//ƣwifi_check_ip
//ܸҪipַǷϷ
//˵ip:Ҫipַַ,ʽ"xxx.xxx.xxx.xxx",xxxȡֵΧ0-255
//أ=1Ϸ=0Ϸ
//======================================================================
uint8_t wifi_check_ip(uint8_t* ip)
{
	//ֲ
	uint8_t i,j,maxlength;           //iӿ,j¼ӿ鳤
	uint16_t length,num[4];
	//ʼֲ
	for(i=0;i<4;i++)
		num[i]=0;
	maxlength=15;
	//1.鳤ȲipַзֳĿ
	for(length=0,i=0,j=0;*ip!='\0'&&length<=maxlength;length++)
	{
		if(*ip=='.')
		{
			if(j==0||j>3)
				return 0;
			i++;                     //ӿʶһ
			j=0;                     //ӿ鳤㿪ʼһӿ
		}
		else if(*ip>='0'&&*ip<='9')
		{
			num[i]=num[i]*10+(*ip-'0');
			j++;                     //ǰӿ鳤+1
		}
		else return 0;               //⵽ַ0
		ip++;                        //ת¸ַ
	}
	if(length>maxlength)             //,0
		return 0;
	//2.ӿǷСڵ255
	for(i=0;i<4;i++)
	{
		if(!(num[i]<256))            //⵽255ӿ,0
			return 0;
	}
	return 1;                        //,1
}

//======================================================================
//ƣwifi_check_mac
//ܸҪmacֵǷϷ
//˵mac:macֵ
//أ=1Ϸ=0Ϸ
//======================================================================
uint8_t wifi_check_mac(uint8_t* mac)
{
	uint8_t flag,i;
	flag=1;
	for(i=0;i<17;i++)
	{
		if((i+1)%3==0)
		{
			if(mac[i]!=':')
			{
				flag=0;
				break;
			}
		}
		else
			if(!((mac[i]>='0'&&mac[i]<='9')||
			(mac[i]>='a'&&mac[i]<='f')))
			{
				flag=0;
				break;
			}
	}
	return flag;
}


//======================================================================
//ƣwifi_disconnect
//ܸҪϿtcpudp
//˵
//أϿǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_disconnect()
{
	//1.ƴ֡β
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
	//2.Ͽ
    return wifi_send_cmd((uint8_t*)WIFI_CLOSE);
}

//======================================================================
//ƣwifi_mode_set
//ܸҪWIFIӦģʽ
//˵modetype:Ӧģʽ,=1 Stationģʽ
//                      =2 APģʽ
//                      =3 ģʽ
//أģʽǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_mode_set(uint8_t modetype)
{
	uint8_t cmd[14];
	if(modetype<1||modetype>3)
		return WIFI_ERROR;
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
	sprintf((char*)cmd,"%s%d\r\n",WIFI_MODE_SET,modetype);
	return (wifi_send_cmd(cmd));
}

//======================================================================
//ƣwifi_send_cmd
//ܸҪwifiģжϿܹWiFiģӦ
//˵cmdstring:ַ
//أͺwifiģӦ״̬=0ɹ=1=2Ӧ
//======================================================================
uint8_t wifi_send_cmd(uint8_t* cmdstring)
{
	//ֲ
	vuint32_t i;
	//1.ʼȫֱ
	WIFI_CMDLENGTH = 0;
	WIFI_CMD_FLAG = 0;
	WIFI_RECVSTOP = WIFI_RECV_CMD;
	//2.򴮿ڷָ
	uart_send_string(UART_WIFI,cmdstring);
	i=0;
	//3.ɹ״̬ʧ״̬
	while(1)
	{
		//3.1 ɹ״̬
		if(WIFI_CMD_FLAG == 1)
		{
			WIFI_RECVSTOP = WIFI_RECV_DATA;    //жϽģʽΪݽģʽ
			return WIFI_OK;                    //ɹ־WIFI_OK0
		}
		//3.2 ʧ״̬
		else if(WIFI_CMD_FLAG == 2)
		{
			WIFI_RECVSTOP = WIFI_RECV_DATA;    //жϽģʽΪݽģʽ
			return WIFI_ERROR;                 //ʧܱ־WIFI_ERROR1
		}
		i++;                                   //ƴα־һ
		//3.3 ʱ
		if(i>0xffffff)
		{
			WIFI_RECVSTOP = WIFI_RECV_DATA;    //жϽģʽΪݽģʽ
			return WIFI_NORESPONSE;            //ʱ־WIFI_NORESPONSE2
		}
	}
}

//======================================================================
//ƣwifi_set_send_mode
//ܸҪģ鷢ģʽ,ʹtcpݱʹ͸ģʽ
//˵mode:ģʽѡ=0͸ģʽ=1͸ģʽ
//         WIFI_NONE_PASS_THROUGH 0
//         WIFI_PASS_THROUGH 1
//أǷɹ=0سɹ=1ʧܣ=2سʱ
//======================================================================
uint8_t wifi_set_send_mode(uint8_t mode)
{
	//ֲ
	uint8_t flag;            //ر־
    //1.ɹ֡βʧ֡β
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
	//2.жmodeֵӦֵͶӦ䣬mode01򷵻ʧ
    switch(mode)
	{
		case 0:flag=wifi_send_cmd((uint8_t*)WIFI_CIP_MODE0);break;    //=0ر͸ģʽ
		case 1:flag=wifi_send_cmd((uint8_t*)WIFI_CIP_MODE1);break;    //=1͸ģʽ
		default:return WIFI_ERROR;                          //ʧ
	}
	return flag;
}

//======================================================================
//ƣwifi_set_ap_para
//ܸҪģAPģʽµĲSSIDAPŵ
//˵ssid:Ҫõssidַ,pssword:Ҫõַ64λ
//         ASCIIַ,chn:wifiŵţ1~13ֻ1611ŵ
//أǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_set_ap_para(uint8_t* ssid,uint8_t* pssword,uint8_t chn)
{
	uint8_t flag,*cmd;
    //1.ɹ֡βʧ֡β
	strcpy((char*)WIFI_OK_STOP,"OK");
	strcpy((char*)WIFI_ERR_STOP,"ERROR");
    //2.ƴָ
	cmd=malloc(sizeof(ssid)+sizeof(pssword)+20);
	sprintf((char*)cmd,"%s\"%s\",\"%s\",%d,4\r\n",WIFI_SET_AP,ssid,pssword,chn);
	flag=wifi_send_cmd(cmd);
	free(cmd);
	return flag;
}

//====================================================================
//ƣwifi_power_ctr
//ܸҪwifiԴ
//˵state:WIFI_ON(1):򿪵Դ,WIFI_OFF(0):رյԴ
//أ
//====================================================================
void wifi_power_ctr(uint8_t state)
{
	if(state==WIFI_ON)
		gpio_set(POWER_PIN,1);
	else
		gpio_set(POWER_PIN,0);
}

//====================================================================
//ƣwifi_frameEncode
//ܸҪʵִݵ֡,ݼ֡ͷ֡֡βԼУϢ
//       frame=֡ͷ+IMSI+data+data+CRCУ+֡β
//˵imsiݵ豸IMSI
//       data:֡ͷָ
//       dlen:֡ݳ
//       frame:֮֡Ĵ֡
//       framelen:֡ݳ
//أ
//====================================================================
void wifi_frameEncode(uint8_t *imsi,uint8_t *data,uint16_t dlen,
                 uint8_t *frame,uint16_t *framelen)
{
    uint16_t crc,len;

    //֡
    //֡ͷ
    frame[0] = frameHead[0];
    frame[1] = frameHead[1];
    len = 2;
    //IMSI
    strncpy((char *)(frame+2),(const char *)imsi,15);
    len += 15;
    //data
    frame[len++] = (uint8_t)(dlen>>8);
    frame[len++] = (uint8_t)dlen;
    //data
    memcpy(frame+19,data,dlen);
    len += dlen;
    //CRCУ
    crc = crc16(frame+2,dlen+17);//IMSIšdataȺdataCRCУ
    frame[len++] = (uint8_t)(crc>>8);
    frame[len++] = (uint8_t)crc;
    //֡β
    frame[len++] = (uint8_t)frameTail[0];
    frame[len++] = (uint8_t)frameTail[1];
    frame[len] = 0;
    *framelen = len;
}

//====================================================================
//ƣwifi_returncheck
//أ1⵽أ0:δ⵽
//˵chڽյ(1ֽ)
//ܸҪWi-FiģǷ
//====================================================================
uint8_t wifi_returncheck(uint8_t ch)
{
    static uint8_t index1 = 0;   //ɹ֡
    static uint8_t index2 = 0;   //󷵻֡
    static uint8_t len1 = 0;     //ɹ֡
    static uint8_t len2 = 0;     //󷵻֡
    uint8_t ret_val;
    //״νģʽ
    if(WIFI_CMDLENGTH == 0)
    {
    	len1 = strlen((char*)WIFI_OK_STOP);
    	len2 = strlen((char*)WIFI_ERR_STOP);
    	index1 = 0;
    	index2 = 0;
    }
    WIFI_CMD[WIFI_CMDLENGTH++] = ch;
    if((index1 == 0 && ch!=WIFI_OK_STOP[0])&&(index2 == 0 && ch!=WIFI_ERR_STOP[0]))
    {
    	ret_val = 0;
    	goto wifi_returncheck_exit;
    }
    ret_val = 0;
    if(ch == WIFI_OK_STOP[index1])
    	index1++;
    else if(ch == WIFI_OK_STOP[0])
    	index1 = 1;
    if(ch == WIFI_ERR_STOP[index2])
    	index2++;
    else if(ch == WIFI_ERR_STOP[0])
    	index2 = 1;
    if(index1 == len1)
    {
    	ret_val = 1;
    	WIFI_CMD_FLAG = 1;
    	goto wifi_returncheck_exit;
    }
    if(index2 == len2)
    {
    	ret_val = 1;
    	WIFI_CMD_FLAG = 2;
    }
wifi_returncheck_exit:
    return ret_val;
}


//====================================================================
//ƣwifi_rebootcheck
//أ1⵽ɣ0:δ⵽
//˵chڽյ(1ֽ)
//ܸҪWi-FiģǷ
//====================================================================
uint8_t wifi_rebootcheck(uint8_t ch)
{
	//ֲ
    static uint8_t index1 = 0;   //֡
    static uint8_t bootflag[5] = "ready";   //Ϣ֡β
    uint8_t ret_val;
    //Ĵʹ˴gotoΪ˾ٴִ֤жܹʱӦ
    //1.û֡βеһַ
    if(index1 == 0 && ch != bootflag[0])
    {
    	ret_val = 0;
    	goto wifi_rebootcheck_exit;
    }
    //2.֡βĵһַ
    if(ch==bootflag[0])
    {
    	ret_val = 0;
    	index1 = 1;
    	goto wifi_rebootcheck_exit;
    }
    //3.֡βĵڶַ
    if(index1 == 1 && ch == bootflag[1])
    {
    	ret_val = 0;
    	index1 = 2;
    	goto wifi_rebootcheck_exit;
    }
    //4.֡βĵַ
    if(index1 == 2 && ch == bootflag[2])
    {
        ret_val = 0;
        index1 = 3;
        goto wifi_rebootcheck_exit;
    }
    //5.֡βĵĸַ
    if(index1 == 3 && ch == bootflag[3])
    {
        ret_val = 0;
        index1 = 4;
        goto wifi_rebootcheck_exit;
    }
    //6.֡βĵַ
    if(index1 == 4 && ch == bootflag[4])
    {
        ret_val = 1;                     //֡βеַȫ⵽
        index1 = 0;
        goto wifi_rebootcheck_exit;
    }
    else
    {
    	ret_val = 0;
    	index1 = 0;
    	goto wifi_rebootcheck_exit;
    }
wifi_rebootcheck_exit:
    return ret_val;
}

//====================================================================
//ƣuecom_recv
//أ0յͨTCP/UDPݣ1ڽ֡2ݴ
//˵chڽյ(1ֽ)*dataLen:洢յݳȣ
//      *data:յݴŵ;
//ܸҪԽյԷݽн֡Чݴdata֮Уɴڵuartжϵá
//޸ڣ2018-06-30,LXD
//====================================================================
uint8_t uecom_recv(uint8_t ch,uint16_t *dataLen, uint8_t *data)
{
    static vuint16_t index1 = 0;   //֡
    static vuint16_t length = 0;  //ݳ
    vuint8_t ret_val;
    vuint16_t i;
    vuint8_t WCRC[2];
    vuint16_t wcrc;
    //δ֡ͷδյ֡ͷ(֡)
    if((index1 == 0 && ch != frameHead[0]) ||
      (index1 == 1 && ch != frameHead[1]))
    {
    	index1 = 0;
        length = 0;
        ret_val = 2;     //ݴ
        goto uecom_recv_exit;
    }
    //˵Է
    data[index1++] = ch;  //洢֡
    if(index1 == 19)      //ȡdata
    {
        length = ((uint16_t)data[17]<<8) + data[18];
    }
    //յݴﵽһ֡ȡlength+23Ϊ֡
    if(length != 0 && index1 >= length+23)
    {
        //CRCУ
    	wcrc = crc16(data+2,length+17);
        WCRC[0] = (wcrc>>8)&0xff;
        WCRC[1] = wcrc&0xff;
        if(data[index1-2]!=frameTail[0] ||
        		data[index1-1]!= frameTail[1]  //δ֡β
            || WCRC[0] != data[length+19] ||
			WCRC[1] != data[length+20])        //CRC
        {
        	index1 = 0;
            length = 0;
            ret_val = 2;         //ݴ
            goto uecom_recv_exit;
        }
        for(i=0;i<length;i++)
        {
            data[i] = data[i+19];//19ΪЧֽǰݳ
        }
        *dataLen = length;
        index1 = 0;
        length = 0;
        ret_val = 0;             //յͨTCP/UDP
        goto uecom_recv_exit;
    }
    *dataLen = 0;
    ret_val = 1;//ڽ֡
uecom_recv_exit:
    return ret_val;
}
