/*======================================================================
**ļƣSTM32L431RCTX_FLASH.ldļ
**λSD-Arm(sumcu.suda.edu.cn)
**¼¼20181201-20200629
**======================================================================*/


/*1䶯س*/
/*MCUFlashÿСʼַ*/
MCU_SECTORSIZE =2048; 
MCU_FLASH_ADDR_START = 0x8000000;   
/*Userʼ*/
GEC_USER_SECTOR_START  =26;       /*01/20-026-BIOS*/
GEC_USER_SECTOR_END =126;   
/*MCURAMʼַַ*/         
GEC_USER_RAM_START =0x20002000;  
GEC_USER_RAM_END  =0x2000ffff;   
/*ջйسֵ*/
_estack =  0x2000ffff;	       /*.sļ*/
_Min_Heap_Size  = 0x200 ;      /* СֵRTOS*/
_Min_Stack_Size = 0x400 ;	   /* ջСֵROTS*/
           
/*2̶MEMORYζ*/
MEMORY
{
	/*ж*/
	INTVEC(rx) : ORIGIN =MCU_FLASH_ADDR_START + MCU_SECTORSIZE * GEC_USER_SECTOR_START , 
	                   LENGTH = MCU_SECTORSIZE
	/*Flash*/                   
    FLASH (rx) : ORIGIN = MCU_FLASH_ADDR_START + MCU_SECTORSIZE * (GEC_USER_SECTOR_START + 1) , 
                  LENGTH = MCU_SECTORSIZE * (GEC_USER_SECTOR_END - GEC_USER_SECTOR_START )
    /*USERRAMռ䡣*/
    RAM  (rwx) : ORIGIN = GEC_USER_RAM_START, 
                  LENGTH = GEC_USER_RAM_END - GEC_USER_RAM_START + 1
}

/*3䶯SECTIONSζ*/
SECTIONS
{
/* 3.1̶ж */
  .isr_vector :
  {
    . = ALIGN(8);
    KEEP(*(.isr_vector))
    . = ALIGN(8);
  } >INTVEC
  
  /**********************3.2䶯ΪSTM32***********************/
  
  /* The program code and other data into "FLASH" Rom type memory */
  .text :
  {
    . = ALIGN(8);
    *(.text)           /* .text sections (code) */
    *(.text*)          /* .text* sections (code) */
    *(.glue_7)         /* glue arm to thumb code */
    *(.glue_7t)        /* glue thumb to arm code */
    *(.eh_frame)

    KEEP (*(.init))
    KEEP (*(.fini))

    . = ALIGN(8);
    _etext = .;        /* define a global symbols at end of code */
  } >FLASH

  /* Constant data into "FLASH" Rom type memory */
  .rodata :
  {
    . = ALIGN(8);
    *(.rodata)         /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)        /* .rodata* sections (constants, strings, etc.) */
    . = ALIGN(8);
  } >FLASH

  .ARM.extab   : { 
  	. = ALIGN(8);
  	*(.ARM.extab* .gnu.linkonce.armextab.*)
  	. = ALIGN(8);
  } >FLASH
  
  .ARM : {
    . = ALIGN(8);
    __exidx_start = .;
    *(.ARM.exidx*)
    __exidx_end = .;
    . = ALIGN(8);
  } >FLASH

  .preinit_array     :
  {
    . = ALIGN(8);
    PROVIDE_HIDDEN (__preinit_array_start = .);
    KEEP (*(.preinit_array*))
    PROVIDE_HIDDEN (__preinit_array_end = .);
    . = ALIGN(8);
  } >FLASH
  
  .init_array :
  {
    . = ALIGN(8);
    PROVIDE_HIDDEN (__init_array_start = .);
    KEEP (*(SORT(.init_array.*)))
    KEEP (*(.init_array*))
    PROVIDE_HIDDEN (__init_array_end = .);
    . = ALIGN(8);
  } >FLASH
  
  .fini_array :
  {
    . = ALIGN(8);
    PROVIDE_HIDDEN (__fini_array_start = .);
    KEEP (*(SORT(.fini_array.*)))
    KEEP (*(.fini_array*))
    PROVIDE_HIDDEN (__fini_array_end = .);
    . = ALIGN(8);
  } >FLASH


  /* Used by the startup to initialize data */
  _sidata = LOADADDR(.data);

  /* Initialized data sections into "RAM" Ram type memory */
  .data : 
  {
    . = ALIGN(4);
    _sdata = .;        /* create a global symbol at data start */
    *(.data)           /* .data sections */
    *(.data*)          /* .data* sections */

    . = ALIGN(4);
    _edata = .;        /* define a global symbol at data end */
    
  } >RAM AT> FLASH
  
  /* Uninitialized data section into "RAM" Ram type memory */
  . = ALIGN(4);
  .bss :
  {
    /* This is used by the startup in order to initialize the .bss secion */
    _sbss = .;         /* define a global symbol at bss start */
    __bss_start__ = _sbss;
    *(.bss)
    *(.bss*)
    *(COMMON)

    . = ALIGN(4);
    _ebss = .;         /* define a global symbol at bss end */
    __bss_end__ = _ebss;
  } >RAM

  /* Remove information from the compiler libraries */
  /DISCARD/ :
  {
    libc.a ( * )
    libm.a ( * )
    libgcc.a ( * )
  }

  .ARM.attributes 0 : { *(.ARM.attributes) }
}
