//===========================================================================
//ļƣgpio.h
//ܸҪGPIOײͷļ
//ȨУSD-Arm(sumcu.suda.edu.cn)
//汾£20190520-20200221
//оƬͣSTM32
//===========================================================================

#ifndef  GPIO_H       //ֹظ壨_GPIO_H  ͷ)
#define  GPIO_H

#include "mcu.h"   //Ҫͷļ
#include "string.h"

// ˿ںŵַƫ궨
#define PTA_NUM    (0<<8)
#define PTB_NUM    (1<<8)
#define PTC_NUM    (2<<8)
#define PTD_NUM    (3<<8)
#define PTE_NUM    (4<<8)
#define PTH_NUM    (7<<8)
// GPIOŷ궨
#define GPIO_INPUT  (0)      //GPIO
#define GPIO_OUTPUT (1)      //GPIO
// GPIOߵ״̬궨
#define PULL_UP    (0x01u)   //
#define PULL_DOWN  (0x02u)   //
// GPIOжͺ궨
#define RISING_EDGE  (1)     //ش
#define FALLING_EDGE (2)     //½ش
#define DOUBLE_EDGE  (3)     //˫ش
// GPIOʺ궨
#define LOW_SPEED       (0x00u)  //
#define MSDIUM_SPEED    (0x01u)  //
#define HIGH_SPEED      (0x02u)  //
#define VERY_HIGH_SPEED (0x03u)  //

//=====================================================================
//ƣgpio_init
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//         dirŷ0=룬1=,ŷ궨壩
//         state˿ųʼ״̬0=͵ƽ1=ߵƽ
//ܸҪʼָ˿ΪGPIOŹܣΪ
//         ָʼ״̬ǵ͵ƽߵƽ
//=====================================================================
void gpio_init(uint16_t port_pin, uint8_t dir, uint8_t state);

//=====================================================================
//ƣgpio_set
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//          stateϣõĶ˿״̬0=͵ƽ1=ߵƽ
//ܸҪָ˿űΪGPIOΪʱ趨״̬
//=====================================================================
void gpio_set(uint16_t port_pin, uint8_t state);

//=====================================================================
//ƣgpio_get
//أָ˿ŵ״̬10
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱȡָ״̬
//=====================================================================
uint8_t gpio_get(uint16_t port_pin);

//=====================================================================
//ƣgpio_reverse
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱת״̬
//=====================================================================
void gpio_reverse(uint16_t port_pin);

//=====================================================================
//ƣgpio_pull
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//       pullselect/PULL_DOWN=PULL_UP=
//ܸҪָ˿űΪGPIOΪʱ/
//=====================================================================
void gpio_pull(uint16_t port_pin, uint8_t pullselect);

//=====================================================================
//ƣgpio_enable_int
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//          irqtypeжͣɺ궨ٴо£
//                  RISING_EDGE  9      //ش
//                  FALLING_EDGE 10     //½ش
//                  DOUBLE_EDGE  11     //˫ش
//ܸҪָ˿űΪGPIOΪʱжϣ
//          жϴ
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//         KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//         KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
void gpio_enable_int(uint16_t port_pin,uint8_t irqtype);

//=====================================================================
//ƣgpio_disable_int
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱرж
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//         KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//         KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
void gpio_disable_int(uint16_t port_pin);

//=====================================================================
//ƣgpio_drive_strength
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//       controlŵLOW_SPEED=,MSDIUM_SPEED=
//               HIGH_SPEED=,VERY_HIGH_SPEED=
//ܸҪָĳһmAλ
//        5mA,18mAűΪʱ,
//        ŵ
//=====================================================================
void gpio_drive_strength(uint16_t port_pin, uint8_t control);

//=====================================================================
//ƣgpio_get_int
//أGPIOжϱ־101ʾGPIOжϣ0ʾûGPIOжϡ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱ,ȡжϱ־
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//        KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//        KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
uint8_t gpio_get_int(uint16_t port_pin);

//=====================================================================
//ƣgpio_clear_int
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱ,жϱ־
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//         KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//         KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
void gpio_clear_int(uint16_t port_pin);

//=====================================================================
//ƣgpio_clear_allint
//أ
//˵
//ܸҪж˿ڵGPIOж
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//         KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//         KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
void gpio_clear_allint(void);

#endif
