//=====================================================================
//ļƣtimer.c
//ܸҪtimerײԴļ
//λݴѧǶʽϵͳо(sumcu.suda.edu.cn)
//      2019-11-15  V2.0
//оƬSTM32
//=====================================================================
#include"includes.h"
#include "timer.h"

//============================================================================
//ƣtimer_init
//أ
//˵ timer_No:ʱģ  ʱģżgec.hļ
//                 time_ms ʱжϵʱλΪ롣
//ܸҪʱģʼTIM1Ϊ߼ʱTIM2TIM15TIM16Ϊͨöʱ
//         TIM6TIM7Ϊʱ
//============================================================================
void timer_init(uint8_t timer_No,uint32_t time_ms)
{
    switch(timer_No)
    {
    case 1:
	{
		RCC->APB2ENR |= RCC_APB2ENR_TIM1EN;//ʹܶʱʱ
		TIM1->CR1 &= ~(TIM_CR1_DIR | TIM_CR1_CMS);//ϼģʽ
		TIM1->CR1 &= ~TIM_CR1_CKD;//ʱӻ
		TIM1->ARR = (uint16_t)(time_ms-1) ;//
		TIM1->PSC = MCU_SYSTEM_CLK_KHZ-1;//ԤƵ
		//TIM2->RCR = 0;
		TIM1->EGR = TIM_EGR_UG;//ʼ
		TIM1->CR1 |= 0x00000001U;//ʹ
		break;
	}
	case 2:
	{
		RCC->APB1ENR1 |= RCC_APB1ENR1_TIM2EN;//ʹܶʱʱ
		TIM2->CR1 &= ~(TIM_CR1_DIR | TIM_CR1_CMS);//ϼģʽ
		TIM2->CR1 &= ~TIM_CR1_CKD;//ʱӻ
		TIM2->ARR = (uint32_t)(time_ms-1) ;//   //time_ms*48000/PSC
		TIM2->PSC = MCU_SYSTEM_CLK_KHZ-1;//ԤƵ  //Ƶ֮Ƶ=ѡʱԴƵ/(PSC+1),   (ARR+1)*(PSC+1)/fclk
		//TIM2->RCR = 0;
		TIM2->EGR = TIM_EGR_UG;//ʼ
		TIM2->CR1 |= 0x00000001U;//ʹ
		break;
	}
	case 6: //TIM6ֻϼ
	{
		RCC->APB1ENR1 |= RCC_APB1ENR1_TIM6EN;
		TIM6->ARR = (uint16_t)(time_ms-1) ;
		TIM6->PSC = MCU_SYSTEM_CLK_KHZ-1;
		TIM6->EGR = TIM_EGR_UG;
		TIM6->CR1 |= 0x00000001U;
		break;
	}
	case 7: //TIM7ֻϼ
	{
		RCC->APB1ENR1 |= RCC_APB1ENR1_TIM7EN;
		TIM7->ARR = (uint16_t)(time_ms-1) ;
		TIM7->PSC = MCU_SYSTEM_CLK_KHZ-1;
		TIM7->EGR = TIM_EGR_UG;
		TIM7->CR1 |= 0x00000001U;
		break;
	}
	case 15: //TIM15ֻϼ
	{
		RCC->APB2ENR |= RCC_APB2ENR_TIM15EN;
		TIM15->ARR = (uint16_t)(time_ms-1) ;
		TIM15->PSC = MCU_SYSTEM_CLK_KHZ-1;
		TIM15->EGR = TIM_EGR_UG;
		TIM15->CR1 |= 0x00000001U;
		break;
	}
	case 16: //TIM16ֻϼ
	{
	    RCC->APB2ENR |= RCC_APB2ENR_TIM16EN;
		TIM16->ARR = (uint16_t)(time_ms-1) ;
		TIM16->PSC = MCU_SYSTEM_CLK_KHZ-1;
		TIM16->EGR = TIM_EGR_UG;
		TIM16->CR1 |= 0x00000001U;
		break;
	}
	}

}


//============================================================================
//ƣtimer_enable_int
//أ
//˵ timer_No:ʱģ  ʱģżgec.hļ
//ܸҪʱģʹܣʱģжϼʱж
//============================================================================
void timer_enable_int(uint8_t timer_No)
{
    switch(timer_No)
    {
    case 1:
	{
		TIM1->DIER |= TIM_DIER_UIE;
		NVIC_EnableIRQ(TIM1_UP_TIM16_IRQn);    //жϿIRQж
	    break;
	}
	case 2:
	{
		TIM2->DIER |= TIM_DIER_UIE;
		NVIC_EnableIRQ(TIM2_IRQn);    //жϿIRQж
	    break;
	}
	case 6:
	{
		TIM6->DIER |= TIM_DIER_UIE;
		NVIC_EnableIRQ(TIM6_DAC_IRQn);    //жϿIRQж
	    break;
	}
	case 7:
	{
		TIM7->DIER |= TIM_DIER_UIE;
		NVIC_EnableIRQ(TIM7_IRQn);    //жϿIRQж
	    break;
	}
	case 15:
	{
		TIM15->DIER |= TIM_DIER_UIE;
		NVIC_EnableIRQ(TIM1_BRK_TIM15_IRQn);    //жϿIRQж
	    break;
	}
	case 16:
	{
		TIM16->DIER |= TIM_DIER_UIE;
		NVIC_EnableIRQ(TIM1_UP_TIM16_IRQn);    //жϿIRQж
	    break;
	}
    }
}

//============================================================================
//ƣtimer_disable_int
//أ
//˵ timer_No:ʱģ  ʱģżgec.hļ
//ܸҪʱжϳ
//============================================================================
void timer_disable_int(uint8_t timer_No)
{
    switch(timer_No)
	{
	case 1:
	{
		TIM1->DIER &= ~TIM_DIER_UIE;
		NVIC_DisableIRQ(TIM1_UP_TIM16_IRQn);    //ֹжϿIRQж
	    break;
	}
	case 2:
	{
		TIM2->DIER &= ~TIM_DIER_UIE;
		NVIC_DisableIRQ(TIM2_IRQn);    //ֹжϿIRQж
	    break;
	}
	case 6:
	{
		TIM6->DIER &= ~TIM_DIER_UIE;
		NVIC_DisableIRQ(TIM6_DAC_IRQn);    //ֹжϿIRQж
	    break;
	}
	case 7:
	{
		TIM7->DIER &= ~TIM_DIER_UIE;
		NVIC_DisableIRQ(TIM7_IRQn);    //ֹжϿIRQж
	    break;
	}
	case 15:
	{
		TIM15->DIER &= ~TIM_DIER_UIE;
		NVIC_DisableIRQ(TIM1_BRK_TIM15_IRQn);    //ֹжϿIRQж
	    break;
	}
	case 16:
	{
		TIM16->DIER &= ~TIM_DIER_UIE;
		NVIC_DisableIRQ(TIM1_UP_TIM16_IRQn);    //ֹжϿIRQж
	    break;
	}
	}
}

//===================================================================
//ƣtimer_get_int
//˵ timer_No:ʱģ  ʱģżgec.hļ
//ܸҪȡtimerģжϱ־
//أжϱ־ 1=жӦģжϲ;0=޶Ӧģжϲ
//===================================================================
uint8_t timer_get_int(uint8_t timer_No)
{
    if(timer_No==1)
    {
		if((TIM1->SR & TIM_SR_UIF)==TIM_SR_UIF)
			return 1;
	}
	else if(timer_No==2)
	{
		if((TIM2->SR & TIM_SR_UIF)==TIM_SR_UIF)
			return 1;
	}
	else if(timer_No==6)
	{
		if((TIM6->SR & TIM_SR_UIF)==TIM_SR_UIF)
			return 1;
	}
	else if(timer_No==7)
	{
		if((TIM7->SR & TIM_SR_UIF)==TIM_SR_UIF)
			return 1;
	}
	else if(timer_No==15)
	{
		if((TIM15->SR & TIM_SR_UIF)==TIM_SR_UIF)
			return 1;
	}
	else if(timer_No==16)
	{
		if((TIM16->SR & TIM_SR_UIF)==TIM_SR_UIF)
			return 1;
	}
	return 0;
}

//============================================================================
//ƣtimer_clear_int
//أ
//˵ timer_No:ʱģ  ʱģżgec.hļ
//ܸҪʱжϱ־
//============================================================================
void timer_clear_int(uint8_t timer_No)
{
    switch(timer_No)
    {
    case 1:TIM1->SR &=  ~TIM_SR_UIF;break;
	case 2:TIM2->SR &=  ~TIM_SR_UIF;break;
	case 6:TIM6->SR &=  ~TIM_SR_UIF;break;
	case 7:TIM7->SR &=  ~TIM_SR_UIF;break;
	case 15:TIM15->SR &=  ~TIM_SR_UIF;break;
	case 16:TIM16->SR &=  ~TIM_SR_UIF;break;
    }
}
