//===================================================================
//ļƣuecom.cuecomԴļ
//===================================================================
#include "uecom.h"    //Ӧͷļ˵ͷļ

//ļ
#define AT_reBuf_length 300
static uint8_t AT_reBuf[300];   //UEATָķؽ
//static uint8_t AT_reFlag = 0;   //ATָɹصı־,ɹʱֵΪյATָصݳ
static uint8_t AT_reLength = 0; //ATָصݳ
static uint8_t AT_haveCommand=0;//־ǰǷATָ
static uint8_t frameHead[2] = "V!"; //֡ͷ
static uint8_t frameTail[2] = "S$"; //֡β
static uint8_t IMSI[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};  //洢ʼȡIMSI
static uint8_t IMEI[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};  //洢ʼȡIMEI

static uint8_t locationFlag=0;      //յһЧλϢ־
static uint8_t locationData[100];   //ŽյһЧλϢ


static uint8_t reip[16];    //Զ̸IPַ  2019/04/29 CC 
static uint8_t report[6];   //Զ̸¶˿ں
static uint8_t reFlag = 0;  //Զ̸±ʶ

//                            "1234567890123456789012345";
static uint8_t uecomType[25] = "AHL-AN100 NB-DX-3616 V3.2";
static uint8_t uecomVersion[5] = "V3.2";



//======================ڲ====================================
uint8_t uecom_sendCmd(uint8_t *cmd,uint16_t maxDelayMs,uint16_t maxTimes);
void uint_to_str(uint32_t ch,char *str);
void frameEncode(uint8_t *imsi,uint8_t *data,uint16_t dlen,
		         uint8_t *frame,uint16_t *framelen);
uint8_t uecom_internal_getIMEI(uint8_t *dest);
uint8_t uecom_internal_getIMSI(uint8_t *dest);
uint8_t uecom_recv(uint8_t ch,uint16_t *dataLen, uint8_t *data);
uint8_t uecom_recvLocation(uint8_t ch, uint8_t *data);
uint8_t uecom_transparentRecv(uint8_t ch,uint16_t *dataLen, uint8_t *data);
void ArrayCopy(uint8_t * dest,uint8_t * source,uint16_t len);
void Delay_ms(uint16_t u16ms);
uint16_t ue_crc16(uint8_t *ptr,uint16_t len);

//======================ڲ===================================

//==============================================================
//ʹõATָ20180815

#define AT        "AT\r\n"             //ͨģͨѶָ
#define IPR       "AT+IPR=115200\r\n"  //ģ鲨Ϊ115200
#define ATE_0     "ATE0\r\n" //رջԣ͸֮UEģ鲻ԭأ
#define GSN       "AT+GSN\r\n"          //ȡ豸IMEIָ
#define CIMI      "AT+CIMI\r\n"         //ȡ豸IMSIָ

#define CFUN      "AT+CFUN=1\r\n"       //õ绰
#define COPS      "AT+COPS=1,2,\"46011\"\r\n"//Ӫ,46011ʾǵŵ
//#define COPS      "AT+COPS=1,2,\"46000\"\r\n"//Ӫ,46000ʾƶ
#define MSPCHSC   "AT*MSPCHSC=1\r\n"         //NBֵ֧㷨㷨
#define CPSMS     "AT+CPSMS=0\r\n"           //ر PSM 
#define EGACT_0   "AT+EGACT=0,1,\"ctnb\"\r\n"//ȥPDP,APNǵŵ
#define EGACT_1   "AT+EGACT=1,1,\"ctnb\"\r\n"//PDP,APNǵŵ
#define CSQ       "AT+CSQ\r\n"               //ȡźǿ

#define ESOC      "AT+ESOC=1,1,1\r\n"        //TCP׽
#define ESOSETRPT "AT+ESOSETRPT=1\r\n"   //ýݵĻʽΪԭʼݡ
#define ESOCL     "AT+ESOCL=0\r\n"       //ر׽
#define ESOCL_1   "AT+ESOCL=1\r\n"       //ر׽1
#define MENGINFO  "AT*MENGINFO=0\r\n"    //ȡǰСϢ

#define ZGMODE_1 "AT+ZGMODE=1\r\n"    //GPSλģʽAGPSģʽ
#define ZGNMEA_2 "AT+ZGNMEA=2\r\n"    //GPSNMEAϱʽģʽRMCʽ
#define ZGRUN_2 "AT+ZGRUN=2\r\n"      //GPS׷ٻȡݣ
#define METIME  "AT+CCLK?\r\n"       //ȡվʱ
//#define ZRST    "AT+ZRST\r\n"        //ģ鸴λ

//ATǷִгɹı־
#define OK        "OK"
#define ERROR     "ERROR"
//============================================================

//=====================================================================
//ƣuecom_power
//أ
//˵state:ͨģԴȡֵΪʹú곣
//         UECOM_OFFرͨģԴ
//         UECOM_ONͨģԴ
//         UECOM_REBOOTͨģ飨ȹرգʱٿ
//ܸҪͨģ鹩״̬
//ڲãgpio_initdelay_ms
//޸ڣ20180718,LXD
//=====================================================================
void uecom_power(uint8_t state)    //ͨģ鹩״̬
{
    switch(state)
    {
    case UECOM_OFF:
        gpio_init(POWER_CONTROL,1,0);break;
    case UECOM_ON:
        gpio_init(POWER_CONTROL,1,1);break;
    case UECOM_REBOOT:
        gpio_init(POWER_CONTROL,1,0);        //ر
        Delay_ms(2000);                //ʱ2
        gpio_init(POWER_CONTROL,1,1);break;  //
    }
}

//=====================================================================
//ƣuecom_linkOff
//أ  
//˵ 
//ܸҪϿSocket
//޸ڣ20190503,
//=====================================================================
void uecom_linkOff()
{
    uart_init(UART_UE, 115200);  //ʼUEģ鴮ڣΪ115200
    uart_enable_re_int(UART_UE); //UEģ鴮ж

	uecom_sendCmd((uint8_t *)ESOCL,4000,1);      //ȹرһ׽0ֹͨģδϵѾ׽֣
	uecom_sendCmd((uint8_t *)ESOCL_1,4000,1);    //ȹرһ׽1ֹͨģδϵѾ׽֣
}

//====================================================================
//ƣuecom_init
//أ 0ɹ1UEģ鴮ͨѶʧܣ2ȡSIMIMSIʧܣ
//˵ 
//ܸҪuecomģʼ1ͨѶģĴͨѶ2ȡSIMIMSIš
//޸ڣ20180718,LXD
//====================================================================
uint8_t uecom_init(void)
{
    //1͸ֵ
    uint8_t ret_val ;
    //2ʹôͨģͨţȳʼ
    uart_init(UART_UE, 115200);  //ʼUEģ鴮ڣΪ115200
    uart_enable_re_int(UART_UE); //UEģ鴮ж
    //3GPRSģͨѶ
    if(uecom_sendCmd((uint8_t *)AT,100,2))
    {
    	uecom_power(UECOM_REBOOT);   //UEģ¹
    	Delay_ms(8000);
    }
	if(uecom_sendCmd((uint8_t *)AT,100,3))
	    goto uecom_init_err1;     //UEģͨѶʧ
    //4رջԣAT֮UEģ鲻ԭأ
    if(uecom_sendCmd((uint8_t *)ATE_0,200,3))
        goto uecom_init_err1;    //رջʧ
    //5ѯģIMEI,IMEIŷdestǰ15ֽ
    if(uecom_internal_getIMEI(IMEI))
        goto uecom_init_err1;    //IMEIѯʧ
    //6ѯģIMSI,IMSIŷdest15-29±Ŀռ
    if(uecom_internal_getIMSI(IMSI))
        goto uecom_init_err2;    //IMSIѯʧ
    ret_val = 0;
    goto uecom_init_exit;
     //˳
uecom_init_err1:
    ret_val = 1;                 //UEģ鴮ͨѶʧ
    goto uecom_init_exit;
uecom_init_err2:
    ret_val = 2;                 //ȡSIMIMSIʧ
    goto uecom_init_exit;
    //˳
uecom_init_exit:
    return ret_val;
}

//=====================================================================
//ƣ uecom_linkBase
//أ 0ɹӣ1Ӳ
//˵
//ܸҪӪ̵Ļվ
//޸ڣ20180718,LXD
//=====================================================================
uint8_t uecom_linkBase(void)
{
	//1ֵ
	uint8_t ret=1;
	//2õ绰Ϊȫ
	if(uecom_sendCmd((uint8_t *)CFUN,1500,2))
		goto uecom_linkBase_exit;      //õ绰Ϊȫʧ
	//3Ӫ
	uecom_sendCmd((uint8_t *)COPS,1500,3);
//	while(uecom_sendCmd((uint8_t *)COPS,1500,3));
	//4NBֵ֧㷨
	uecom_sendCmd((uint8_t *)MSPCHSC,500,2);
	//5ر PSM ܣΪ漰Ĳԣ
	if(uecom_sendCmd((uint8_t *)CPSMS,200,2))
		goto uecom_linkBase_exit;      //ر PSM ʧ
	//6PDP
	if(uecom_sendCmd((uint8_t *)EGACT_1,10000,1))
	{
		uecom_sendCmd((uint8_t *)EGACT_0,10000,1);
		Delay_ms(5000);
		if(uecom_sendCmd((uint8_t *)EGACT_1,10000,2))
			goto uecom_linkBase_exit;  //PDPʧ
	}
	//ˣûʧ˳ɹ
	ret = 0;
uecom_linkBase_exit:
	    return ret;
}

//=====================================================================
//ƣuecom_remoteConfig
//أ
//˵ IP:Ӹ·IPַ port:Ӹ·Ķ˿ں
//ܸҪø·IPַͶ˿ں
//޸ڣ20190426,CC
//=====================================================================
void uecom_remoteConfig(uint8_t *ip,uint8_t *port)
{
	strcpy((char *)reip,(const char *)ip);
	strcpy((char *)report,(const char *)port);
	reFlag = 1;

}

//=====================================================================
//ƣuecom_linkCS
//أ 0ɹTCPӣ1TCPʧ
//˵ IP:ӷIPַ port:ӷĶ˿ں
//ܸҪָķͶ˿ڽTCPӡ
//޸ڣ20180718,LXD
//=====================================================================
uint8_t uecom_linkCS(uint8_t *ip,uint8_t* port)
{
    //1͸ֵ
    uint8_t i;
//    uint8_t flag;
    uint8_t ret_val=1;
    uint8_t ESOCON[50] = "";    //ôŽTCPӵָ
    uint8_t loc;
    //2齨TCPӵָ
    strcat((char *)ESOCON,"AT+ESOCON=0,");
    loc = strlen((const char *)ESOCON);
    for(i=0; i<5; i++)//Ӷ˿ںţ5λ
    {
        if(port[i] == 0)
        {
            break;
        }
        ESOCON[loc+i] = port[i];
    }
    strcat((char *)ESOCON,",\"");
    loc = strlen((const char *)ESOCON);
    for(i=0; i<15; i++)//ӶIP15λ
    {
        if(ip[i] == 0)
        {
           break;
        }
        ESOCON[loc+i] = ip[i];
    }
    strcat((char *)ESOCON,"\"\r\n");
    //3TCP׽
    uecom_sendCmd((uint8_t *)ESOCL,4000,1);    //ȹرһ׽ֹ֣ͨģδϵѾ׽֣
    if(uecom_sendCmd((uint8_t *)ESOC,4000,1))
    {
    	uecom_sendCmd((uint8_t *)ESOCL,4000,1);    //ر׽
    	if(uecom_sendCmd((uint8_t *)ESOC,1000,1))
    	{
    		goto uecom_linkCS_exit;
    	}
    }
    //4TCP
    if(uecom_sendCmd(ESOCON,4000,2))
    {
		goto uecom_linkCS_exit;
    }
    //5ýݵĻʽΪԭʼݡ
    if(uecom_sendCmd((uint8_t *)ESOSETRPT,4000,2))
    {
		goto uecom_linkCS_exit;
    }
    ret_val = 0;
    //2019/04/29 CC 
	if(reFlag == 1)
	{
		//ûcsɹӸ·
		uecom_linkRemoteUpdate(reip,report);
	}
    //˳
uecom_linkCS_exit:
    return ret_val;
}

//=====================================================================
//ƣuecom_linkRemoteUpdate
//أ 0ɹTCPӣ1TCPʧ
//˵ IP:ӷIPַ port:ӷĶ˿ں
//ܸҪָķͶ˿ڽTCPӡʹ׽1
//޸ڣ20190504,CC
//עuecom_RemoteUpdateҪڵuecom_linkCS֮ʹ
//=====================================================================
uint8_t uecom_linkRemoteUpdate(uint8_t *ip,uint8_t* port)
{
    //1͸ֵ
    uint8_t i;
//    uint8_t flag;
    uint8_t ret_val=1;
    uint8_t ESOCON[50] = "";    //ôŽTCPӵָ
    uint8_t loc;
    //2齨TCPӵָ
    strcat((char *)ESOCON,"AT+ESOCON=1,");
    loc = strlen((const char *)ESOCON);
    for(i=0; i<5; i++)//Ӷ˿ںţ5λ
    {
        if(port[i] == 0)
        {
            break;
        }
        ESOCON[loc+i] = port[i];
    }
    strcat((char *)ESOCON,",\"");
    loc = strlen((const char *)ESOCON);
    for(i=0; i<15; i++)//ӶIP15λ
    {
        if(ip[i] == 0)
        {
           break;
        }
        ESOCON[loc+i] = ip[i];
    }
    strcat((char *)ESOCON,"\"\r\n");
    //3TCP׽
    uecom_sendCmd((uint8_t *)ESOCL_1,4000,1);    //ȹرһ׽0ֹͨģδϵѾ׽֣
    if(uecom_sendCmd((uint8_t *)ESOC,4000,1))
    {
    	uecom_sendCmd((uint8_t *)ESOCL_1,4000,1);    //ر׽
    	if(uecom_sendCmd((uint8_t *)ESOC,1000,1))
    	{
    		goto uecom_linkRemoteUpdate_exit;
    	}
    }
    //4TCP
    if(uecom_sendCmd((uint8_t *)ESOCON,4000,2))
    {
		goto uecom_linkRemoteUpdate_exit;
    }
    //5ýݵĻʽΪԭʼݡ
    if(uecom_sendCmd((uint8_t *)ESOSETRPT,4000,2))
    {
		goto uecom_linkRemoteUpdate_exit;
    }
    ret_val = 0;

    //˳
    uecom_linkRemoteUpdate_exit:
    return ret_val;
}

//=====================================================================
//ƣuecom_send
//أ  0ͳɹ1ģʽʧܣ2ݷʧ
//˵ data:ݻ
//		           length:ݵĳ
//ܸҪͨѾTCPͨͳȥ500ֽڡ
//޸ڣ20180718,LXD
//=====================================================================
uint8_t uecom_send(uint16_t length, uint8_t *data)
{
    //1ֵ
    uint8_t ret_val;
    char dataLen[5]="";        //֡(ַʽ)
    char ESOSENDRAW[24]= "";   //ŷݵָ
    uint8_t frame[500];         //֡
    uint16_t frameLen;          //֡
    frameEncode(IMSI,data, length,frame,&frameLen);//֡
    uint_to_str(frameLen,dataLen);     //ݵĳתΪַʽ
    //2ģʽ
    strcat(ESOSENDRAW,"AT+ESOSENDRAW=0,");
    strcat(ESOSENDRAW, dataLen);
    strcat(ESOSENDRAW, "\r\n");
    uart_send_string(UART_UE,(uint8_t *)ESOSENDRAW);
    //3ʱȴģʽ
	if(uecom_sendCmd((uint8_t *)"wait",2000,1))
	{
		ret_val = 1;
		goto uecom_send_exit;      //ģʽʧ
	}
    //4ʼ
    uart_sendN(UART_UE ,frameLen,frame);
    //5жǷͳɹ
    if(uecom_sendCmd((uint8_t *)"SEND",2000,1))
    {
    	ret_val = 2;
    	goto uecom_send_exit;         //ݷʧ
    }
    //ݷͳɹ
    ret_val = 0;
    //2019/04/29 CC 
	if(reFlag == 1)
	{
		//ûcsɹӸ·
		uecom_linkRemoteUpdate(reip,report);
		//³
		uecom_updateSend(9,(uint8_t *)"heartbeat");
	}
    uecom_send_exit:
    return ret_val;
}

//=====================================================================
//ƣuecom_updateSend
//أ  0ͳɹ1ģʽʧܣ2ݷʧ
//˵ data:ݻ
//		           length:ݵĳ
//ܸҪͨѾTCPͨͳȥ500ֽڡʹ׽0ͣ
//޸ڣ20190504,CC
//=====================================================================
uint8_t uecom_updateSend(uint16_t length, uint8_t *data)
{
    //1ֵ
    uint8_t ret_val;
    char dataLen[5]="";        //֡(ַʽ)
    char ESOSENDRAW[24]= "";   //ŷݵָ
    uint8_t frame[100];         //֡
    uint16_t frameLen;          //֡
//    uint8_t i,ch,flag,count;
//    uint8_t sendBack[50];
    frameEncode(IMSI,data, length,frame,&frameLen);//֡
    uint_to_str(frameLen,dataLen);     //ݵĳתΪַʽ
    //2ģʽ
    strcat(ESOSENDRAW,"AT+ESOSENDRAW=1,");
    strcat(ESOSENDRAW, dataLen);
    strcat(ESOSENDRAW, "\r\n");
    uart_send_string(UART_UE,(uint8_t *)ESOSENDRAW);
    //3ʱȴģʽ
	if(uecom_sendCmd((uint8_t *)"wait",2000,1))
	{
		ret_val = 1;
		goto uecom_updateSend_exit;      //ģʽʧ
	}
    //4ʼ
    uart_sendN(UART_UE ,frameLen,frame);
    //5жǷͳɹ
    if(uecom_sendCmd((uint8_t *)"SEND",2000,1))
    {
    	ret_val = 2;
    	goto uecom_updateSend_exit;         //ݷʧ
    }
    //ݷͳɹ
    ret_val = 0;
    uecom_updateSend_exit:
    return ret_val;
}


//=====================================================================
//ƣuecom_transparentSend
//أ  0ͳɹ1ģʽʧܣ2ݷʧ
//˵ data:ݻ
//		           length:ݵĳ
//ܸҪ͸ͣͨѾTCPͨͳȥ500ֽڡ
//޸ڣ20180922,LXD
//=====================================================================
uint8_t uecom_transparentSend(uint16_t length, uint8_t *data)
{
    //1ֵ
    uint8_t ret_val;
    char dataLen[5]="";        //֡(ַʽ)
    char ESOSENDRAW[24]= "";   //ŷݵָ
//    uint8_t frame[500];         //֡
//    uint16_t frameLen;          //֡
//    frameEncode(IMSI,data, length,frame,&frameLen);//֡
    uint_to_str(length,dataLen);
    //2ģʽ
    strcat(ESOSENDRAW,"AT+ESOSENDRAW=0,");
    strcat(ESOSENDRAW, dataLen);
    strcat(ESOSENDRAW, "\r\n");

    uart_send_string(UART_UE,(uint8_t *)ESOSENDRAW);
    //3ʱȴģʽ
	if(uecom_sendCmd((uint8_t *)"wait",2000,1))
	{
		ret_val = 1;
		goto uecom_send_exit;      //ģʽʧ
	}
    //4ʼ
    uart_sendN(UART_UE ,length,data);
    //5жǷͳɹ
    if(uecom_sendCmd((uint8_t *)"SEND",2000,1))
    {
    	ret_val = 2;
    	goto uecom_send_exit;         //ݷʧ
    }
    //ݷͳɹ
    ret_val = 0;
    uecom_send_exit:
    return ret_val;
}


//====================================================================
//ƣuecom_interrupt
//أ
//˵chжϽյݣlengthյݳȣ
//                   recvData洢յ
//ܸҪҪڴжСҪ봮жϽյݡ
//  йʵ־apiapiʵֵĹܣ
//  1緢;2ڲʹñapiģݽ
//޸ڣ20180718,LXD
//=====================================================================
void uecom_interrupt(uint8_t ch,uint16_t *length,uint8_t recvData[])
{
	//ݵ
	if(AT_haveCommand)
	{
		AT_reBuf[AT_reLength] = ch;    //洢յݵAT_reBuf
		AT_reLength = (AT_reLength+1)%AT_reBuf_length;//յ±
		AT_reBuf[AT_reLength] = 0;
	}
	uecom_recv(ch,length,recvData); //Է
	if(locationFlag==0)
	{
		uecom_recvLocation(ch,locationData);//λϢ
	}
}


//====================================================================
//ƣuecom_transparentInterrupt
//أ
//˵chжϽյݣlengthյݳȣ
//                   recvData洢յ
//ܸҪ͸жϴҪڴжСҪ봮жϽյݡ
//  йʵ־apiapiʵֵĹܣ
//  1緢;2ڲʹñapiģݽ
//޸ڣ20180922,LXD
//=====================================================================
void uecom_transparentInterrupt(uint8_t ch,uint16_t *length,
		uint8_t recvData[])
{
	//ݵ
	if(AT_haveCommand)
	{
		AT_reBuf[AT_reLength] = ch;    //洢յݵAT_reBuf
		AT_reLength = (AT_reLength+1)%AT_reBuf_length;//յ±
		AT_reBuf[AT_reLength] = 0;
	}
	uecom_transparentRecv(ch,length,recvData); //Է
	if(locationFlag==0)
	{
		uecom_recvLocation(ch,locationData);//λϢ
	}
}
//=====================================================================
//ƣuecom_ gnssSwitch
//أ0GNSSɹ1GNSSʧ
//˵stateGNSSĿ״̬123
//          Ĭʹ
//ܸҪGNSS״̬رGNSS趨ʽ
//޸ڣ20180902
//=====================================================================
uint8_t uecom_gnssSwitch (uint8_t state)
{
	//1ʹõı
	uint8_t  ret;
	ret = 1;    //ĬϷʧ
	//2ݴֵGNSS
	switch(state)
	{
	case 1:
        if(uecom_sendCmd((uint8_t *)ZGMODE_1,1000,2))//GPSλģʽAGPSģʽ
        	goto uecom_gnssSwitch_exit;
    	if(uecom_sendCmd((uint8_t *)ZGNMEA_2,1000,2))//GPSNMEAϱʽģʽRMCʽ
    	{
    		goto uecom_gnssSwitch_exit;
    	}

		if(uecom_sendCmd((uint8_t *)ZGRUN_2,1000,2))//ѭȡλϢ
			goto uecom_gnssSwitch_exit;
        break;
	case 2:
		if(uecom_sendCmd((uint8_t *)ZGMODE_1,1000,2))//GPSλģʽAGPSģʽ
			goto uecom_gnssSwitch_exit;
		if(uecom_sendCmd((uint8_t *)ZGNMEA_2,1000,2))//GPSNMEAϱʽģʽRMCʽ
			goto uecom_gnssSwitch_exit;
		if(uecom_sendCmd((uint8_t *)ZGRUN_2,1000,2))//ѭȡλϢ
			goto uecom_gnssSwitch_exit;
		break;
	case 3:
		if(uecom_sendCmd((uint8_t *)ZGMODE_1,1000,2))//GPSλģʽAGPSģʽ
			goto uecom_gnssSwitch_exit;
		if(uecom_sendCmd((uint8_t *)ZGNMEA_2,1000,2))//GPSNMEAϱʽģʽRMCʽ
			goto uecom_gnssSwitch_exit;
		if(uecom_sendCmd((uint8_t *)ZGRUN_2,1000,2))//ѭȡλϢ
			goto uecom_gnssSwitch_exit;
		break;
	default:
		break;
	}
	//ˣ
	ret = 0;
	uecom_gnssSwitch_exit:
	return ret;
}


//====================================================================
//ƣuecom_ gnssGetInfo
//أ0ȡλϢɹ1ûлöλϢ
//˵data洢õGNSSϢýṹķʽ4Ա
//       time15ֽڵuint8_t飩,:20180706155132ʾ20187615:51:32
//       latitudedoubleͣγϢlongitudedoubleϢ
//       speeddoubleͣٶȣλΪÿ롣
//       attitudedoubleͣθ߶ȣλΪ
//ܸҪGNSSλصϢ
//޸ڣ20180902
//=====================================================================
uint8_t uecom_gnssGetInfo (UecomGnssInfo *data)   // UecomGnssInfoΪ洢gnssϢĽṹ
{
	//1屾ʹõı
	uint8_t i,j,ret;
	uint8_t *p;
	double a,b,c,d;
	//2жǷȡЧĶλ
	ret = 1;        //ĬϷ1
	if(locationFlag==0)
		goto uecom_gnssGetInfo_exit;
	//3ͨģ鷵нUTCʱ
	//3.1ȡ
	p =(uint8_t *) strstr((const char *)locationData,(const char *)",");   //ַ','һڵλ
	j=0;                        //Ƕ
	while(j<9)                  //λ9
	{
		if(*p==',')
			j++;
		p++;
	}
	data->time[0]='2';//
	data->time[1]='0';
	data->time[6]=*p;          //ȡ
	data->time[7]=*(++p);
	data->time[4]=*(++p);
	data->time[5]=*(++p);
	data->time[2]=*(++p);
	data->time[3]=*(++p);
	//4.2ȡʱ
	p =(uint8_t*) strstr((const char *)locationData,(const char *)",");   //ַ','һڵλ
	i=8;                        //Ƕ±
	while(i<14)                 //ȡʱ
	{
		p++;
		data->time[i]=*p;
		i++;
	}
	data->time[i]=0;                   //ӿղַ
	//ˣȡUTCʱɹ
	//4ȡλϢ
	//4.1ȡάϢ
	p = (uint8_t *)strstr((const char *)locationData,(const char *)",");   //ַ','һڵλ
	j=0;                        //Ƕ
	while(j<3)                  //λ3
	{
		if(*p==',')
			j++;
		p++;
	}
	a=((*p)-'0')*10.0;
	a=a+((*(++p))-'0');


	b = ((*(++p))-'0')*10.0;
	b =b+ ((*(++p))-'0');

	++p;
	++p; //'.'
	c = 0.1;
	b = b + ((*p) - '0')*c;
	while((*(++p))!=',')
	{
		c *= 0.1;
		b = b + ((*p) - '0')*c;
	}
	++p;    //','
	if((*p) == 'N')
		d = 1;
	else
		d = -1;
	data->latitude = (a + b/60.0)*d;
	//4.2ȡϢ
	++p;
	++p;   //ţϢλ

	a=((*p)-'0')*100.0;
	a=a+((*(++p))-'0')*10.0;
	a=a+((*(++p))-'0');

	b = ((*(++p))-'0')*10.0 ;
	b=+ ((*(++p))-'0');


	++p;
	++p;   //'.'
	c = 0.1;
	b = b + ((*p) - '0')*c;
	while((*(++p))!=',')
	{
		c *= 0.1;
		b = b + ((*p) - '0')*c;
	}
	++p;    //','
	if((*p) == 'E')
		d = 1;
	else
		d = -1;
	data->longitude = (a + b/60.0)*d;
	//5ͨģ鷵нٶϢ봫Ľṹ
	if(strstr((const char *)locationData,(const char *)"E,") != NULL)
		 p =(uint8_t *) strstr((const char *)locationData,(const char *)"E,");
	else
		 p =(uint8_t *) strstr((const char *)locationData,(const char *)"W,");
	p++;
	p++;//Եٶȴ
	a = 0;
	while((*p)!='.')
	{
		a = a*10 + (*p - '0');
		p++;
	}
	p++;//
	b = 0.1;
	a = a + (*p - '0')*b;
	p++;
	while((*p)!=',')
	{
		b *= 0.1;
		a = a + (*p - '0')*b;
		p++;
	}
	data->speed = a*0.5144444;
	//6ͨģ鷵нϢ봫Ľṹ
	data->attitude = 0;//޺Ϣ
	//ˣݽ
	locationFlag=0;    //սյһЧλϢ־
	ret = 0;
	uecom_gnssGetInfo_exit:
	return ret;
}

//====================================================================
//ƣuecom_baseInfo
//أ0ȡվϢɹ1ȡźǿʧܣ
//˵retData洢صϢ,ٷ20ֽڡ
//          Ϣɣźǿ(1ֽ)+վţ19ֽڣ
//ܸҪȡվصϢźǿȺͻվ
//޸ڣ20180815,WB
//=====================================================================
uint8_t uecom_baseInfo (uint8_t retData [20])
{
	//1͸ֵ
	uint8_t i,j,*p,ret;
	//2ȡźǿȣȡΣ1
	ret = 1;           //ô󷵻Ϊ1
	for(j=0;j<3;j++)
	{
		//2.1ģ鷢ͻȡźǿȵָ
		if( uecom_sendCmd((uint8_t *)CSQ,500,3))
			goto uecom_baseInfo_exit;
		//2.2ӽյнźǿȣתΪuint8_tʽ*signalPower
		i = strstr((const char *)AT_reBuf,(const char *)"+CSQ: ")-(char*)AT_reBuf;
		i+=5;
		retData[0]= 0;
		while(AT_reBuf[i]!=','&&i<AT_reLength)
		{
			if(AT_reBuf[i]>='0' && AT_reBuf[i]<='9')
				retData[0] = retData[0]*10 + (AT_reBuf[i]-'0');
			i++;
		}
		if(retData[0]!=0)
	    {
			retData[0] = (uint16_t)100*(retData[0])/31;
			break;
		}
		Delay_ms(1000);
	}
	if(j==3)goto uecom_baseInfo_exit;  //3ξʧܣΪȡźǿʧ
    //3ûվ
	ret = 2;           //ô󷵻Ϊ2
	//3.1ģ鷢ͻȡվŵָ
	if(uecom_sendCmd((uint8_t *)MENGINFO,500,3))
		goto uecom_baseInfo_exit;
	//3.2ӽյнվţretData
	p =(uint8_t *) strstr((const char *)AT_reBuf,(const char *)"*MENGINFOSC:");   //ַ':'ڵλãΪݡ
	j = 1;
	i = 0;
	strncpy((char *)retData+1,(const char *)"460,11,",7);
	j+=7;
	while(i<3)//
	{
		if(*p == ',')
			i++;
		p++;
	}
	++p;//cell ID
	while((*p)!='\"')//ȡcell ID
	{
		retData[j++] = *p;
		p++;
	}
	retData[j++] =',';
	while(i<9)//ھŸ
	{
		if(*p == ',')
			i++;
		p++;
	}
	++p;//TAC
	while((*p)!='\"')//ȡTAC
	{
		retData[j++] = *p;
		p++;
	}
	if(j<=0)  //δܳɹ
		goto uecom_baseInfo_exit;   //˳
	//һɾΪַ
	retData[j]=0;
    //4ˣ˵ִгɹ
    ret = 0;          //ֵΪ0
    uecom_baseInfo_exit:
    return ret;
}

//====================================================================
//ƣuecom_ modelInfo
//أ0ȡģϢɹ1ȡģϢʧ
//˵retData洢صϢ,ٷ40ֽڡ
//          ϢɣIMEI (20ֽ)+IMSI20ֽڣ
//ܸҪҪģصϢIMEIţIMSI
//޸ڣ20180718,LXD
//=====================================================================
uint8_t uecom_modelInfo (uint8_t retData[40])
{
	int i;
	//1ӱȫֱȡIMEIֵ
	for(i=0;i<15;i++)
		retData[i]=IMEI[i];
	retData[i] = 0;    //
	//2ӱȫֱȡIMSIֵ
	for(i=20;i<35;i++)
		retData[i]=IMSI[i-20];
	retData[i] = 0;   //
	return 0;
}

//======================================================================
//ƣuecom_typeGet
//أ
//˵type:«ͺ
//ܸҪȡ«ͺ
//======================================================================
uint8_t uecom_typeGet(uint8_t *type)
{
	memcpy(type,uecomType,sizeof(uecomType));
	return 0;
}

//======================================================================
//ƣuecom_biosVerGet
//أ
//˵biosVer:«汾ͨģͺţ
//ܸҪȡ«汾
//======================================================================
void uecom_version(uint8_t *version)
{
	memcpy(version,uecomVersion,sizeof(uecomVersion));
}

//====================================================================
//ƣhttp_get
//أ0getɹ1ʼhttpʧܣ2urlʧܣ3ʧܣ
//                4ʧܣ5ʧܣ6ʧܣ7÷ʧܣ
//˵ip:Ŀַport :Ŀַurl:getݡresult:get󷵻صĽ
//                鳤ԤƷصĳȣûӦ֪ݣ*1.5
//ܸҪhttpget󣬲ؽ洢result
//=====================================================================
uint8_t uecom_httpGet (uint8_t ip[],uint8_t port[],uint8_t url[],
		uint8_t result[])
{
	return 1;
}



//------Ϊõڲ--------------------------------------------
//====================================================================
//ƣuecom_sendCmd
//أ0ָͳɹ;1ָʧ
//˵cmdҪ͵ATָ׵ַ"wait""SEND";
//        ֽ;maxDelayMs:ÿȴʱ;maxTimes:෢
//ע"wait"жǷԷݣ֡CONNECT"SEND"жϷǷɹ
//ܸҪATָȡϢ
//޸ڣ2018-06-30,LXD
//====================================================================
uint8_t uecom_sendCmd(uint8_t *cmd,uint16_t maxDelayMs,uint16_t maxTimes)
{
	//жϷʽʵ
    //1͸ֵ
	uint8_t ret;
	uint16_t i,j,count;
	uint8_t waitStr[30]="OK";       //ŷATָеַĬΪ"OK"
	AT_reLength = 0;
	AT_reBuf[0]=0;//ַڽжٽһֽʱλøֵ0
	if(strcmp(( const char *)cmd,( const char *)"wait")==0)//жϷ꿪ָAT+ESOSENDRAW
		strcpy((char *)waitStr,( const char *)"CONNECT"); //ǷյCONNECTӶȥ
		
		//cmd="wait";waitstr="CONNECT"
		//cmd;waitstr="OK"
		
	AT_haveCommand=1;  //λAT־
	Delay_ms(10);//ֹAT͹Ƶ
	j = maxDelayMs/100;
	uart_enable_re_int(UART_UE);//ж
	for(count=0;count<maxTimes;count++)
	{
		//ATָ
		if(strcmp(( const char *)cmd,( const char *)"SEND") && strcmp(( const char *)cmd,( const char *)"wait"))
		{
			AT_reLength = 0;
			AT_reBuf[0]=0;//ַڽжٽһֽʱλøֵ0
			uart_send_string(UART_UE,cmd); //ͨڷATָ
		}
		//ȴmaxDelayMs
		for(i=0; i<j;i++)
		{
	        Delay_ms(100);
	        if(strstr(( const char *)AT_reBuf,( const char *)waitStr))
	        {
	        	ret = 0;
	        	goto uecom_sendCmd_exit;
	        }
	        if(strstr(( const char *)AT_reBuf,( const char *)ERROR))
	        {
	        	Delay_ms(200);//100
	        	break;
	        }
		}
		//ˣ˵δյȷء
    	j*=2;//ʧܣһηָʱȴʱӱ
	}
	ret = 1;
	uecom_sendCmd_exit:
	AT_haveCommand=0;
	return ret;
}

//==================================================================
//ƣuecom_internal_getIMEI
//أ 0ȡIMEIɹ1ȡIMEIʧܣ2IMEIʧ
//˵destŷصIMEIţ15λ
//ܸҪȡ豸IMEI
//ڲãuecom_sendCmd
//޸ڣ2018-06-30,LXD
//==================================================================
uint8_t uecom_internal_getIMEI(uint8_t *dest)
{
    //1͸ֵ
    uint8_t ret_val;
    uint8_t *p,*start,*end;
    //2ȡIMEI
    dest[15] = 0;        //ַĽβ
    if(uecom_sendCmd((uint8_t *)GSN,200,4))
    {
		uecom_sendCmd((uint8_t *)AT,100,4);
		if(uecom_sendCmd((uint8_t *)GSN,200,5))
		{
			ret_val = 1;
			goto uecom_internal_getIMEI_exit;      //ȡIMEIʧ
		}
    }

    //strstr(str1,str2) жַstr2Ƿstr1Ӵ
    //ǣústr2str1״γֵĵַ򣬷NULL

    //3IMEIŴ洢dest
    p =(uint8_t *) strstr((const char *)AT_reBuf,(const char *)"OK");
    while(p>=AT_reBuf&&(*p<'0'||*p>'9'))p--;    //ҵһڵλ
    end=p;
    while(p>=AT_reBuf && *p>='0' && *p<='9')p--;//ҵһڵλ
    start=p+1;
    if(start>end)
    {
        ret_val = 2;
        goto uecom_internal_getIMEI_exit;      //صвIMEI
    }

    //void *memcpy(void *dest, const void *src, size_t n);
    //ԴsrcָڴַʼλÿʼnֽڵĿdestָڴַʼλ

    memcpy(dest,start,end-start+1);//ȡ
    dest[end-start+1]=0;//
    ret_val = 0;
    //˳
uecom_internal_getIMEI_exit:
    return ret_val;
}

//==================================================================
//ƣuecom_internal_getIMSI
//أ0ȡIMSIɹ1ȡIMSIʧ
//˵destŷصIMSIţ15λ
//ܸҪȡ豸IMSI
//ڲãuecom_sendCmd
//޸ڣ2018-06-30,LXD
//==================================================================
uint8_t uecom_internal_getIMSI(uint8_t *dest)
{
    //1͸ֵ
    uint8_t ret_val;
//    uint8_t i,k;
    uint8_t *p,*start,*end;
    dest[14] = 0;
    //2ȡIMSI
	if(uecom_sendCmd((uint8_t *)CIMI,6000,2))
	{
		uecom_sendCmd((uint8_t *)AT,100,4);
		if(uecom_sendCmd((uint8_t *)CIMI,6000,1))
		{
			ret_val = 1;
			goto uecom_internal_getIMSI_exit;     //ȡIMSIʧ
		}
	}

	//strstr(str1,str2) жַstr2Ƿstr1Ӵ
	//ǣústr2str1״γֵĵַ򣬷NULL

    //3IMSIŴ洢dest
    p = (uint8_t *)strstr((const char *)AT_reBuf,(const char *)"OK");
    while(p>=AT_reBuf&&(*p<'0'||*p>'9'))p--;    //ҵһڵλ
    end=p;
    while(p>=AT_reBuf && *p>='0' && *p<='9')p--;//ҵһڵλ
    start=p+1;
    if(start>end)
    {
        ret_val = 2;
        goto uecom_internal_getIMSI_exit;       //صвIMSI
    }

    //void *memcpy(void *dest, const void *src, size_t n);
    //ԴsrcָڴַʼλÿʼnֽڵĿdestָڴַʼλ

    memcpy(dest,start,end-start+1);             //ȡ
    dest[end-start+1]=0;                        //
    ret_val = 0;
    //˳
uecom_internal_getIMSI_exit:
    return ret_val;
}

//====================================================================
//ƣuint_to_str
//أ
//˵ch:ת        *strתַ
//ܸҪ޷תΪַ
//====================================================================
void uint_to_str(uint32_t ch,char *str)
{
    int i,j,sign;
    char s[10];
    if((sign=ch)<0)//¼
        ch=-ch;//ʹnΪ
    i=0;
    do{
           s[i++]=ch%10+'0';//ȡһ
    }
    while ((ch/=10)>0);//ɾ
    if(sign<0)
      s[i++]='-';
    for(j=i-1;j>=0;j--)//ɵģҪ
           str[i-1-j]=s[j];
    str[i]=0;
}

//====================================================================
//ƣframeEncode
//ܸҪʵִݵ֡,ݼ֡ͷ֡֡βԼУϢ
//       frame=֡ͷ+IMSI+data+data+CRCУ+֡β
//˵imsiݵ豸IMSI
//       data:֡ͷָ
//       dlen:֡ݳ
//       frame:֮֡Ĵ֡
//       framelen:֡ݳ
//أ
//====================================================================
void frameEncode(uint8_t *imsi,uint8_t *data,uint16_t dlen,
                 uint8_t *frame,uint16_t *framelen)
{
    uint16_t crc,len;

    //֡
    //֡ͷ
    frame[0] = frameHead[0];
    frame[1] = frameHead[1];
    len = 2;
    //IMSI
    strncpy((char *)frame+2,(const char *)imsi,15);
    len += 15;
    //data
    frame[len++] = dlen>>8;
    frame[len++] = dlen;
    //data
    memcpy(frame+19,data,dlen);
    len += dlen;
    //CRCУ
    crc = ue_crc16((uint8_t *)(frame+2),dlen+17);//IMSIšdataȺdataCRCУ
    frame[len++] = crc>>8;
    frame[len++] = crc;
    //֡β
    frame[len++] = frameTail[0];
    frame[len++] = frameTail[1];
    frame[len] = 0;
    *framelen = len;
}

//====================================================================
//ƣuecom_recv
//أ0յͨTCP/UDPݣ1ڽ֡2ݴ
//˵chڽյ(1ֽ)*dataLen:洢յݳȣ
//      *data:յݴŵ;
//ܸҪԽյԷݽн֡Чݴdata֮Уɴڵuartжϵá
//޸ڣ2018-06-30,LXD
//====================================================================
//uint8_t uecom_recv(uint8_t ch,uint16_t *dataLen, uint8_t *data)
//{
//    static uint16_t index1 = 0;   //֡
//    static uint16_t length = 0;  //ݳ
//    uint8_t ret_val;
//    uint16_t i;
//    uint8_t MCRC[2];
//    uint16_t mcrc;
//    //δ֡ͷδյ֡ͷ(֡)
//    if((index1 == 0 && ch != frameHead[0]) ||
//      (index1 == 1 && ch != frameHead[1]))
//    {
//    	index1 = 0;
//        length = 0;
//        ret_val = 2;     //ݴ
//        goto uecom_recv_exit;
//    }
//    //˵Է
//    data[index1++] = ch;  //洢֡
//    if(index1 == 19)      //ȡdata
//    {
//        length = ((uint16_t)data[17]<<8) + data[18];
//    }
//    //յݴﵽһ֡ȡlength+23Ϊ֡
//    if(length != 0 && index1 >= length+23)
//    {
//        //CRCУ
//        mcrc = ue_crc16((uint8_t *)data+2,length+17);
//        MCRC[0] = (mcrc>>8)&0xff;
//        MCRC[1] = mcrc&0xff;
//        if(data[index1-2]!=frameTail[0] ||
//        		data[index1-1]!= frameTail[1]  //δ֡β
//            || MCRC[0] != data[length+19] ||
//			MCRC[1] != data[length+20])        //CRC
//        {
//        	index1 = 0;
//            length = 0;
//            ret_val = 2;         //ݴ
//            goto uecom_recv_exit;
//        }
//        for(i=0;i<length;i++)
//        {
//            data[i] = data[i+19];//19ΪЧֽǰݳ
//        }
//        *dataLen = length;
//
//        index1 = 0;
//        length = 0;
//        ret_val = 0;             //յͨTCP/UDP
//        goto uecom_recv_exit;
//    }
//    *dataLen = 0;
//    ret_val = 1;//ڽ֡
//uecom_recv_exit:
//    return ret_val;
//}

//=====================================================================
//ƣuecom_transparentRecv
//أ0յͨTCP/UDPݣ1δյ
//˵ch:ڽյ
//                   *dataLen:洢յݳ
//                   *data:յݴŵ鴮;
//ܸҪ͸պյݴdata֮Уɴڵuartжϵá
//޸ڣ20180922,LXD
//=====================================================================
uint8_t uecom_transparentRecv(uint8_t ch,uint16_t *dataLen, uint8_t *data)
{
	static uint8_t flag = 0;
	static uint16_t recvLength = 0;
	static uint16_t index = 0;
	uint8_t ret_val = 1;
	switch(flag)
	{
	case 0:    if(ch=='+')flag=1; else flag = 0;break;
	case 1:    if(ch=='E')flag=2; else flag = 0;break;
	case 2:    if(ch=='S')flag=3; else flag = 0;break;
	case 3:    if(ch=='O')flag=4; else flag = 0;break;
	case 4:    if(ch=='N')flag=5; else flag = 0;break;
	case 5:    if(ch=='M')flag=6; else flag = 0;break;
	case 6:    if(ch=='I')flag=7; else flag = 0;break;
	case 7:    if(ch=='=')flag=8; else flag = 0;break;
	case 8:    if(ch=='0')flag=9; else flag = 0;break;
	case 9:    if(ch==',')flag=10; else flag = 0;recvLength = 0;break;
	case 10:   if(ch==','){flag=11;index=0;}else recvLength=recvLength*10+ch-'0';break;
	case 11:
	//֡ʽ
		if(index<recvLength)
		{
			data[index++]=ch;
		}
		else
		{
			ret_val = 0;
			*dataLen = recvLength;
			flag = 0;
		}
		break;
	}
    return ret_val;
}

//====================================================================
//ƣuecom_recvLocation
//أ0յ˶λϢ1ݴ
//˵chڽյ(1ֽ); *data:յݴŵ;
//ܸҪյһжλϢdata֮Уɴڵuartжϵá
//޸ڣ2018-07-17,LXD
//====================================================================
uint8_t uecom_recvLocation(uint8_t ch, uint8_t *data)
{
	static uint16_t index2 = 0;   //
    uint8_t ret_val,*p,j;
    ret_val=0;
    //յǰֽڲ$GN,ΪǶλϢ
    if((index2 == 0 && ch != '$')
    	||(index2 == 1 && ch != 'G')
		||(index2 == 2 && ch != 'N')
		||(index2 == 3 && ch != 'R')
		||(index2 == 4 && ch != 'M')
		||(index2 == 5 && ch != 'C')
		)
    {
    	index2 = 0;
        ret_val = 1;     //ݴ
        goto uecom_recv_exit;
    }
    //˵ǶλϢ
    data[index2++] = ch;      //洢յλϢ
    if(ch=='\n') //յһЧλϢ
    {
    	if(data[17]=='A')
    	{
    		p =(uint8_t *) strstr((const char *)data,(const char *)",");   //ַ','һڵλ
    		j=0;                    //Ƕ
    		while(j<9)              //λ9
    		{
    			if(*p==',')
    				j++;
    			p++;
    		}
    		if((*p)!=',')        //յڣھŸźڣ
    		{
    			locationFlag=1;//λյһЧλϢ־
    			index2 = 0;
    			ret_val = 0;     //յһжλϢ
    			goto uecom_recv_exit;
    		}
    	}
		index2 = 0;
		ret_val = 1;
    }
uecom_recv_exit:
        return ret_val;
}

//======================================================================
//ƣuecom_getTime  վʱ
//أɹʱ1970.1.1   ʧܣ0
//˵
//ܸҪȡվʱ䣬ʱĸʽأҪͨģ
//          վʼʹ
//======================================================================
void uecom_getTime(uint8_t dateform[20])
{
	//1͸ֵ
	uint8_t m;
	uint8_t statu;
	uint16_t i,j;
	//ʱ ʮ
	int tyear=0;
	uint16_t tmonth;
	uint16_t tday;
	uint16_t thour;
	uint16_t tmin;
	uint16_t tsec;
	uint8_t datetime[20];
	//2ͻȡʱָ
	for(m=0;m<50;m++) AT_reBuf[m]=0;
	if(uecom_sendCmd((uint8_t *)METIME,200,1))
	{
		uecom_sendCmd((uint8_t *)AT,100,4);
		if(uecom_sendCmd((uint8_t *)METIME,200,1))
		{
			//ret_val = 0;
			goto uecom_getTime_exit;     //ȡIMSIʧ
		}
	}
	Delay_ms(50);
	i=0;
	statu=0;
	//˶ַ
	while(AT_reBuf[i]!=0 && i<50)
	{
		if(statu==0)
		{
			if(AT_reBuf[i]=='L') statu=1;
		}
		else if(statu==1)
		{
			if(AT_reBuf[i]=='K') statu=2;
			else statu=0;
		}
		else if(statu==2)
		{
			if(AT_reBuf[i]==':') statu=3;
			else statu=0;
		}
		else if(statu==3)	break;
		i++;
	}
	if(statu!=3) return;  //ַ󣬷سʼʱ
	ArrayCopy(AT_reBuf,AT_reBuf+i,50-i);     //ַǰ
	tyear=0;
	tmonth=0;
	tday=0;
	thour=0;
	tmin=0;
	tsec=0;
	j=0;
	while(AT_reBuf[j]!=0&&AT_reBuf[j]!='/'&&j<50)
	{
		tyear=tyear*10+AT_reBuf[j]-'0';
		j++;
	}
	datetime[0]=tyear/1000;
	datetime[1]=(tyear/100)%10;
	datetime[2]=(tyear/10)%100;
	datetime[3]=tyear%10;
    datetime[4]=0;
	j++;
	while(AT_reBuf[j]!=0&&AT_reBuf[j]!='/')
	{
		tmonth=tmonth*10+AT_reBuf[j]-'0';
		j++;
	}
	datetime[5]=tmonth/10;
	datetime[6]=tmonth%10;
    datetime[7]=0;
	if(AT_reBuf[j]==0) return;
	j++;
	while(AT_reBuf[j]!=0&&AT_reBuf[j]!=',')
	{
		tday=tday*10+AT_reBuf[j]-'0';
		j++;
	}
	datetime[8]=(tday/10);
	datetime[9]=(tday%10);
    datetime[10]=0;
	if(AT_reBuf[j]==0) return;
	j++;
	while(AT_reBuf[j]!=0&&AT_reBuf[j]!=':')
	{
		thour=thour*10+AT_reBuf[j]-'0';
		j++;
	}
	//϶ʱ
	thour=thour+8;
	if(thour>24)
	{
		thour=thour-24;
		tday=tday+1;
		if(tday>28 && tmonth==2)
		{
			if(tyear%4==0)
				tday=tday+1;
			else
			{
				tday=1;
				tmonth=tmonth+1;
			}
		}
		if(tday>30)
		{
			switch(tmonth)
			{
				case 1:
				case 3:
				case 5:
				case 7:
				case 8:
				case 10:
				case 12:
						tday=tday+1;break;
				case 4:
				case 6:
				case 9:
				case 11:
				{
					tday=1;
					tmonth=tmonth+1;
					if(tmonth>12)
					{
						tmonth=1;
						tyear=tyear+1;
					}
					break;
				}
			}
		}
	}
	datetime[0]=tyear/1000;
	datetime[1]=(tyear/100)%10;
	datetime[2]=(tyear/10)%100;
    datetime[3]=tyear%10;
	datetime[4]=0;
	datetime[8]=(tday/10);
	datetime[9]=(tday%10);
    datetime[10]=0;
	datetime[11]=(thour/10);
	datetime[12]=(thour%10);
    datetime[13]=0;
	if(AT_reBuf[j]==0) return;
	j++;
	while(AT_reBuf[j]!=0&&AT_reBuf[j]!=':')
	{
		tmin=tmin*10+AT_reBuf[j]-'0';
		j++;
	}
	datetime[14]=(tmin/10);
	datetime[15]=(tmin%10);
    datetime[16]=0;
	if(AT_reBuf[j]==0) return;
	j++;
	while(AT_reBuf[j]!=0&&AT_reBuf[j]!='G')
	{
		tsec=tsec*10+AT_reBuf[j]-'0';
		j++;
	}
	datetime[17]=(tsec/10);
	datetime[18]=(tsec%10);
	datetime[19]=0;
    for(int t=0;t<20;t++)
    {
        if ((t!=4) && (t!=7) && (t!=10) && (t!=13)&&(t!=16)&&(t!=19))
        {
        	dateform[t]=datetime[t]+0x30;  //תΪASCIIַ
        }
    }
	AT_reLength = 0;
	AT_reBuf[0]=0;//ַڽжٽһֽʱλøֵ0
	Delay_ms(100);
	//˳
   uecom_getTime_exit:
   return;
}

//=====================================================================
//ƣue_crc16
//ܸҪݽ16λCRCУ飬УĽֵ
//˵ptr:ҪУݻ
//      len:Ҫݳ
//أõУֵ
//=====================================================================
uint16_t ue_crc16(uint8_t *ptr,uint16_t len)
{
	uint16_t i,j,tmp,crc16;

	crc16 = 0xffff;
	for(i = 0;i < len;i++)
	{
		crc16 = ptr[i]^crc16;
		for(j = 0;j< 8;j++)
		{
			tmp = crc16 & 0x0001;
			crc16 = crc16>>1;
			if(tmp)
				crc16 = crc16^0xa001;
		}
	}
	return crc16;
}


//=====================================================================
//ƣArrayCopy
//أ
//˵destƺŵ飻sourceƵ飻len:Ƶĳ
//ܸҪԴ鸴ָȵݵĿ
//=====================================================================
void ArrayCopy(uint8_t * dest,uint8_t * source,uint16_t len)
{
	uint16_t i = 0;
	for(i=0;i<len;i++)
		dest[i]=source[i];
}

//======================================================================
//ƣDelay_ms
//أ
//˵
//ܸҪʱ - 뼶
//======================================================================
void Delay_ms(uint16_t u16ms)
{
	uint32_t u32ctr;
	for(u32ctr = 0; u32ctr < (SystemCoreClock/1000*u16ms/100); u32ctr++)
	{
		 __asm ("nop");
	}
}
