//======================================================================
//ļƣwifi.hwifiͷļ򻯰棩
//λմarm(sumcu.suda.edu.cn)
//¼¼20190504
//======================================================================
#ifndef _WIFI_H_
#define _WIFI_H_

#include "gec.h"
#include "stdlib.h"
#include "string.h"
#include "emuart.h"

//WIFIͨʹõUARTģ飬ʵʹ޸
#define UART_WIFI UART_1

//WIFIԴ
#define POWER_PIN PTB_NUM|1

//庯״̬
#define WIFI_OK 0
#define WIFI_ERROR 1
#define WIFI_NORESPONSE 2

//ģʽ
#define WIFI_STATION 1
#define WIFI_AP      2
#define WIFI_ST_AP   3

typedef struct{
	uint8_t stamac[18];
	uint8_t apmac[18];
}MAC;

//======================================================================
//ƣwifi_init
//ܸҪʼwifiģ
//˵mode_type:ģΪͻ˻AP;
//         mode_name:ģAPģʽµSSID;
//         pssword:Ҫõַ64λASCIIַ;
//         chn:wifiŵţ1~13ֻ1611ŵ;
//         ip:Wi-FiģSTAģʽµIPַ,Ϊ0.0.0.0ʾDHCP
//أ
//======================================================================
void wifi_init(uint8_t mode_type,uint8_t* mode_name,uint8_t* pssword,uint8_t chn,uint8_t* ip);

//======================================================================
//ƣwifi_reset
//ܸҪģ
//˵
//أ
//======================================================================
void wifi_reset();

//======================================================================
//ƣwifi_int_re
//ܸҪжϽַ
//˵ch:Ҫַܵ*dataLen:洢յݳȣ
//      *data:յݴŵ;
//أ
//======================================================================
void wifi_int_re(uint8_t ch,uint16_t *dataLen, uint8_t *data);

//======================================================================
//ƣwifi_resolve_domain
//ܸҪap󣬽
//˵domain:,retVal:ŵĻ
//أǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_resolve_domain(uint8_t* domain,uint8_t* retVal);

//======================================================================
//ƣwifi_ping
//ܸҪappingָipҲ
//˵address:ҪpingĿַ,timepingͨʱ
//أǷpingͨ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_ping(uint8_t* address,uint8_t* time);

//======================================================================
//ƣwifi_get_state
//ܸҪȡģ״̬
//˵
//أ=0δWIFIͷ,=1WIFIδӷ,=3WIFIͷ
//======================================================================
uint8_t wifi_get_state();

//======================================================================
//ƣwifi_get_mac
//ܸҪȡmac
//˵mac:ػȡmacֵ
//أȡɹ1ʧܷ0
//======================================================================
uint8_t wifi_get_mac(MAC* mac);

//======================================================================
//ƣwifi_linktossid
//ܸҪָwifi
//˵ssid:,password:
//أǷɹ=1ɹ=0ʧ
//======================================================================
uint8_t wifi_linktossid(uint8_t* ssid,uint8_t* password);

//======================================================================
//ƣwifi_quitssid
//ܸҪϿwifi
//˵
//أϿǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_quitssid();

//======================================================================
//ƣwifi_con_srv
//ܸҪ
//˵ip:IPַ,port:˿ںţΪַʽ,
//       ʽ"xxx.xxx.xxx.xxx",xxxȡֵΧ0-255
//أ=0ӳɹ,=1ʧ,=2ڷģʽ
//======================================================================
uint8_t wifi_con_srv(uint8_t* ip,uint8_t* port);

//======================================================================
//ƣwifi_recvN
//ܸҪջNֽڵ
//˵data:ؽݰ
//أʵʽյֽݷ0
//======================================================================
uint8_t wifi_recvN(uint8_t *data,uint8_t len);

//======================================================================
//ƣwifi_sendN
//ܸҪӽNַ
//˵data:Ҫ͵ַ,ַó2048,length:ݳ
//أǷɹ=0ɹ=1=2޷
//======================================================================
uint8_t wifi_sendN(uint8_t* data,uint16_t length,uint8_t* IMSI);

//======================================================================
//ƣwifi_set_ip
//ܸҪstaģʽWiFiģIPַ
//˵ip:ҪõIPַ
//أ=0óɹ=1ʧܣ=2WiFiģӦ
//======================================================================
uint8_t wifi_set_ip(uint8_t* ip);
//uint8_t wifi_sendN(uint8_t* data,uint16_t length,uint8_t id);

uint8_t wifi_disconnect();


#endif
