//===========================================================================
//ļƣflash.c
//ܸҪFlashײԴļ
//ȨУSD-Arm(sumcu.suda.edu.cn)
//汾£20181201-20200221
//оƬͣSTM32
//===========================================================================
//ͷļ
#include "flash.h"
#include "string.h"

//=================ڲú=====================================
//======================================================================
//ƣflash_write_DoubleWord
//أ0-ɹ 1-ʧ
//˵addrĿַҪΪ4ıҴFlash׵ַ
//              磺0x08000004Flash׵ַΪ0x08000000
//       dataд˫
//ܸҪFlash˫д
//======================================================================
uint8_t flash_write_DoubleWord(uint32_t addr,uint32_t data_l,uint32_t data_h);

//======================================================================
//======================================================================

//=================ⲿӿں=========================================
//======================================================================
//ƣflash_init
//أ
//˵
//ܸҪʼflashģ
//======================================================================
void flash_init(void)
{
	//д־λCC_Ķ
	FLASH->SR &= 0xFFFFFFUL;
	//FlashƼĴ(CR)
	if((FLASH->CR & FLASH_CR_LOCK) != 0U)
    {
		FLASH->KEYR = (uint32_t)FLASH_KEY1;
		FLASH->KEYR = (uint32_t)FLASH_KEY2;
    }

    //ȴ֮ǰһflash
	while( (FLASH->SR & FLASH_SR_BSY) != 0U);

	//ݻ
    FLASH->ACR &= ~FLASH_ACR_DCEN_Msk;
    //漴ʱλ
    FLASH->CR &= ~FLASH_CR_PG_Msk;
}
//======================================================================
//ƣflash_erase
//أִִ״̬0=1=쳣
//˵sectĿţΧȡʵоƬ STM32L433:0~127,ÿ2KB;
//ܸҪflash洢sect
//======================================================================
uint8_t flash_erase(uint16_t sect)
{
	//ȴ֮ǰһflash
	while( (FLASH->SR & FLASH_SR_BSY) != 0U);
	//漴ʱλ
    FLASH->CR &= ~FLASH_CR_PG;

    //ʹ
	FLASH->CR |= FLASH_CR_PER;
	//ò
	FLASH->CR &= ~FLASH_CR_PNB;
	FLASH->CR |= (uint32_t)(sect << 3u);
	//ʼ
	FLASH->CR |= FLASH_CR_STRT;
	//ȴ
	while( (FLASH->SR & FLASH_SR_BSY) != 0U);
	//ֹ
	FLASH->CR &= ~FLASH_CR_PER;

    return 0;  //ɹ
}
//======================================================================
//ƣflash_write
//أִ״̬0=1=쳣
//˵sectţΧȡʵоƬ STM32L433:0~127,ÿ2KB
//        offset:дڲƫƵַ0~2044ҪΪ0,4,8,12......
//        NдֽĿ4~2048,ҪΪ4,8,12,......
//        bufԴݻ׵ַ
//ܸҪbufʼNֽд뵽flash洢sect offset
//=======================================================================
uint8_t flash_write(uint16_t sect,uint16_t offset,uint16_t N,uint8_t *buf)
{
	uint32_t addr;    //˫дԵַ
	uint32_t i,j;    //
	uint32_t temp_l,temp_h;    //temp_l˫еλ֣temp_h˫иλ
    uint32_t wCount;  //˫(64λ)д
    uint8_t PadNum,PadCount;  //ֽڣ
    uint8_t PadArray[8];  //飬Ų
    uint16_t front_offset;  //ַƫƣ˫(64λ)
	front_offset = offset%8;//ַƫ
	if(front_offset == 0)  //ַ˫ֶ룬д
    {
        wCount = (N-1)/8+1;  //˫д
        PadNum = wCount*8-N;  //貹ֽ
        addr = (uint32_t)(FLASH_BASE+sect*FLASH_PAGE_SIZE+offset+N);  //ȡַ
	    flash_read_physical((PadArray+(8-PadNum)),addr,PadNum);  //ȡ貹ֵַ벹
		//ȴ֮ǰһflash
		while( (FLASH->SR & FLASH_SR_BSY) != 0U);
		//˫дԵַ
		addr = (uint32_t)(FLASH_BASE+sect*FLASH_PAGE_SIZE+offset);
	
		if(N<=8) //дݲ˫ֵ֣˫ֳ
	    {
			PadCount = 0;
			for(i = 0;i < N; i++)
			{
				PadArray[PadCount] = buf[i];
				PadCount++;
			}
			temp_l =(uint32_t)((PadArray[0])|(PadArray[1]<<8)|(PadArray[2]<<16)|(PadArray[3]<<24));
			temp_h =(uint32_t)((PadArray[4])|(PadArray[5]<<8)|(PadArray[6]<<16)|(PadArray[7]<<24));
			flash_write_DoubleWord((addr),temp_l,temp_h);
	    }
	    else
		{
			//ѭд˫֣ÿ8дһΣ8Զ
			for(i = 0; i < (N-8); i+=8)
			{
				//λֵָ
    			temp_l = (uint32_t)((buf[i])|(buf[i+1]<<8)|(buf[i+2]<<16)|(buf[i+3]<<24));
    			//λֵָ
				temp_h = (uint32_t)((buf[i+4])|(buf[i+5]<<8)|(buf[i+6]<<16)|(buf[i+7]<<24));
				//ھԵַ(addr+i)ʵ˫д
				flash_write_DoubleWord((addr+i),temp_l,temp_h);
			}
		    PadCount = 0;  //
		    //δдֽ벹ϳ˫
			for(j = i;j<N;j++)
			{
				PadArray[PadCount] = buf[j];
				PadCount++;
			}
			//λֵָ
			temp_l =(uint32_t)((PadArray[0])|(PadArray[1]<<8)|(PadArray[2]<<16)|(PadArray[3]<<24));
			//λֵָ
			temp_h =(uint32_t)((PadArray[4])|(PadArray[5]<<8)|(PadArray[6]<<16)|(PadArray[7]<<24));
			//ھԵַ(addr+i)ʵ˫д
			flash_write_DoubleWord((addr+i),temp_l,temp_h);	
		}
	}
	else    //ַ˫ֶ룬д
	{
		addr = (uint32_t)(FLASH_BASE+sect*FLASH_PAGE_SIZE+offset);  //дַ
		flash_read_physical(PadArray,(addr-front_offset),front_offset);//ȡַǰ貹ֵַ벹
		PadCount = 0; //
		//Ҫдֽ벹ϳ˫
		for(i = front_offset; i < 8; i++)
		{
			PadArray[i] = buf[PadCount];
			PadCount++;
		}
		//λֵָ
		temp_l =(uint32_t)((PadArray[0])|(PadArray[1]<<8)|(PadArray[2]<<16)|(PadArray[3]<<24));
		//λֵָ
		temp_h =(uint32_t)((PadArray[4])|(PadArray[5]<<8)|(PadArray[6]<<16)|(PadArray[7]<<24));
		//ھԵַ(addr+i)ʵ˫д
		flash_write_DoubleWord((addr-front_offset),temp_l,temp_h);
		//ʣµд
		flash_write_physical(addr+(8-front_offset),N-(8-front_offset),(buf+(8-front_offset)));
	}
	
	//ȴд
	while( (FLASH->SR & FLASH_SR_BSY) != 0U);
	return 0;  //ɹִ
}

//==========================================================================
//ƣflash_write_physical
//أִ״̬0=0=쳣
//˵ addrĿַҪΪ4ıҴFlash׵ַ
//              磺0x08000004Flash׵ַΪ0x08000000
//       cntдֽĿ8~512
//       bufԴݻ׵ַ
//ܸҪflashд
//==========================================================================
uint8_t flash_write_physical(uint32_t addr,uint16_t N,uint8_t buf[])
{
	uint32_t Raddr;    //ݶȡַ
	uint32_t i,j;    //
	uint32_t temp_l,temp_h;    //temp_l˫еλ֣temp_h˫иλ
    uint32_t wCount;  //˫(64λ)д
    uint8_t PadNum,PadCount;  //ֽڣ
    uint8_t PadArray[8];  //飬Ų
    uint16_t front_offset;  //ַƫƣ˫(64λ)
	front_offset = addr%8;//ַƫ
	if(front_offset == 0)  //ַ˫ֶ룬д
    {
        wCount = (N-1)/8+1;  //˫д
        PadNum = wCount*8-N;  //貹ֽ
        Raddr = (uint32_t)(addr+N);  //ȡַ
	    flash_read_physical((PadArray+(8-PadNum)),Raddr,PadNum);  //ȡ貹ֵַ벹
		//ȴ֮ǰһflash
		while( (FLASH->SR & FLASH_SR_BSY) != 0U);
	
		if(N<=8) //дݲ˫ֵ֣˫ֳ
	    {
			PadCount = 0;//
			//Ҫдֽ벹ϳ˫
			for(i = 0;i < N; i++)
			{
				PadArray[PadCount] = buf[i];
				PadCount++;
			}
			//λֵָ
			temp_l =(uint32_t)((PadArray[0])|(PadArray[1]<<8)|(PadArray[2]<<16)|(PadArray[3]<<24));
			//λֵָ
			temp_h =(uint32_t)((PadArray[4])|(PadArray[5]<<8)|(PadArray[6]<<16)|(PadArray[7]<<24));
			//ھԵַ(addr+i)ʵ˫д
			flash_write_DoubleWord(addr,temp_l,temp_h);
	    }
	    else
		{
			//ѭд˫֣ÿ8дһΣ8Զ
			for(i = 0; i < (N-8); i+=8)
			{
				//λֵָ
    			temp_l = (uint32_t)((buf[i])|(buf[i+1]<<8)|(buf[i+2]<<16)|(buf[i+3]<<24));
    			//λֵָ
				temp_h = (uint32_t)((buf[i+4])|(buf[i+5]<<8)|(buf[i+6]<<16)|(buf[i+7]<<24));
				//ھԵַ(addr+i)ʵ˫д
				flash_write_DoubleWord((addr+i),temp_l,temp_h);
			}
		    PadCount = 0;  //
		    //δдֽ벹ϳ˫
			for(j = i;j<N;j++)
			{
				PadArray[PadCount] = buf[j];
				PadCount++;
			}
			//λֵָ
			temp_l =(uint32_t)((PadArray[0])|(PadArray[1]<<8)|(PadArray[2]<<16)|(PadArray[3]<<24));
			//λֵָ
			temp_h =(uint32_t)((PadArray[4])|(PadArray[5]<<8)|(PadArray[6]<<16)|(PadArray[7]<<24));
			//ھԵַ(addr+i)ʵ˫д
			flash_write_DoubleWord((addr+i),temp_l,temp_h);	
		}
	}
	else    //ַ˫ֶ룬д
	{
		flash_read_physical(PadArray,(addr-front_offset),front_offset);//ȡַǰ貹ֵַ벹
		PadCount = 0; //
		//Ҫдֽ벹ϳ˫
		for(i = front_offset; i < 8; i++)
		{
			PadArray[i] = buf[PadCount];
			PadCount++;
		}
		//λֵָ
		temp_l =(uint32_t)((PadArray[0])|(PadArray[1]<<8)|(PadArray[2]<<16)|(PadArray[3]<<24));
		//λֵָ
		temp_h =(uint32_t)((PadArray[4])|(PadArray[5]<<8)|(PadArray[6]<<16)|(PadArray[7]<<24));
		//ھԵַ(addr+i)ʵ˫д
		flash_write_DoubleWord((addr-front_offset),temp_l,temp_h);
		//ʣµд
		flash_write_physical(addr+(8-front_offset),N-(8-front_offset),(buf+(8-front_offset)));
	}
	
	//ȴд
	while( (FLASH->SR & FLASH_SR_BSY) != 0U);
	return 0;  //ɹִ
}

//======================================================================
//ƣflash_read_logic
//أ
//˵destݴŴַĿǴݣRAM
//       sectţΧȡʵоƬ STM32L433:0~127,ÿ2KB
//       offset:ڲƫƵַ0~2024ҪΪ0,4,8,12......
//       NֽĿ4~2048,ҪΪ4,8,12,......//
//ܸҪȡflash洢sect offsetʼNֽڣRAMdest
//=======================================================================
void flash_read_logic(uint8_t *dest,uint16_t sect,uint16_t offset,uint16_t N)
{
	uint8_t *src;
	src=(uint8_t *)(FLASH_BASE+sect*FLASH_PAGE_SIZE+offset);
	memcpy(dest,src,N);
}

//======================================================================
//ƣflash_read_physical
//أ
//˵destݴŴַĿǴݣRAM
//       addrĿַҪΪ4ı磺0x00000004
//       NֽĿ0~1020,ҪΪ48,12,......
//ܸҪȡflashַָ
//======================================================================
void flash_read_physical(uint8_t *dest,uint32_t addr,uint16_t N)
{
	uint8_t *src;
	src=(uint8_t *)addr;
	memcpy(dest,src,N);
}

//======================================================================
//ƣflash_protect
//أ
//˵Mֵʵʱ
//ܸҪflash
//======================================================================
void flash_protect(uint8_t M)
{
	uint32_t STRT,END;    //ľԵַSTRTʼַENDַ

	//ʼַ
    STRT = (uint32_t)(FLASH_PAGE_SIZE*M/0x8u);
    //ַ
    END = (uint32_t)(FLASH_PAGE_SIZE*(M+1)/0x8u);
    //ؼĴ
	FLASH->PCROP1SR |= STRT;
	FLASH->PCROP1ER |= END;
}

//======================================================================
//ƣflash_unprotect
//أ
//˵
//ܸҪflashⱣ
//˵        
//======================================================================
void flash_unprotect(uint8_t M)
{
	FLASH->PCROP1SR = 0xffffffff;
	FLASH->PCROP1ER = 0x08000000;
}



//========================================================================
//ƣflash_isempty
//أ1=ĿΪգ0=Ŀǿա
//˵Ҫ̽flashżֽ
//ܸҪflashпղ
//========================================================================
uint8_t flash_isempty(uint16_t sect,uint16_t N)
{
   uint16_t i,flag;
   uint8_t* buff;
   i = 0;
   flag = 1;
   for(i = 0; i<N; i++)   //ֽ
   {
	  buff=(uint8_t*)(sect*2048);
      if(buff[i]!=0xff)   //ǿ
      {
      	  flag=0;
          break;
       }
   }
   return flag;
}

//========================================================================
//ƣflashCtl_isSectorProtected
//أ1=0=δ
//˵Ҫ
//ܸҪжflashǷ񱻱
//=========================================================================
uint8_t flash_isSectorProtected(uint16_t sect)
{
return 1;
}

//----------------------ΪڲŴ----------------------------
//======================================================================
//ƣflash_write_DoubleWord
//أ0-ɹ 1-ʧ
//˵addrĿַҪΪ4ıҴFlash׵ַ
//              磺0x08000004Flash׵ַΪ0x08000000
//       dataд˫
//ܸҪFlash˫дSTM32L433ÿֻʵ˫д룬дλ֣дλ֣
//======================================================================
uint8_t flash_write_DoubleWord(uint32_t addr,uint32_t data_l,uint32_t data_h)
{
	//ݻ
	if((FLASH->ACR & FLASH_ACR_DCEN) != 0U)
	{
		FLASH->ACR &= ~FLASH_ACR_DCEN;
	}

	//ʹFlashʱ
    FLASH->CR |= FLASH_CR_PG;

    //дλ
    *(__IO uint32_t*)addr = data_l;

    //дλ
    *(__IO uint32_t*)(addr+4U) = data_h;

    //ֹFlashʱ
	FLASH->CR &= ~FLASH_CR_PG;

	return 0;    //سɹ
}
