//===========================================================================
//ļƣgpio.c
//ܸҪGPIOײԴļ
//ȨУSD-Arm(sumcu.suda.edu.cn)
//汾£20181201-20200221
//оƬͣSTM32
//===========================================================================

#include "gpio.h"

//GPIOڻַ볣GPIO_ARR[0]~GPIO_ARR[5]
GPIO_TypeDef * GPIO_ARR[] =
       {(GPIO_TypeDef *)GPIOA_BASE,(GPIO_TypeDef *)GPIOB_BASE,
		(GPIO_TypeDef *)GPIOC_BASE,(GPIO_TypeDef *)GPIOD_BASE,
		(GPIO_TypeDef *)GPIOE_BASE,(GPIO_TypeDef *)GPIOH_BASE};

//====չжIRQŶӦ====
IRQn_Type table_irq_exti[7] = {EXTI0_IRQn, EXTI1_IRQn, EXTI2_IRQn,
		EXTI3_IRQn, EXTI4_IRQn, EXTI9_5_IRQn, EXTI15_10_IRQn};

//ڲ
void gpio_get_port_pin(uint16_t port_pin,uint8_t* port,uint8_t* pin);

//=====================================================================
//ƣgpio_init
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//         dirŷ0=룬1=,ŷ궨壩
//         state˿ųʼ״̬0=͵ƽ1=ߵƽ
//ܸҪʼָ˿ΪGPIOŹܣΪ
//         ָʼ״̬ǵ͵ƽߵƽ
//=====================================================================
void gpio_init(uint16_t port_pin, uint8_t dir, uint8_t state)
{
	GPIO_TypeDef *gpio_ptr;    //gpio_ptrΪGPIOṹָ
	uint8_t port,pin;    //˿portpin
	uint32_t temp;       //ʱżĴֵ
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);
	//portֲgpio_ptrֵGPIOַ
	if(7 == port) //GPIOH
		gpio_ptr = GPIO_ARR[port-2];
	else
		gpio_ptr = GPIO_ARR[port];

	//ʹӦGPIOʱ
	RCC->AHB2ENR |= (RCC_AHB2ENR_GPIOAEN<<(port * 1u));

	//GPIOģʽĴӦλ
	temp = gpio_ptr->MODER;
	temp &= ~(GPIO_MODER_MODE0 << (pin * 2u));

	if(dir == 1)  //Ϊ
	{
		temp |= (GPIO_OUTPUT << (pin * 2u));
		gpio_ptr->MODER = temp;
		gpio_set(port_pin,state);    //gpio_set趨ųʼ״̬
	}
	else  //Ϊ
	{
		temp |= (GPIO_INPUT << (pin * 2u));
		gpio_ptr->MODER = temp;
	}
}

//=====================================================================
//ƣgpio_set
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//          stateϣõĶ˿״̬0=͵ƽ1=ߵƽ
//ܸҪָ˿űΪGPIOΪʱ趨״̬
//=====================================================================
void gpio_set(uint16_t port_pin, uint8_t state)
{
	//ֲ
	GPIO_TypeDef *gpio_ptr;    //port_ptrΪGPIOṹָ루׵ַ
	uint8_t port,pin;        //˿portpin
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);
	//portֲgpio_ptrֵGPIOַ
	if(7 == port) //GPIOH
		gpio_ptr = GPIO_ARR[port-2];
	else
		gpio_ptr = GPIO_ARR[port];

	//stateöӦ״̬
	if(1 == state)    //ߵƽ(ŶӦλĴ1)
		gpio_ptr->BSRR = (uint32_t)(1u<<pin);
	else              //͵ƽ(ŶӦüĴ1)
		gpio_ptr->BRR = (uint32_t)(1u<<pin);
}

//=====================================================================
//ƣgpio_get
//أָ˿ŵ״̬10
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱȡָ״̬
//=====================================================================
uint8_t gpio_get(uint16_t port_pin)
{
	//ֲ
	GPIO_TypeDef *gpio_ptr;    //port_ptrΪGPIOṹָ루׵ַ
	uint8_t port,pin;        //˿portpin
	uint32_t temp;
	uint8_t value;
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);
	//portֲgpio_ptrֵGPIOַ
	if(7 == port) //GPIOH
		gpio_ptr = GPIO_ARR[port-2];
	else
		gpio_ptr = GPIO_ARR[port];

	//״̬Ĵֵ
	temp = gpio_ptr->MODER;

	if( (temp & (2u<<(pin*2)))>>(pin*2) == 1u )//GPIO
	{
		//ȡOutput dataĴӦŵֵ
		temp = gpio_ptr->ODR;
		if((temp & (1u<<pin)) != 0x00u)
			value = 1;
		else
			value = 0;
	}
	else                                       //GPIO
	{
		//ȡInput dataĴӦŵֵ
		temp = gpio_ptr->IDR;
		if((temp & (1u<<pin)) != 0x00u)
			value = 1;
		else
			value = 0;
	}

	return value;
}

//=====================================================================
//ƣgpio_reverse
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱת״̬
//=====================================================================
void gpio_reverse(uint16_t port_pin)
{
	//ֲ
	GPIO_TypeDef *gpio_ptr;    //port_ptrΪGPIOṹָ루׵ַ
	uint8_t port,pin;        //˿portpin
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);
	//portֲgpio_ptrֵGPIOַ
	if(7 == port) //GPIOH
		gpio_ptr = GPIO_ARR[port-2];
	else
		gpio_ptr = GPIO_ARR[port];

    //ж״̬
	if ((gpio_ptr->ODR & (1u<<pin)) != 0x00u)
		//ߵƽתΪ͵ƽ
		gpio_ptr->BRR = (uint32_t)(1u<<pin);
	else
		//͵ƽתΪߵƽ
		gpio_ptr->BSRR = (uint32_t)(1u<<pin);
}

//=====================================================================
//ƣgpio_pull
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//       pullselect/PULL_DOWN=PULL_UP=
//ܸҪָ˿űΪGPIOΪʱ/
//=====================================================================
void gpio_pull(uint16_t port_pin, uint8_t pullselect)
{
	GPIO_TypeDef *gpio_ptr;    //gpio_ptrΪGPIOṹָ
	uint8_t port,pin;    //˿portpin
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);
	//portֲgpio_ptrֵGPIOַ
	if(7 == port) //GPIOH
		gpio_ptr = GPIO_ARR[port-2];
	else
		gpio_ptr = GPIO_ARR[port];

	//趨Ϊ״̬
	gpio_ptr->OSPEEDR |= (uint32_t)(HIGH_SPEED << (pin * 2u));

	if(1 == pullselect)
		//ߵƽ
		gpio_ptr->PUPDR |= (uint32_t)(PULL_UP << (pin * 2u));
	else
		//͵ƽ
		gpio_ptr->PUPDR |= (uint32_t)(PULL_DOWN << (pin * 2u));
}

//=====================================================================
//ƣgpio_enable_int
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//          irqtypeжͣɺ궨ٴо£
//                  RISING_EDGE  9      //ش
//                  FALLING_EDGE 10     //½ش
//                  DOUBLE_EDGE  11     //˫ش
//ܸҪָ˿űΪGPIOΪʱжϣ
//          жϴ
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//         KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//         KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
void gpio_enable_int(uint16_t port_pin,uint8_t irqtype)
{
	uint8_t port,pin;    //˿portpin
	uint32_t temp;       //ʱżĴֵ
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);

	//ʹSYSCFGʱ
	RCC->APB2ENR |= RCC_APB2ENR_SYSCFGEN;

	//öӦŵչж
	temp = SYSCFG->EXTICR[pin >> 2u];
	temp &= ~(0x0FuL << (4u * (pin & 0x03u)));
	temp |= (port << (4u * (pin & 0x03u)));
	SYSCFG->EXTICR[pin >> 2u] = temp;

	//Ӧչже
	EXTI->IMR1 |= (uint32_t)(1u<<pin);

	//ػ˫ش,ʹش
	if(RISING_EDGE == irqtype || DOUBLE_EDGE == irqtype)
		EXTI->RTSR1 |= (uint32_t)(1u<<pin);

	//½ػ˫ش,ʹ½ش
	if(FALLING_EDGE == irqtype || DOUBLE_EDGE == irqtype)
		EXTI->FTSR1 |= (uint32_t)(1u<<pin);

	if(pin >= 0 && pin <= 4)
		//жϿIRQж(EXTIx,x=0-4)
		NVIC_EnableIRQ(table_irq_exti[pin]);
	else if(pin >= 5 && pin <= 9)
		//жϿIRQж(EXTI9_5)
		NVIC_EnableIRQ(table_irq_exti[5]);
	else
		//жϿIRQж(EXTI15_10)
		NVIC_EnableIRQ(table_irq_exti[6]);
}

//=====================================================================
//ƣgpio_disable_int
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱرж
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//         KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//         KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
void gpio_disable_int(uint16_t port_pin)
{
	uint8_t port,pin;    //˿portpin
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);

	//ֹSYSCFGʱ
	RCC->APB2ENR &= ~RCC_APB2ENR_SYSCFGEN;

	//Ӧŵչж
	SYSCFG->EXTICR[pin >> 2u] &= ~(0x0FuL << (4u * (pin & 0x03u)));

	//ζӦչже
	EXTI->IMR1 &= (uint32_t)~(1u<<pin);

	//ֹ½ش
	EXTI->RTSR1 &= (uint32_t)~(1u<<pin);
	EXTI->FTSR1 &= (uint32_t)~(1u<<pin);

	if(pin >= 0 && pin <= 4)
		//жϿIRQж(EXTIx,x=0-4)
		NVIC_DisableIRQ(table_irq_exti[pin]);
	else if(pin >= 5 && pin <= 9)
		//жϿIRQж(EXTI9_5)
		NVIC_DisableIRQ(table_irq_exti[5]);
	else
		//жϿIRQж(EXTI15_10)
		NVIC_DisableIRQ(table_irq_exti[6]);

}

//=====================================================================
//ƣgpio_drive_strength
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//       controlŵLOW_SPEED=,MSDIUM_SPEED=
//               HIGH_SPEED=,VERY_HIGH_SPEED=
//ܸҪָĳһmAλ
//        5mA,18mAűΪʱ,
//        ŵ
//=====================================================================
void gpio_drive_strength(uint16_t port_pin, uint8_t control)
{
	GPIO_TypeDef *gpio_ptr;    //gpio_ptrΪGPIOṹָ
	uint8_t port,pin;    //˿portpin
//	uint32_t temp;       //ʱżĴֵ
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);
	//portֲgpio_ptrֵGPIOַ
	if(7 == port) //GPIOH
		gpio_ptr = GPIO_ARR[port-2];
	else
		gpio_ptr = GPIO_ARR[port];

	//ŵ
	gpio_ptr->OSPEEDR |= (uint32_t)(control << (pin * 2u));
}

//=====================================================================
//ƣgpio_get_int
//أGPIOжϱ־101ʾGPIOжϣ0ʾûGPIOжϡ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱ,ȡжϱ־
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//        KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//        KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
uint8_t gpio_get_int(uint16_t port_pin)
{
	uint8_t port,pin;    //˿portpin
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);

	//ȡGPIOжϱ־
	if((EXTI->PR1 & (1u << pin)) == (1u << pin))
		return 1;
	else
		return 0;
}

//=====================================================================
//ƣgpio_clear_int
//أ
//˵port_pin(˿ں)|(ź)磺(PTB_NUM)|(9) ʾΪB9Žţ
//ܸҪָ˿űΪGPIOΪʱ,жϱ־
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//         KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//         KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
void gpio_clear_int(uint16_t port_pin)
{
	uint8_t port,pin;    //˿portpin
	//ݴport_pin˿ŷֱ𸳸port,pin
	gpio_get_port_pin(port_pin,&port,&pin);

	//GPIOжϱ־
	EXTI->PR1 |= (1u << pin);
}

//=====================================================================
//ƣgpio_clear_allint
//أ
//˵
//ܸҪж˿ڵGPIOж
//ע          ⣺ KL25оƬֻPORTAPORTDھGPIOжϹ
//         KW01оƬֻPORTAPORTCPORTDھGPIOжϹ
//         KL36оƬֻPORTAPORTCPORTDھGPIOжϹ
//        STM32L433оƬPORTAPORTBPORTCPORTHھGPIOжϹ,EXIT(չ
//                     ж)ãֻش½ش˫شж
//=====================================================================
void gpio_clear_allint(void)
{
	EXTI->PR1 |= 0xFFFF;//pinȡ0-15
}


//----------------------ΪڲŴ-----------------
//=====================================================================
//ƣgpio_get_port_pin
//أ
//˵port_pin˿ں|źţ磺(PTB_NUM)|(9) ʾΪB9Žţ
//       port˿ںţָ
//       pin:źţ0~15ʵȡֵоƬžָ
//ܸҪport_pinнó˿ںźţֱֵportpin,ء
//       (PTB_NUM)|(9)ΪPORTB9ֱֵportpin
//=====================================================================
void gpio_get_port_pin(uint16_t port_pin,uint8_t* port,uint8_t* pin)
{
	*port = (port_pin>>8);
	*pin = port_pin;
}
