/*ļʹá//ע*/
/*
MSP432Ϣ
	 RAM:  0x20000000-0x20010000,64KB,
     Flash:0x00000000-0x00040000,256KB,
     Flash640-63ÿ4KB,
          ж:47
*/
 MCU_SECTORSIZE =4096;               /*FLASHС*/
 MCU_FLASH_ADDR_START = 0;           /*MSP342P401RFLASHʼַ*/
 GEC_USER_SECTOR_START  =26;         /* 26=USERʼţ0= */
 GEC_USER_SECTOR_END =63;            /*USER */
 GEC_USER_RAM_START =0x20002000;     /*USER RAMʼַ  */
 GEC_USER_RAM_END  =0x20010000;      /*USER RAMַ*/
 /* ڴʼַͳ */
MEMORY
{
	/*USERô*/
	USER_INTVEC(RX) : ORIGIN = MCU_FLASH_ADDR_START + MCU_SECTORSIZE * GEC_USER_SECTOR_START , LENGTH = MCU_SECTORSIZE
    MAIN_FLASH (RX) : ORIGIN = MCU_FLASH_ADDR_START + MCU_SECTORSIZE * (GEC_USER_SECTOR_START + 1) , LENGTH = MCU_SECTORSIZE * (GEC_USER_SECTOR_END - GEC_USER_SECTOR_START)
    /*USERRAMռ䡣*/
    SRAM_DATA  (RW) : ORIGIN = GEC_USER_RAM_START, LENGTH = GEC_USER_RAM_END - GEC_USER_RAM_START
}

/*Ĭɲ䶯*/
REGION_ALIAS("REGION_TEXT", MAIN_FLASH);
REGION_ALIAS("REGION_BSS", SRAM_DATA);
REGION_ALIAS("REGION_DATA", SRAM_DATA);
REGION_ALIAS("REGION_STACK", SRAM_DATA);
REGION_ALIAS("REGION_HEAP", SRAM_DATA);
REGION_ALIAS("REGION_ARM_EXIDX", MAIN_FLASH);
REGION_ALIAS("REGION_ARM_EXTAB", MAIN_FLASH);
REGION_ALIAS("REGION_API_INIT", MAIN_FLASH);

REGION_ALIAS("REGION_INTVEC_INIT", USER_INTVEC);

SECTIONS {

    /* section for the interrupt vector area                                 */
    PROVIDE (_intvecs_base_address =
        DEFINED(_intvecs_base_address) ? _intvecs_base_address : MCU_SECTORSIZE * GEC_USER_SECTOR_START );

    .intvecs (_intvecs_base_address) : AT (_intvecs_base_address) {
        KEEP (*(.intvecs))
    } > REGION_INTVEC_INIT

    /* The following three sections show the usage of the INFO flash memory  */
    /* INFO flash memory is intended to be used for the following            */
    /* device specific purposes:                                             */
    /* Flash mailbox for device security operations                          */
  
    PROVIDE (_vtable_base_address =
        DEFINED(_vtable_base_address) ? _vtable_base_address : GEC_USER_RAM_START);

    .vtable (_vtable_base_address) : AT (_vtable_base_address) {
        KEEP (*(.vtable))
    } > REGION_DATA


    .text : {
        CREATE_OBJECT_SYMBOLS
        KEEP (*(.text))
        *(.text.*)
        . = ALIGN(0x4);
        KEEP (*(.ctors))
        . = ALIGN(0x4);
        KEEP (*(.dtors))
        . = ALIGN(0x4);
        __init_array_start = .;
        KEEP (*(.init_array*))
        __init_array_end = .;
        *(.init)
        *(.fini*)
    } > REGION_TEXT AT> REGION_TEXT

    .rodata : {
        *(.rodata)
        *(.rodata.*)
    } > REGION_TEXT AT> REGION_TEXT

    .ARM.exidx : {
        __exidx_start = .;
        *(.ARM.exidx* .gnu.linkonce.armexidx.*)
        __exidx_end = .;
    } > REGION_ARM_EXIDX AT> REGION_ARM_EXIDX

    .ARM.extab : {
        *(.ARM.extab* .gnu.linkonce.armextab.*)
    } > REGION_ARM_EXTAB AT> REGION_ARM_EXTAB

    __etext = .;

    .data : {
        __data_load__ = LOADADDR (.data);
        __data_start__ = .;
        KEEP (*(.data))
        KEEP (*(.data*))
        . = ALIGN (4);
        __data_end__ = .;
    } > REGION_DATA AT> REGION_TEXT

    .bss : {
        __bss_start__ = .;
        *(.shbss)
        KEEP (*(.bss))
        *(.bss.*)
        *(COMMON)
        . = ALIGN (4);
        __bss_end__ = .;
    } > REGION_BSS AT> REGION_BSS

  .heap :
  {
    . = ALIGN(8);
    __end__ = .;
    PROVIDE(end = .);
    __HeapBase = .;
   /* . += HEAP_SIZE;*/
    __HeapLimit = .;
  } > REGION_HEAP AT> REGION_HEAP

  .stack :
  {
    . = ALIGN(8);
    /*. += STACK_SIZE;*/
  } > REGION_STACK AT> REGION_STACK

	
	__StackTop = ORIGIN(SRAM_DATA) + LENGTH(SRAM_DATA);
}

