//===========================================================================
//ļƣgpio.c
//ܸҪGPIOײԴļ
//ȨУݴѧǶʽ(sumcu.suda.edu.cn)
//¼¼2017-11-09  V1.0
//===========================================================================
#include "gpio.h"   //ͷļ

//˿ڻַ볣GPIO_ODD_ARRGPIO_EVEN_ARR ˿ڻַmsp432p401r.hļ
 const DIO_PORT_Odd_Interruptable_Type* GPIO_ODD_ARR[]={P1,P3,P5,P7,P9};
 const DIO_PORT_Even_Interruptable_Type* GPIO_EVEN_ARR[]={P2,P4,P6,P8,P10};

//----------------------ΪڲŴ-------------------------------------
//===========================================================================
//ƣgpio_port_pin_resolution
//أ
//˵port_pin˿ں|ź(PORT_2)|(0) ʾΪ20Žţ
//         port˿ں
//		   pin:źţ0~16ʵȡֵоƬž
//ܸҪport_pinнó˿ںź (PORT_2)|(0) ʾΪ20Žţ
//         ΪPORT_20ֱֵportpin
//===========================================================================
static void gpio_port_pin_resolution(uint16_t port_pin,uint8_t* port,uint8_t* pin)
{
	*port = (port_pin>>8);
	*pin = port_pin;
}
//----------------------------ڲ-------------------------------------
//===========================================================================
//ƣgpio_init
//أ
//˵port_pin(˿ں)|(ź)(PORT_2)|(0) ʾΪ20Žţ
//          dirŷ0=룬1=,ŷ궨壩
//          state˿ųʼ״̬0=͵ƽ1=ߵƽ
//ܸҪʼָ˿ΪGPIOŹܣΪ
//          ָʼ״̬ǵ͵ƽߵƽ
//===========================================================================
void gpio_init(uint16_t port_pin, uint8_t dir, uint8_t state)
{
	//ֲ
	DIO_PORT_Odd_Interruptable_Type* gpio_odd_ptr;
	DIO_PORT_Even_Interruptable_Type* gpio_even_ptr;
	DIO_PORT_Not_Interruptable_Type* gpio_not_ptr;
	memset((void *)&gpio_even_ptr,0,sizeof(gpio_even_ptr));
	uint8_t port;
	uint8_t pin;
	//˿ڻ
	gpio_port_pin_resolution(port_pin , &port , &pin);
	//жǷΪJ
	if(port >= 10)
	{
		gpio_not_ptr = PJ;
		//PxSEL0PxSEL1λΪ00ʱʾGPIO
		BCLR(pin,gpio_not_ptr->SEL0);
		BCLR(pin,gpio_not_ptr->SEL1);
		//ݴdirΪ
	    if (1 == dir)   //ϣΪ
		{
			 BSET(pin,gpio_not_ptr->DIR);
			 if(1==state)//ƽߵ
				 BSET(pin,gpio_even_ptr->OUT);
			 else
				 BCLR(pin,gpio_even_ptr->OUT);
		}
	    else           //ϣΪ
		{
			 BCLR(pin,gpio_not_ptr->DIR);
		}
	}
	//Ƿż˿
	else if(port%2 == 0) //ж϶˿ںgpio.hж1~10ıŴ0ʼ
	{
		gpio_odd_ptr = (DIO_PORT_Odd_Interruptable_Type*) GPIO_ODD_ARR[port/2];
		//PxSEL0PxSEL1λΪ00ʱʾGPIO
		BCLR(pin,gpio_odd_ptr->SEL0);
		BCLR(pin,gpio_odd_ptr->SEL1);
	    //ݴdirΪ
	    if (1 == dir)   //ϣΪ
	    {
	    	BSET(pin,gpio_odd_ptr->DIR);  //ĴΪ
			if(1==state)//ƽߵ
				BSET(pin,gpio_even_ptr->OUT);
			else
				BCLR(pin,gpio_even_ptr->OUT);
	    }
	    else           //ϣΪ
	    {
	    	BCLR(pin,gpio_odd_ptr->DIR);
	    }
	}
	//Ƿ˿
	else
	{
		gpio_even_ptr = (DIO_PORT_Even_Interruptable_Type*)(GPIO_EVEN_ARR[(port-1)/2]);
		//PxSEL0PxSEL1λΪ00ʱʾGPIO
		BCLR(pin,gpio_even_ptr->SEL0);
		BCLR(pin,gpio_even_ptr->SEL1);
	    //ݴdirΪ
	    if (1 == dir)           //ϣΪ
	    {
	    	BSET(pin,gpio_even_ptr->DIR);   //ĴΪ
			if(1==state)//ƽߵ
				BSET(pin,gpio_even_ptr->OUT);
			else
				BCLR(pin,gpio_even_ptr->OUT);
	    }
	    else                    //ϣΪ
	    {
	    	BCLR(pin,gpio_even_ptr->DIR);
	    }
	}
}

//===========================================================================
//ƣgpio_set
//أ
//˵port_pin˿ں|ź(PORT_2)|(0) ʾΪ20Žţ
//         stateųʼ״̬0=͵ƽ1=ߵƽ
//ܸҪ趨״̬Ϊ͵ƽߵƽ
//===========================================================================
void gpio_set(uint16_t port_pin, uint8_t state)
{
	//ֲ
	DIO_PORT_Odd_Interruptable_Type* gpio_odd_ptr;
	DIO_PORT_Even_Interruptable_Type* gpio_even_ptr;
	DIO_PORT_Not_Interruptable_Type* gpio_not_ptr;
	uint8_t port;
	uint8_t pin;

	gpio_port_pin_resolution(port_pin , &port , &pin);
	//жǷΪJ
	if(port >= 10)
	{
		gpio_not_ptr =PJ;
		//ݴstateΪ10
		if (1==state)
		{
			BSET(pin,gpio_not_ptr->OUT);
		}
			else
		{
			BCLR(pin,gpio_not_ptr->OUT);
		}
	}
	else if(port%2 == 0)
	{
		gpio_odd_ptr = (DIO_PORT_Odd_Interruptable_Type*) GPIO_ODD_ARR[port/2];
		//ݴstateΪ10
		if (1==state)
		{
			BSET(pin,gpio_odd_ptr->OUT);
		}
		else
		{
			BCLR(pin,gpio_odd_ptr->OUT);
		}
	}
	else
	{
		gpio_even_ptr =(DIO_PORT_Even_Interruptable_Type*) (GPIO_EVEN_ARR[(port-1)/2]);
		//ݴstateΪ10
		if (1==state)
		{
			BSET(pin,gpio_even_ptr->OUT);
		}
		else
		{
			BCLR(pin,gpio_even_ptr->OUT);
		}
	}

}

//===========================================================================
//ƣgpio_get
//أָŵ״̬10
//˵port_pin˿ں|ź(PORT_2)|(0) ʾΪ20Žţ
//ܸҪȡָŵ״̬10
//===========================================================================
uint8_t gpio_get(uint16_t port_pin)
{
	//ֲ
	DIO_PORT_Odd_Interruptable_Type* gpio_odd_ptr;
	DIO_PORT_Even_Interruptable_Type* gpio_even_ptr;
	DIO_PORT_Not_Interruptable_Type* gpio_not_ptr;
	uint8_t port;
	uint8_t pin;
	//˿ں
	gpio_port_pin_resolution(port_pin , &port , &pin);

	if(port >= 10)
	{
		gpio_not_ptr = (DIO_PORT_Not_Interruptable_Type*)PJ;
		//ŵ״̬
		if(BGET(pin,gpio_not_ptr->DIR))
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	else if(port%2 == 0)
	{
		gpio_odd_ptr = (DIO_PORT_Odd_Interruptable_Type*) (GPIO_ODD_ARR[port/2]);
		//ŵ״̬
		if(BGET(pin,gpio_odd_ptr->DIR))
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	else
	{
		gpio_even_ptr = (DIO_PORT_Even_Interruptable_Type*) (GPIO_EVEN_ARR[(port-1)/2]);
		//ŵ״̬
		if(BGET(pin,gpio_even_ptr->DIR))
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
}

//===========================================================================
//ƣgpio_reverse
//أ
//˵port_pin˿ں|ź  (PORT_2)|(0) ʾΪ20Žţ
//ܸҪתָ״̬
//===========================================================================
void gpio_reverse(uint16_t port_pin)
{
	//ֲ
	DIO_PORT_Odd_Interruptable_Type* gpio_odd_ptr;
	DIO_PORT_Even_Interruptable_Type* gpio_even_ptr;
	DIO_PORT_Not_Interruptable_Type* gpio_not_ptr;
	uint8_t port;
	uint8_t pin;
	gpio_port_pin_resolution(port_pin , &port , &pin);

	if(port >= 10)
	{
		gpio_not_ptr = (DIO_PORT_Not_Interruptable_Type*)PJ;
		if(BGET(pin,gpio_not_ptr->OUT))       //ȡǰƽߵ
		{
			BCLR(pin,gpio_not_ptr->OUT);      //͵ƽ
		}
		else
		{
			BSET(pin,gpio_not_ptr->OUT);      //ߵƽ
		}
	}
	else if(port%2 == 0)
	{
		gpio_odd_ptr =(DIO_PORT_Odd_Interruptable_Type*) (GPIO_ODD_ARR[port/2]);
		if(BGET(pin,gpio_odd_ptr->OUT))       //ȡǰƽߵ
		{
			BCLR(pin,gpio_odd_ptr->OUT);      //͵ƽ
		}
		else
		{
			BSET(pin,gpio_odd_ptr->OUT);      //ߵƽ
		}
	}
	else
	{
		gpio_even_ptr =(DIO_PORT_Even_Interruptable_Type*) (GPIO_EVEN_ARR[(port-1)/2]);
		if(BGET(pin,gpio_even_ptr->OUT))       //ȡǰƽߵ
		{
			BCLR(pin,gpio_even_ptr->OUT);      //͵ƽ
		}
		else
		{
			BSET(pin,gpio_even_ptr->OUT);      //ߵƽ
		}
	}
}

//===========================================================================
//ƣgpio_pull
//أ
//˵port_pin˿ں|ź (PORT_2)|(0) ʾΪ20Žţ
//         pullselectߵ͵ƽ 0=͵ƽ1=ߵƽ
//ܸҪʹָߵƽ͵ƽ
//===========================================================================
void gpio_pull(uint16_t port_pin, uint8_t pullselect)
{
	//ֲ
	DIO_PORT_Odd_Interruptable_Type* gpio_odd_ptr;
	DIO_PORT_Even_Interruptable_Type* gpio_even_ptr;
	DIO_PORT_Not_Interruptable_Type* gpio_not_ptr;
	uint8_t port;
	uint8_t pin;
	gpio_port_pin_resolution(port_pin , &port , &pin);

	if(port >= 10)
	{
		gpio_not_ptr = (DIO_PORT_Not_Interruptable_Type*)PJ;
		//ݴpullselect߻
		if (1==pullselect)
		{
			BSET(pin,gpio_not_ptr->REN);   //
		}
		else
		{
			BCLR(pin,gpio_not_ptr->REN);
		}
	}
	else if(port%2 == 0)
	{
		gpio_odd_ptr = (DIO_PORT_Odd_Interruptable_Type*) (GPIO_ODD_ARR[port/2]);
		//ݴpullselect߻
		if (1==pullselect)
		{
			BSET(pin,gpio_odd_ptr->REN);
		}
		else
		{
			BCLR(pin,gpio_odd_ptr->REN);
		}
	}
	else
	{
		gpio_even_ptr = (DIO_PORT_Even_Interruptable_Type*) (GPIO_EVEN_ARR[(port-1)/2]);
		//ݴpullselect߻
		if (1==pullselect)
		{
			BSET(pin,gpio_even_ptr->REN);
		}
		else
		{
			BCLR(pin,gpio_even_ptr->REN);
		}
	}
}

//===========================================================================
//ƣgpio_enable_int
//أ
//˵port_pin(˿ں)|(ź)(PORT_2)|(0) ʾΪ20Žţ
//          irqtypeжͣɺ궨ٴо£
//                  RISING_EDGE  0      //ش
//                  FALLING_EDGE 1     //½ش
//ܸҪָ˿űΪGPIOΪʱжϣ
//          жϴ
//ע          ⣺ MP432P401RоƬֻPORT1~PORT6ھGPIOжϹ
//
//===========================================================================
void gpio_enable_int(uint16_t port_pin,uint8_t irqtype)
{
	//ֲ
	DIO_PORT_Odd_Interruptable_Type* gpio_odd_ptr;
	DIO_PORT_Even_Interruptable_Type* gpio_even_ptr;
	uint8_t port;
	uint8_t pin;
	gpio_port_pin_resolution(port_pin , &port , &pin);

	if(port%2 == 0)
	{
		gpio_odd_ptr = (DIO_PORT_Odd_Interruptable_Type*) (GPIO_ODD_ARR[port/2]);
		BCLR(pin,gpio_odd_ptr->IFG);         //жϱ־
		if(irqtype == 1)
		{
			BSET(pin,gpio_odd_ptr->IES);	 //жϻ½ж
		}
		else
		{
			BCLR(pin,gpio_odd_ptr->IES);	 //жϻ½ж
		}
	    BSET(pin,gpio_odd_ptr->IE);          //ʹж
	}
	else
	{
		gpio_even_ptr = (DIO_PORT_Even_Interruptable_Type*) (GPIO_EVEN_ARR[(port-1)/2]);
		BCLR(pin,gpio_even_ptr->IFG);        //жϱ־
		if(irqtype == 1)
		{
			BSET(pin,gpio_even_ptr->IES);	 //жϻ½ж
		}
		else
		{
			BCLR(pin,gpio_even_ptr->IES);	 //жϻ½ж
		}
	    BSET(pin,gpio_even_ptr->IE);         //ʹж
	}

    switch(port)
    {
    case 0://PT1
    	NVIC_EnableIRQ((IRQn_Type)35);     //жϿIRQж
    	break;
    case 1://PT2
    	NVIC_EnableIRQ((IRQn_Type)36);     //жϿIRQж
    	break;
    case 2://PT3
    	NVIC_EnableIRQ((IRQn_Type)37);     //жϿIRQж
        break;
    case 3://PT4
    	NVIC_EnableIRQ((IRQn_Type)38);     //жϿIRQж
        break;
    case 4://PT5
    	NVIC_EnableIRQ((IRQn_Type)39);     //жϿIRQж
        break;
    case 5://PT6
    	NVIC_EnableIRQ((IRQn_Type)40);     //жϿIRQж
        break;
    default:;
    }
}

//===========================================================================
//ƣgpio_disable_int
//أ
//˵port_pin(˿ں)|(ź)(PORT_2)|(0) ʾΪ20Žţ
//ܸҪָ˿űΪGPIOΪʱرж
//ע          ⣺ MP432P401RоƬֻPORT1~PORT6ھGPIOжϹ
//
//===========================================================================
void gpio_disable_int(uint16_t port_pin)
{
	//ֲ
	DIO_PORT_Odd_Interruptable_Type* gpio_odd_ptr;
	DIO_PORT_Even_Interruptable_Type* gpio_even_ptr;
	uint8_t port;
	uint8_t pin;
	gpio_port_pin_resolution(port_pin , &port , &pin);

	if(port%2 == 0)
	{
		gpio_odd_ptr = (DIO_PORT_Odd_Interruptable_Type*) (GPIO_ODD_ARR[port/2]);
		 BCLR(pin,gpio_odd_ptr->IE);       //ж
	}
	else
	{
		gpio_even_ptr = (DIO_PORT_Even_Interruptable_Type*) (GPIO_EVEN_ARR[(port-1)/2]);
		 BCLR(pin,gpio_even_ptr->IE);     //ж
	}

    switch(port)
    {
        case 0://PT1
    	    NVIC_DisableIRQ((IRQn_Type)35);   //жϿIRQж
        	break;
        case 1://PT2
        	NVIC_DisableIRQ((IRQn_Type)36);   //жϿIRQж
        	break;
        case 2://PT3
        	NVIC_DisableIRQ((IRQn_Type)37);   //жϿIRQж
            break;
        case 3://PT4
        	NVIC_DisableIRQ((IRQn_Type)38);   //жϿIRQж
            break;
        case 4://PT5
        	NVIC_DisableIRQ((IRQn_Type)39);   //жϿIRQж
            break;
        case 5://PT6
        	NVIC_DisableIRQ((IRQn_Type)40);   //жϿIRQж
            break;
        default:;
     }
}

//===========================================================================
//ƣgpio_drive_strength
//أ
//˵port_pin(˿ں)|(ź)(PORT_2)|(0) ʾΪ20Žţ
//       controlŵűΪʱDSE=1DSE=0
//                
//ܸҪָĳһmAλ5mA,
//        18mA        űΪʱ,ŵãֻPTB0,PTB1,PTD6,
//        PTD7ͬʱи,ЩſֱLEDMOSFET볡Ч
//        ܣ磬úֻ4š
//===========================================================================
void gpio_drive_strength(uint16_t port_pin, uint8_t control)
{
	//ֲ
	DIO_PORT_Odd_Interruptable_Type* gpio_odd_ptr;
	DIO_PORT_Even_Interruptable_Type* gpio_even_ptr;
	DIO_PORT_Not_Interruptable_Type* gpio_not_ptr;
	uint8_t port;
	uint8_t pin;
	gpio_port_pin_resolution(port_pin , &port , &pin);

	//ݴportֲport_ptrֵ
	if(port >= 10)
	{
		gpio_not_ptr = (DIO_PORT_Not_Interruptable_Type*)PJ;
	    //ݴcontrolΪߵ
		BCLR(pin,gpio_not_ptr->DS);
		if (1 == control)
		    BSET(pin,gpio_not_ptr->DS);
		else
			BCLR(pin,gpio_not_ptr->DS);
	}
	else if(port%2 == 0)
	{
		gpio_odd_ptr = (DIO_PORT_Odd_Interruptable_Type*) (GPIO_ODD_ARR[port/2]);
	    //ݴcontrolΪߵ
		BCLR(pin,gpio_odd_ptr->DS);
		if (1 == control)
		    BSET(pin,gpio_odd_ptr->DS);
		else
			BCLR(pin,gpio_odd_ptr->DS);
	}
	else
	{
		gpio_even_ptr = (DIO_PORT_Even_Interruptable_Type*) (GPIO_EVEN_ARR[(port-1)/2]);
	    //ݴcontrolΪߵ
		BCLR(pin,gpio_even_ptr->DS);
		if (1 == control)
		    BSET(pin,gpio_even_ptr->DS);
		else
			BCLR(pin,gpio_even_ptr->DS);
	}
}
