//=====================================================================
//ļƣpwm.h
//ܸҪpwmײԴļ
//ȨУݴѧ˼Ƕʽ(sumcu.suda.edu.cn)
//¼¼2013-03-12   V1.2
//         2015-01-21   V3.0  2019-02-25   V4.0
//=====================================================================
#include "pwm.h"
//ʱģ0,1,2,3ַӳ
static const Timer_A_Type* Timer_A_ARR[] = {TIMER_A0, TIMER_A1,TIMER_A2,TIMER_A3};
//====崮IRQŶӦ====
//˿ڻַ볣GPIO_ODD_ARRGPIO_EVEN_ARR ˿ڻַmsp432p401r.hļ
static const DIO_PORT_Odd_Interruptable_Type* GPIO_ODD_ARR[]={P1,P3,P5,P7,P9};
static const DIO_PORT_Even_Interruptable_Type* GPIO_EVEN_ARR[]={P2,P4,P6,P8,P10};

//*****************************ڲ******************************
void tpm_mux_val(uint16_t capNo,uint8_t* TPM_i,uint8_t* chl,uint8_t* mux);

//*****************************ӿں******************************
//=====================================================================
//ƣ  pwm_init
//ܸҪ  pwmʼ
//˵  pwmNopwmģţgec.hĺ궨PWM_PIN0ʾPWM0ͨ
//          clockFreʱƵʣλKhzȡֵ375750150030006000
//                                                         12000
//          periodڣλΪΧΪ1~65536
//          dutyռձȣ0.0~100.0Ӧ0%~100%
//          align뷽ʽ ͷļ궨PWM_EDGEΪض䡣
//          polԣͷļ궨PWM_PLUSΪ
//أ  
//ע⣺ ΪGECиĶͬģģֻͨͬΪֹʹö
//      PWMʱƵʴ۸ģҪʹʹõPWMclockFreperiodһ¡
//     ռձȣָߵƽһռʱ
//=====================================================================
void pwm_init(uint16_t pwmNo,uint32_t clockFre,uint16_t period,float duty,
		                                        uint8_t align,uint8_t pol)
{
	//עıCCR[0]еֵԸıPWMڣıCCR[N]ֵԸıPWMռձ
	//ʼ趨ʱƵΪ3MHzռձΪ25%ʱжʱ10ms,ʹTIMER_A1ģ飬1ͨģʽѡOUTMODE7
	uint8_t port,pin;                          //Ķ˿ڡźʱ
	uint8_t timer_ax,chy,mux;                  //tpmx_Chytpmģšͨʱֵ
	Timer_A_Type* timera;                     //ʱģ
	GPIO_MemMapPtr pwm_port;                  //pwm_portΪGPIO_MemMapPtrṹָ

	uint8_t clk_hdiv,clk_ldiv;
	uint8_t clk_div;
	uint16_t temp;

	//1.ȡŸֵýtpmģźͨ
	tpm_mux_val(pwmNo,&timer_ax,&chy,&mux);
	//2.gpioŽ
	port=((pwmNo>>8)&0x00FF);
	pin=(pwmNo&0xFF);

	if((port+1)%2==0)    //ż˿
		pwm_port=(DIO_PORT_Interruptable_Type*)GPIO_EVEN_ARR[((port+1)/2)-1];
	else
		pwm_port=(DIO_PORT_Interruptable_Type*)GPIO_ODD_ARR[(port+1)/2];
	pwm_port->DIR|=1<<pin;
	switch(mux)
	{
		case 0:pwm_port->SEL1&=~(1<<pin);pwm_port->SEL0&=~(1<<pin);break;
		case 1:pwm_port->SEL1&=~(1<<pin);pwm_port->SEL0|=(1<<pin);break;
		case 2:pwm_port->SEL1|= (1<<pin);pwm_port->SEL0&=~(1<<pin);break;
		case 3:pwm_port->SEL1|= (1<<pin);pwm_port->SEL0|= (1<<pin);break;
	}
	timera=(Timer_A_Type*)Timer_A_ARR[timer_ax];
	timera->CTL = TIMER_A_CTL_CLR;

    //ʱԴѡ,Ĵ,Ƶ8*8
	timera->CTL|=TIMER_A_CTL_TASSEL_2;
	clk_hdiv = 0;
	clk_ldiv = 0;
	clk_div = 12000 / clockFre;
	while(clk_div > 8)
	{
		clk_hdiv++;
		clk_div /= 2;
	}
	clk_ldiv = clk_div;
	timera->CTL|=(clk_hdiv << TIMER_A_CTL_ID_OFS);
	timera->EX0|=clk_ldiv-1 ;
	//öʱֵ=ʱƵ*жϼʱ
	if(align == PWM_EDGE)
	{
		timera->CCR[0]=period - 1;
		switch(pol)
		{
			case PWM_MINUS:
				timera->CCR[chy]=(uint32_t)(period*(duty/100.0));//ʼռձ
				timera->CCTL[chy]|=TIMER_A_CCTLN_OUTMOD_7;//ģʽ7
				break;
			case PWM_PLUS:
				timera->CCR[chy]=(uint32_t)(period*((100-duty)/100.0));//ʼռձ
				timera->CCTL[chy]|=TIMER_A_CCTLN_OUTMOD_3;//ģʽ3
				break;
		}
		timera->CTL|=TIMER_A_CTL_MC__UP;
	}
	else
	{

		timera->CCR[0]=period / 2;
		switch(pol)
		{
			case PWM_PLUS:
				timera->CCR[chy]=(uint32_t)((period / 2)*(duty/100.0));//ʼռձ
				timera->CCTL[chy]|=TIMER_A_CCTLN_OUTMOD_7;//ģʽ7
				break;
			case PWM_MINUS:
				timera->CCR[chy]=(uint32_t)((period / 2)*((100-duty)/100.0));//ʼռձ
				timera->CCTL[chy]|=TIMER_A_CCTLN_OUTMOD_3;//ģʽ3
				break;
		}
		timera->CTL|=TIMER_A_CTL_MC__UPDOWN;
	}
}

//=====================================================================
//ƣ  pwm_update
//ܸҪ  tpmxģChyͨPWM
//˵  pwmNopwmģţgec.hĺ궨PWM_PIN0ʾPWM0ͨ
//          dutyռձȣ0.0~100.0Ӧ0%~100%
//أ  
//=====================================================================
void pwm_update(uint16_t pwmNo,float duty)
{
    uint8_t TPM_i,chl,mux;  //tpmx_Chytpmģšͨʱ
    uint8_t temp;
    uint32_t period;
    Timer_A_Type* timer_ptr;
    // ֹԽ
    if(duty>100.0)  duty=100.0;
    //1. ȡŸֵýtpmģźͨ
    tpm_mux_val(pwmNo,&TPM_i,&chl,&mux);
    timer_ptr = (Timer_A_Type*)Timer_A_ARR[TPM_i];
    period=timer_ptr->CCR[0] + 1;
    temp = timer_ptr->CCTL[chl] & TIMER_A_CCTLN_OUTMOD_MASK;
    if(temp == TIMER_A_CCTLN_OUTMOD_7)
    {
    	 timer_ptr->CCR[chl]=(uint32_t)(period*duty/100);
    }
    else if(temp == TIMER_A_CCTLN_OUTMOD_3)
    {
    	timer_ptr->CCR[chl]=(uint32_t)(period*(100 - duty)/100);
    }
}

//------Ϊڲ------
//=====================================================================
//ƣtpm_mux_val
//ܸҪpwmNoнóģͨţPWM_PIN0
//         PORTţŷmux_val
//˵pwmNopwmģţͷļĺ궨PWM_PIN0ʾPWM0ͨ
//
//أ
//=====================================================================
void tpm_mux_val(uint16_t pwmNo,uint8_t* TPM_i,uint8_t* chl,uint8_t* mux)
{
    //1.ģźͨ
    switch(pwmNo)
    {
		case ((6<<8)|(7)):*TPM_i=1;*chl=1;*mux=1;break;
		case ((6<<8)|(6)):*TPM_i=1;*chl=2;*mux=1;break;
		case ((6<<8)|(5)):*TPM_i=1;*chl=3;*mux=1;break;
		case ((6<<8)|(4)):*TPM_i=1;*chl=4;*mux=1;break;

		case ((4<<8)|(6)):*TPM_i=2;*chl=1;*mux=1;break;
		case ((4<<8)|(7)):*TPM_i=2;*chl=2;*mux=1;break;

//		case ((5<<8)|(6)):*TPM_i=2;*chl=3;*mux=0;break;
//		case ((5<<8)|(7)):*TPM_i=2;*chl=4;*mux=0;break;
		default:break;
    }
}
