//==========================================================================
//ļƣtimer_32.c
//ܸҪtimer_32ײԴļ
//ȨУݴѧǶʽ(sumcu.suda.edu.cn)
//¼¼2017-11-10 V1.0
//==========================================================================
#include <timer.h>
//=====ڵַӳ====
static const Timer32_Type* Timer32_ARR[]={TIMER32_1,TIMER32_2};
//====崮IRQŶӦ====
static const IRQn_Type table_irq_uart[]={T32_INT1_IRQn,T32_INT2_IRQn};

//*****************************************************************************
//ڲ
uint32_t getPeriod(uint32_t PeriodicalTimes);

//==========================================================================
//ƣtimer32_init
//TimerNOʱģţTimer32_1 Timer32_2
//		 PeriodicalTimes жڣ   Χ0~1398ms
//		 TimerModeʱģʽ Free_Running_ModePeriodical_Mode
//أ
//ܸҪTimer32ʼʱԴĬΪ12MHzSMCLKԤƵ256
//==========================================================================
void timer_init(uint8_t TimerNO,uint32_t PeriodicalTimes)
{
	Timer32_Type* timer32;
	uint8_t TimerMode=Periodical_Mode;
	//TimerNO ModeNOԽ
	if(TimerNO>1||TimerMode>1)
		return;

	//PeriodicalTimesԽ磬Ϊ1000ʱʱΪ1S
//	if(PeriodicalTimes>=1398)
//		PeriodicalTimes=1000;

	timer32=(Timer32_Type*)Timer32_ARR[TimerNO];//timer32ȡģַ

    //ʱ
    //CS->KEY= 0x695A;                          //CSģ飬ע
//    CS->CTL0|= CS_CTL0_DCORSEL_3;            //DCOΪ12MHzֵ8-16MHzΧģ
//    CS->CTL1|= CS_CTL1_SELA_2 | CS_CTL1_SELS_3 | CS_CTL1_SELM_3;//ѡ ACLK = REFO, SMCLK = MCLK = DCO
    //CS->CTL1|=CS_CTL1_DIVS_2;
	//CS->KEY= 0;                             //CSģԱķ

	timer32->CONTROL=0;//CONTROLĴ

	//ʱģʽѡ
	switch(TimerMode)
	{
		case Free_Running_Mode:timer32->CONTROL&=~(TIMER32_CONTROL_MODE);break;//ѡģʽ
		case Periodical_Mode  :timer32->CONTROL|=TIMER32_CONTROL_MODE;break;   //ѡڼģʽ
	}

	timer32->CONTROL |= TIMER32_CONTROL_PRESCALE_0 | TIMER32_CONTROL_SIZE;//256Ƶ  32λ
	timer32->LOAD = getPeriod(PeriodicalTimes);      //ΪPeriodicalTimes/1000
	timer32->CONTROL |= TIMER32_CONTROL_IE;			 //ʹtimer32ж
	timer32->CONTROL |= TIMER32_CONTROL_ENABLE;		//ʹܼʱ

}



//=========================================================================
//ƣtimer32_enable_int
//ܸҪʹtimer32ģжϡ
//˵TimerNOʱģţTimer32_1 Timer32_2
//أ
//=========================================================================
void timer_enable_int(uint8_t TimerNO)
{
	//TimerNOԽ
	if(TimerNO>1)
		return;
	NVIC_EnableIRQ(table_irq_uart[TimerNO]);//NVICģʹtimer32ж
}



//=========================================================================
//ƣtimer32_disable_int
//ܸҪֹtimer32ģжϡ
//˵TimerNOʱģţTimer32_1 Timer32_2
//أ
//=========================================================================
void timer_disable_int(uint8_t TimerNO)
{
	//TimerNOԽ
	if(TimerNO>1)
		return;
	NVIC_DisableIRQ(table_irq_uart[TimerNO]);//NVICģнtimer32ж
}




//=========================================================================
//ƣtimer32_stop
//ܸҪֹtimer32ģ顣
//˵TimerNOʱģţTimer32_1 Timer32_2
//أ
//=========================================================================
void timer_stop(uint8_t TimerNO)
{
	Timer32_Type* timer32;
	//TimerNOԽ
	if(TimerNO>1)
		return;
	timer32=(Timer32_Type*)Timer32_ARR[TimerNO];//timer32ȡģַ
	timer32->CONTROL &= ~(TIMER32_CONTROL_IE);			//timer32ж
	timer32->CONTROL &= ~(TIMER32_CONTROL_ENABLE);		//üʱ
	NVIC_DisableIRQ(table_irq_uart[TimerNO]);//NVICģнtimer32ж
}



//==========================================================================
//ƣgetPeriod
//PeriodicalTimes ж 0~1398
//أLoad Ĵеֵ
//ܸҪPeriodicalTimesֵõLoadֵ
//==========================================================================
uint32_t getPeriod(uint32_t PeriodicalTimes)
{
	return PeriodicalTimes*48000;//ؼĸLOADĴֵ
}

//============================================================================
//ƣtimer_clear_int
//أ
//˵ timer_No:ʱģ  ʱģżgec.hļ
//ܸҪʱжϱ־
//============================================================================
void timer_clear_int(uint8_t timer_No)
{
    if(timer_No==0)
    	TIMER32_1->INTCLR = 0x1;
    else
    	TIMER32_2->INTCLR = 0x1;
    return;
}


