//======================================================================
//文件名称：user.h（用户程序头文件）
//制作单位：苏大arm技术中心(sumcu.suda.edu.cn)
//版本更新：V0.1 2019.1.23 刘强
//概要说明：本文件用于GEC用户在使用GEC进行硬件板设计时的引脚定义，GEC引脚具有的功能在gec.h文件中
//======================================================================

#ifndef USER_H   //防止重复定义（开始）
#define USER_H

//（1）【固定】文件包含
#include "printf.h"
#include "gpio.h"
#include "flash.h"
#include "emuart.h"
#include "gec.h"
//（2）【变动】指示灯端口及引脚定义—根据实际使用的引脚改动
//指示灯端口及引脚定义
#define  LIGHT_RED    (PT2|0)  //红色RUN灯 所在引脚
#define  LIGHT_GREEN  (PT2|1)  //绿色RUN灯 所在引脚
#define  LIGHT_BLUE   (PT2|2)  //蓝色RUN灯 所在引脚

//灯状态宏定义（灯亮、灯暗对应的物理电平由硬件接法决定）
#define  LIGHT_ON       1    //灯亮
#define  LIGHT_OFF      0    //灯暗

//（3）【变动】UART可用模块定义
#define UART_User      UART_3  //未被引出，需要使用杜邦线连接MSP432开发板的9.6和9.7
#define UART_UPDATE    UART_0  //用于程序更新，无法被使用

//（4）【变动】中断服务函数宏定义
#define UART_User_Handler       EUSCIA3_IRQHandler   //用户串口中断函数

#endif//防止重复定义（结尾）
