//================================================================
// 文件名称：lcd.c
// 功能概要：lcd构件头文件
//================================================================
#include "lcd.h"

//lcd控制位和数据位端口及引脚号
static uint16_t LCD[11]=
{
    LCD_RS,LCD_RW,LCD_E,
    LCD_D0,LCD_D1,LCD_D2,LCD_D3,LCD_D4,LCD_D5,LCD_D6,LCD_D7,
};

//内部函数原型说明
static void LCDCommand(uint8_t cmd);

//================================================================
//函数名称：LCDInit
//函数返回：无
//参数说明：无
//功能概要：LCD初始化。
//================================================================
void LCDInit()
{
    uint32_t i = 0;
    //定义数据口和控制口为输出   
    for(i = 0;i < 11;i++)
    {
        gpio_init(LCD[i], 1,0);
    }
    //设置指令,RS,R/W = 00, 写指令代码 
    gpio_set (LCD[0], 0);
    gpio_set (LCD[1], 0);
    
    //功能设置- 
    //设置指令
    LCDCommand(0x38);       //5*7点阵模式,2行显示,8位数据总线
    LCDCommand(0x08);       //关显示,关光标显示,不闪烁
    LCDCommand(0x01);       //清屏
    for (i=0; i<40000; i++);//asm("NOP"); //延时
    LCDCommand(0x06);
    LCDCommand(0x14);       //光标右移一个字符位,AC自动加1
    LCDCommand(0x0C);       //开显示,关光标显示,不闪烁 
}

//================================================================
//函数名称：LCDShow
//函数返回：无
//参数说明：需要显示的数据 
//功能概要：通过液晶显示data中的32字节数据。
//================================================================
void LCDShow(uint8_t data[32])
{
    uint8_t i;
    //LCD初始化 
    LCDInit();
    
    //显示第1行16个字符 
    gpio_set (LCD[0], 0);
    gpio_set (LCD[1], 0);
    //后7位为DD RAM地址(0x00)
    LCDCommand(0x80);
    
    //写16个数据到DD RAM
    gpio_set (LCD[0], 1);
    gpio_set (LCD[1], 0);
    //将要显示在第1行上的16个数据逐个写入DD RAM中 
    for (i = 0;i < 16;i++)
    {
        LCDCommand(data[i]);
    }
    
    //显示第2行16个字符 
    gpio_set (LCD[0], 0);
    gpio_set (LCD[1], 0);
    //后7位为DD RAM地址(0x40)
    LCDCommand(0xC0);
    
    gpio_set (LCD[0], 1);
    gpio_set (LCD[1], 0);
    
    //将要显示在第2行上的16个数据逐个写入DD RAM中 
    for (i = 16;i < 32;i++)
    {
        LCDCommand(data[i]);
    }
}

//----------------------以下为内部函数存放处------------------------
//================================================================
//函数名称：LCDCommand
//函数返回：无
//参数说明：cmd:待执行的命令
//功能概要：执行给定的cmd命令,且延时。
//================================================================
void LCDCommand(uint8_t cmd)
{
    uint8_t i;
    uint16_t j;
    uint8_t temp;
    //等待延迟防止重复调用此函数而LCD卡死
    for (j=0; j<1600; j++);//asm("NOP");
    //数据送到LCD的数据线上
    for(i = 3;i < 11;i++)
    {
        gpio_set (LCD[i], 0);
    }
    for(i = 3;i < 11;i++)
    {
        temp = 0x01 & (cmd>>(i-3));
        gpio_set (LCD[i], temp);
    }
    //给出E信号的下降沿(先高后低),使数据写入LCD
    gpio_set (LCD[2], 1);
    for (j=0;j<25;j++) ;//asm("NOP");
    gpio_set (LCD[2], 0);
}
//----------------------------内部函数结束----------------------

