#ifndef _CPU_H_
#define _CPU_H_

#include "cmsis_gcc.h"       //ںͷļ
#include "core_cm4.h"
#include "core_cmFunc.h"
#include "core_cmInstr.h"
#include "core_cmSimd.h"

//2䶯λ
// λ
#define IS_PIN_RESET_OCCURED       (RSTCTL->PINRESET_STAT)

// ϵ縴λ                                
#define IS_POWERON_RESET          (RSTCTL->PCMRESET_STAT)

//д1ϵ縴λ־λ 
#define CLEAR_POWER_RESET_FLAG      (RSTCTL->PCMRESET_CLR|=1)

//д1Ÿλ־λ 
#define CLEAR_PIN_RESET_FLAG      (RSTCTL->PINRESET_CLR|=1)

//3̶жϺ궨,ARMܹ򲻱䶯
#define ENABLE_INTERRUPTS        __ASM("cpsie i")     // ж()
#define DISABLE_INTERRUPTS       __ASM("cpsid i")     // ж()

//4̶Żͱ궨
typedef volatile uint8_t      vuint8_t;   // Ż޷8λֽ
typedef volatile uint16_t     vuint16_t;  // Ż޷16λ
typedef volatile uint32_t     vuint32_t;  // Ż޷32λ

//5̶λ꺯λλüĴһλ״̬
#define BSET(bit,Register)  ((Register)|= (1<<(bit)))    //üĴһλ
#define BCLR(bit,Register)  ((Register) &= ~(1<<(bit)))  //Ĵһλ
#define BGET(bit,Register)  (((Register) >> (bit)) & 1)  //üĴһλ״̬

#endif //ֹظ壨CPU_H β
