//======================================================================
//ļƣuart.c
//ܸҪuartײԴļ
//ȨУݴѧ˼Ƕʽ(sumcu.suda.edu.cn)
//¼¼2017-11-01 V1.0
//======================================================================
#include "uart.h"


//=====ڵַӳ====
static const EUSCI_A_Type* UART_ARR[4] = {(EUSCI_A_Type*)EUSCI_A0_BASE,(EUSCI_A_Type*) EUSCI_A1_BASE,(EUSCI_A_Type*)EUSCI_A2_BASE,(EUSCI_A_Type*)EUSCI_A3_BASE};
//====崮IRQŶӦ====
static const IRQn_Type table_irq_uart[4] = {EUSCIA0_IRQn, EUSCIA1_IRQn, EUSCIA2_IRQn,EUSCIA3_IRQn};
//=====1.0*fBRCLK/(16*baud_rate)Сֵпȡֵ*1000ļ=====
uint16_t BRSxS[]={ 0, 52, 71, 83,100,125,143,167,214,
		         222,250,300,333,357,375,400,428,437,
				 500,571,600,625,643,666,700,714,750,
				 786,800,833,846,857,875,900,917,928} ;

//=====1.0*fBRCLK/(16*baud_rate)СֶӦUCBRFxֵӳֵ=====
uint8_t ValBRSxS[]={0x00,0x01,0x02,0x04,0X08,0x10,0x20,0x11,0x21,
                    0x22,0x44,0x25,0x49,0x4A,0x52,0x92,0x53,0x55,
                    0xAA,0x6B,0XAD,0XB5,0XB6,0XD6,0XB7,0XBB,0XDD,
                    0XED,0XEE,0XBF,0XDF,0XEF,0XF7,0XFB,0XFD,0XFE} ;
//*****************************************************************************
//ڲ
uint8_t uart_is_uartNo(uint8_t uartNo);
uint8_t BRSxSel(double fra);

//======================================================================
//ƣuart_init
//ܸҪʼuartģ
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//          baud:ʣ300600120024004800960019200115200...
//أ
//======================================================================
void uart_init(uint8_t uartNo, uint32_t baud_rate)
{
	//ֲ
	double sbr,fraction;
	uint32_t abr,brfx;
	EUSCI_A_Type* uartch;//uartchΪUARTMemMapPtrָ

	//жϴ봮ںŲǷֱ˳
    if(!uart_is_uartNo(uartNo))
    {
    	return ;
    }
    uartch=(EUSCI_A_Type*)UART_ARR[uartNo];//ݴuartNoֲuartchֵ

    //ʱ
    CS->KEY= 0x695A;                          //CSģ飬ע




//    CS->CTL0|= CS_CTL0_DCORSEL_3;            //DCOΪ12MHzֵ8-16MHzΧģ
//    CS->CTL1|= CS_CTL1_SELA_2 | CS_CTL1_SELS_3 | CS_CTL1_SELM_3;//ѡ ACLK = REFO, SMCLK = MCLK = DCO

    //
    CS->CTL1|=CS_CTL1_DIVS_2;



    CS->KEY= 0;                             //CSģԱķ

	//ѡUARTxĶӦ
    switch(uartNo)
    {
    	case UART_0: P1SEL0|=BIT2 | BIT3; P1SEL1&=(~BIT2)&(~BIT3);break;  //P1.2 ŹΪRX,P1.3ŹΪTX
    	case UART_1: P2SEL0|=BIT2 | BIT3; P2SEL1&=(~BIT2)&(~BIT3);break;
    	case UART_2: P3SEL0|=BIT2 | BIT3; P3SEL1&=(~BIT2)&(~BIT3);break;
    	case UART_3: P9SEL0|=BIT6 | BIT7; P9SEL1&=(~BIT6)&(~BIT7);break;
    }


    // UART
    uartch->CTLW0|= UCSWRST;                   //ʹλ
    uartch->CTLW0|= UCSSEL__SMCLK;             //BRCLKԴʱѡSMCLK

    //baud_rateؼ
    sbr=1.0*12000000/(16*baud_rate);							//sbr
    fraction=sbr-(uint16_t)sbr;								//sbrС
    abr=(uint16_t)sbr;										//sbr
    brfx=(uint16_t)(fraction*16);							//UCBRFxֵ

    uartch->BRW=abr;							//ָBRW
    uartch->MCTLW=(BRSxSel(fraction)<<UCBRS_OFS)|(brfx<<UCBRF_OFS)|(UCOS16<<UCOS16_OFS);//ģʽʹܣεƽ׶ѡżУѡ
    uartch->CTLW0&= ~UCSWRST;                   //λ
    uartch->IE&=~UCTXIE;//ôڷж
    NVIC_EnableIRQ(table_irq_uart[uartNo]);//NVICģʹEUSCIAж
}
//======================================================================
//ƣuart_send1
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//          ch:Ҫ͵ֽ
//أִ״̬1=ͳɹ0=ʧܡ
//ܸҪз1ֽ
//======================================================================
uint8_t uart_send1(uint8_t uartNo, uint8_t ch)
{
	uint32_t t;
    EUSCI_A_Type* uartch; //uartchΪEUSCI_A_Type*ָ

    //жϴ봮ںŲǷֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		return 0;
	}
	uartch=(EUSCI_A_Type*)UART_ARR[uartNo];//ȡUARTxַ

	 for (t = 0; t < 0xFBBB; t++)//ѯָ
	{
	 //ͻΪ
	 if(uartch->IFG&UCTXIFG)
	 {
		 uartch->TXBUF= ch;//chֵ뷢ͻ
		 break;
	 }
	}
	 //ж
	 if (t >= 0xFBBB)
		 return 0; //ͳʱʧ
	 else
		 return 1; //ɹ
}

//======================================================================
//ƣuart_sendN
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//         buff: ͻ
//         len:ͳ
//أ ִ״̬1=ͳɹ0=ʧ
//ܸҪ nֽ
//======================================================================
uint8_t uart_sendN(uint8_t uartNo ,uint16_t len ,uint8_t* buff)
{
    uint16_t i;

    //жϴ봮ںŲǷֱ˳
    if(!uart_is_uartNo(uartNo))
    {
        return 0;
    }

    for (i = 0; i < len; i++)
    {
        if (!uart_send1(uartNo, buff[i])) //һֽݣʧѭ
        {
            break;
        }
    }
    if(i<len)
        return 0;    //ͳ
    else
        return 1;    //ͳ
}

//======================================================================
//ƣuart_send_string
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//          buff:Ҫ͵ַ׵ַ
//أ ִ״̬1=ͳɹ0=ʧ
//ܸҪָUART˿ڷһ'\0'ַ
//======================================================================
uint8_t uart_send_string(uint8_t uartNo, void *buff)
{
    uint16_t i = 0;
    uint8_t *buff_ptr = (uint8_t *)buff;     //ָָҪַ׵ַ

    //жϴ봮ںŲǷֱ˳
    if(!uart_is_uartNo(uartNo))
    {
        return 0;
    }

    for(i = 0; buff_ptr[i] != '\0'; i++)   //ַַ
    {
        if (!uart_send1(uartNo,buff_ptr[i]))//ָӦַ
            return 0;  //ʧ,
    }
    return 1;          //ͳɹ
}

//======================================================================
//ƣuart_re1
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//        *fp:ճɹ־ָ:*fp=1:ճɹ*fp=0:ʧ
//أշֽ
//ܸҪн1ֽ
//======================================================================
uint8_t uart_re1(uint8_t uartNo,uint8_t *fp)
{
    uint32_t t;
    uint8_t  dat;			  //ڽշͻ
    EUSCI_A_Type* uartch;    //uartchΪEUSCI_A_Type*ָ
	//жϴ봮ںŲǷֱ˳
	if(!uart_is_uartNo(uartNo))
	{
		 *fp=0;
		 return 0;
	}
	uartch=(EUSCI_A_Type*)UART_ARR[uartNo];

	for (t = 0; t < 0xFBBB; t++)//ѯָ
	{
		//жϽջǷ
		if(uartch->IFG & UCRXIFG)
		{
			dat=uartch->RXBUF;//ȡ,жλ
			*fp=1;//ճɹ
			break;
		}
	}
	//ж
	if(t >= 0xFBBB)
	{
		 dat = 0xFF;
		 *fp = 0;    //δյ
	}

    return dat;    //ؽյ
}

//======================================================================
//ƣuart_reN
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//          buff: ջ
//          len:ճ
//أִ״̬ 1=ճɹ;0=ʧ
//ܸҪ nֽ,buff
//======================================================================
uint8_t uart_reN(uint8_t uartNo ,uint16_t len ,uint8_t* buff)
{
    uint16_t i;
    uint8_t flag = 1;
    //жϴ봮ںŲǷֱ˳
	 if(!uart_is_uartNo(uartNo))
	 {
	        return 0;
	 }
    //жǷܽ
	for (i = 0; i < len && flag==1; i++)
	{
		buff[i] = uart_re1(uartNo, &flag); //
	}
	if (i < len)
		return 0; //ʧ
	else
		return 1; //ճɹ
}

//======================================================================
//ƣuart_enable_re_int
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//أ
//ܸҪڽж
//======================================================================
void uart_enable_re_int(uint8_t uartNo)
{
	EUSCI_A_Type* uartch;
	//жϴ봮ںŲǷֱ˳
	 if(!uart_is_uartNo(uartNo))
	 {
			return ;
	 }
	 uartch= (EUSCI_A_Type*)UART_ARR[uartNo];//ȡUARTַ
	 uartch->IE|=UCRXIE;//UARTж
     NVIC_EnableIRQ(table_irq_uart[uartNo]);//NVICģʹEUSCIAxж

}

//======================================================================
//ƣuart_disable_re_int
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//أ
//ܸҪشڽж
//======================================================================
void uart_disable_re_int(uint8_t uartNo)
{

	 EUSCI_A_Type* uartch;
	//жϴ봮ںŲǷֱ˳
	 if(!uart_is_uartNo(uartNo))
	 {
			return ;
	 }
	 uartch=(EUSCI_A_Type*) UART_ARR[uartNo];//ȡUARTַ
	 uartch->IE&=~UCRXIE;//ֹUARTж
     NVIC_DisableIRQ(table_irq_uart[uartNo]);//NVICģʹEUSCIAxж

}

//======================================================================
//ƣuart_get_re_int
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//أжϱ־ 1=нж;0=޽ж
//ܸҪȡڽжϱ־,ͬʱ÷ж
//======================================================================
uint8_t uart_get_re_int(uint8_t uartNo)
{
    //uint8_t flag;
    EUSCI_A_Type* uartch;
    //жϴ봮ںŲǷֱ˳
	 if(!uart_is_uartNo(uartNo))
	 {
			return 0;
	 }
	 uartch= (EUSCI_A_Type*)UART_ARR[uartNo];//ȡUARTַ
	 uartch->IE&=~UCTXIE;//ôڷжϣֹж
	 //ȡжϱ־жRIE;
	 return BGET(UCRXIE_OFS,uartch->IE);
}

//----------------------ΪڲŴ--------------------------------------
//=====================================================================
//ƣuart_is_uartNo
//أ1:ںںΧڣ0ںŲ
//˵uartNo:ںţUART_0UART_1UART_2UART_3
//ܸҪΪ׳ԶжuartNoǷڴַΧ
//=====================================================================
uint8_t uart_is_uartNo(uint8_t uartNo)
{
    if(((int)uartNo < (int)UART_0 || (int)uartNo >(int)UART_3))
        return 0;
    else
        return 1;
}


//======================================================================
//ƣBRSxSel
//˵fra:ʼС֣fra=1.0*fBRCLK/(16*baud_rate)С
//أValBRSxS[]fra±һµ8λֵ
//ܸҪòʼСҳUCBRFxĶӦֵ
//======================================================================
uint8_t BRSxSel(double fra)
{
	uint8_t brs;
	uint16_t i,temp;
	brs=0;
	temp=(uint16_t)(fra*1000);
	for(i=0;i<36;i++)
	{
		if(BRSxS[i]==temp)
		{
			brs=ValBRSxS[i];
			break;
		}
	}
	return brs;
}
//----------------------------ڲ--------------------------------------
