//============================================================================
//ļƣcmp.c
//ܸҪKL25 Ƚײļ
//ȨУݴѧ˼Ƕʽ(sumcu.suda.edu.cn)
//汾£2012-11-25  V1.0   ʼ汾
//============================================================================
#include "cmp.h"

//===========================================================================
//ƣcmp_init
//  
//˵: reference:οѹѡ  0=Vin1in  1=Vin2in
//         plusChannel: Ƚͨ
//         minusChannelȽͨ
//ͨ0,1,2,3,4,5ӦPTC6,PTC7,PTC8,PTC9,PTC30,PTC29
//ͨ6 Bandgap;ͨ7 DAC
//ܸҪCMPģʼ
//===========================================================================
void cmp_init(uint8_t reference,uint8_t plusChannel,uint8_t minusChannel)
{
	    //ͨȡģѡȽַ
//		CMP_MemMapPtr cmpch = COMP_E0_BASE;
		if(plusChannel>15)
			plusChannel = 15;
		if(plusChannel<0)
			plusChannel = 0;

		if(minusChannel>15)
			minusChannel = 15;
		if(minusChannel<0)
			minusChannel = 0;

		//1.ʼȽģ
		COMP_E0->CTL0 = 0;
		COMP_E0->INT = 0;

		//2.Ƚͨ
		if(BGET(COMP_E_CTL2_RSEL_OFS,COMP_E0->CTL2) == 0)
		{
			//2.1ʹȽͨ ʵ
			COMP_E0->CTL0 |= COMP_E_CTL0_IPEN + plusChannel;
			//2.2ֹ뻺
			COMP_E0->CTL3 |= (1 << plusChannel);
		}
		else
		{
			//2.1׼ѡͨ
			BCLR(COMP_E_CTL2_RSEL_OFS,COMP_E0->CTL2);
		}

		//3.øȽͨ
		if(BGET(COMP_E_CTL2_RSEL_OFS,COMP_E0->CTL2) == 0)
		{
			//3.1ʹܸȽͨ ʵ
			COMP_E0->CTL0 |= COMP_E_CTL0_IPEN + minusChannel;
			//2.2ֹ뻺
			COMP_E0->CTL3 |= (1 << minusChannel);
		}
		else
		{
			//2.1׼ѡ񣬸ͨ
			BSET(COMP_E_CTL2_RSEL_OFS,COMP_E0->CTL2);
		}

		//4.CMP_CTL1(ٱȽ,4,)
		COMP_E0->CTL1 |= (COMP_E_CTL1_PWRMD_0 | COMP_E_CTL1_FDLY_3 | COMP_E_CTL1_OUTPOL);

		//5.
		BCLR(COMP_E_CTL1_MRVS_OFS,COMP_E0->CTL1);
		COMP_E0->CTL2 &= COMP_E_CTL2_RSEL;
		if(reference==0)//οѹѡVDD3.3V
			COMP_E0->CTL2 |= COMP_E_CTL2_RS_1;
		else if(reference==1)
			COMP_E0->CTL2 |= COMP_E_CTL2_RS_2;
		else
			COMP_E0->CTL2 |= COMP_E_CTL2_RS_3;

		BSET(COMP_E_CTL1_ON_OFS,COMP_E0->CTL1);
}

//===========================================================================
//ƣcmp_enable_int
//أ
//˵
//ܸҪȽж
//===========================================================================
void cmp_enable_int()
{
	//شж
	BSET(COMP_E_CTL1_IES_OFS,COMP_E0->CTL1);
	//жϱ־Ĵ
	COMP_E0->INT &= 0;
	//жϱ־Ϊ1
	COMP_E0->INT |= COMP_E_INT_IFG;
	 NVIC_EnableIRQ(16);
}

//===========================================================================
//ƣcmp_disable_int
//أ
//˵
//ܸҪرȽж
//===========================================================================
void cmp_disable_int()
{
	//شж
	BCLR(COMP_E_CTL1_IES_OFS,COMP_E0->CTL1);
	//жϱ־Ĵ
	COMP_E0->INT &= 0;
	//ؽŵIRQж
	NVIC_DisableIRQ(16);

}

