//=====================================================================
//ļƣSPI.c
//ܸҪSPIײԴļ
//ȨУݴѧ˼Ƕʽ(sumcu.suda.edu.cn)
//¼¼2017-11-30  V1.0
//=====================================================================
#include "spi.h"

//====崮IRQŶӦ====
static const IRQn_Type table_irq_SPI[8] = {EUSCIA0_IRQn, EUSCIA1_IRQn, \
	EUSCIA2_IRQn,EUSCIA3_IRQn,EUSCIB0_IRQn,EUSCIB1_IRQn,EUSCIB2_IRQn,EUSCIB3_IRQn};
//=====================================================================
//ƣSPI_init
//˵SPIʼ
//NoģţȡֵSPI_A0SPI_A1SPI_A2SPI_A3SPI_B0SPI_B1SPI_B2SPI_B3
//       MSTSPIӻѡ0ѡΪӻ,1ѡΪ
//       BaudRateʣȡ1200060004000300015001000λkbps
//       CKPLCKPL=0ЧSPIʱӣЧCPOL=1ЧSPIʱӣЧ
//       CKPHCKPH=0λΪ0 CKPH=1λΪ1
//أ
//עʹõģʽߵʱֻӦCLKSIMOSOMI
//=====================================================================
void SPI_init(uint8_t No,uint8_t MST,uint16_t BaudRate,\
                                               uint8_t CKPL,uint8_t CKPH)
{
	EUSCI_A_SPI_Type *baseadd_A;
	EUSCI_B_SPI_Type *baseadd_B;
    if(No>7)   No=0;    //SPIŲǿѡ 0ģ

    //ŸΪSPI
    switch(No)
        {
        	//case SPI_A0:
        	//case SPI_A1:
        	//case SPI_A2:
        	case SPI_A3:
        	{//ѡP9.5~9.7ĵһܹ(CLKSOMISIMO)
        		P9SEL0|=(BIT5|BIT6|BIT7);
        		P9SEL1&=~(BIT5|BIT6|BIT7);
        		break;
        	}
        	case SPI_B0:
        	{//ѡP1.5~1.7ĵһܹ(CLKSIMOSOMI)
        		P1SEL0|=(BIT5|BIT6|BIT7);
        		P1SEL1&=~(BIT5|BIT6|BIT7);
        		break;
        	}
        	case SPI_B1:
        	{//ѡP6.3~6.5ĵһܹ(CLKSIMOSOMI)
        		P6SEL0|=(BIT3|BIT4|BIT5);
        		P6SEL1&=~(BIT3|BIT4|BIT5);
        		break;//Ϊ
        	}
        	case SPI_B2:
        	{//ѡP3.5~3.7ĵһܹ(CLKSIMOSOMI)
        		P3SEL0|=(BIT5|BIT6|BIT7);
        		P3SEL1&=~(BIT5|BIT6|BIT7);
        		break;
        	}
        	case SPI_B3:
        	{//ѡP10.1~10.3ĵһܹ(CLKSIMOSOMI)
        		P10SEL0|=(BIT1|BIT2|BIT3);
        		P10SEL1&=~(BIT1|BIT2|BIT3);
        	    break;//Ϊӻ
            }
        }
       if(No<=3)//Aģ
       {
    	   baseadd_A=SPIA_baseadd(No);//ӦģĻַ
    	   baseadd_A->CTLW0|=EUSCI_A_CTLW0_SWRST;//ʹλԽSPIģ
    	   if(MST==1)//ģʽ
    	   {
    		   baseadd_A->CTLW0|=EUSCI_A_CTLW0_UCSSEL_2;//ѡʱԴSMCLK12MHz
    		   baseadd_A->BRW=12000000/BaudRate;//
    		   //ͬλ
    		   baseadd_A->CTLW0|=EUSCI_A_CTLW0_MST|EUSCI_A_CTLW0_SYNC|EUSCI_A_CTLW0_MSB;
    		   //Чλ8λSPIģʽ
    		   baseadd_A->CTLW0&=~(EUSCI_A_CTLW0_SEVENBIT|EUSCI_A_CTLW0_MODE_MASK);
    		   //ѡʱӼ
    		   CKPL==0?(baseadd_A->CTLW0&=~EUSCI_A_CTLW0_CKPL):\
    				             (baseadd_A->CTLW0|=EUSCI_A_CTLW0_CKPL);
    		   //ѡʱλ
    		   CKPH==0?(baseadd_A->CTLW0&=~EUSCI_A_CTLW0_CKPH):\
			                      (baseadd_A->CTLW0|=EUSCI_A_CTLW0_CKPH);
    		   baseadd_A->CTLW0&=~EUSCI_A_CTLW0_SWRST;//λʹSPIģ
    	   }
    	   else//Ǵӻ
    	   {
    		   //ӻ
    		   baseadd_A->CTLW0&=~EUSCI_A_CTLW0_MST;
    		   //ͬλ
    		   baseadd_A->CTLW0|=EUSCI_A_CTLW0_SYNC|EUSCI_A_CTLW0_MSB;
    		   //Чλ8λSPIģʽ
    		   baseadd_A->CTLW0&=~(EUSCI_A_CTLW0_SEVENBIT|EUSCI_A_CTLW0_MODE_MASK);
    		   //ѡʱӼ
    		   CKPL==0?(baseadd_A->CTLW0&=~EUSCI_A_CTLW0_CKPL):\
    		                  (baseadd_A->CTLW0|=EUSCI_A_CTLW0_CKPL);
    		   //ѡʱλ
    		   CKPH==0?(baseadd_A->CTLW0&=~EUSCI_A_CTLW0_CKPH):\
    		  			         (baseadd_A->CTLW0|=EUSCI_A_CTLW0_CKPH);
    		   baseadd_A->CTLW0&=~EUSCI_A_CTLW0_SWRST;//λʹSPIģ
    	   }
       }
       else//Bģ
       {
    	    baseadd_B=SPIB_baseadd(No);//ӦģĻַ
    	    baseadd_B->CTLW0|=EUSCI_B_CTLW0_SWRST;//ʹλԽSPIģ
    	    if(MST==1)//ģʽ
    	    {
    	    	baseadd_B->CTLW0|=EUSCI_B_CTLW0_UCSSEL_2;//ѡʱԴSMCLK12MHz
    	    	baseadd_B->BRW=12000000/BaudRate;//
    	        //ͬλ
    	    	baseadd_B->CTLW0|=EUSCI_B_CTLW0_MST|EUSCI_B_CTLW0_SYNC|EUSCI_B_CTLW0_MSB;
    	        //Чλ8λSPIģʽ
    	    	baseadd_B->CTLW0&=~(EUSCI_B_CTLW0_SEVENBIT|EUSCI_B_CTLW0_MODE_MASK);
    	      	//ѡʱӼ
    	      	CKPL==0?(baseadd_B->CTLW0&=~EUSCI_B_CTLW0_CKPL):\
    	      				   (baseadd_B->CTLW0|=EUSCI_B_CTLW0_CKPL);
    	      	//ѡʱλ
    	      	CKPH==0?(baseadd_B->CTLW0&=~EUSCI_B_CTLW0_CKPH):\
    	  			            (baseadd_B->CTLW0|=EUSCI_B_CTLW0_CKPH);
    	      	baseadd_B->CTLW0&=~EUSCI_B_CTLW0_SWRST;//λʹSPIģ
    	     }
    	     else//Ǵӻ
    	     {
    	      	//ӻ
    	    	baseadd_B->CTLW0&=~EUSCI_B_CTLW0_MST;
    	      	//ͬλ
    	    	baseadd_B->CTLW0|=EUSCI_B_CTLW0_SYNC|EUSCI_B_CTLW0_MSB;
    	      	//Чλ8λSPIģʽ
    	    	baseadd_B->CTLW0&=~(EUSCI_B_CTLW0_SEVENBIT|EUSCI_B_CTLW0_MODE_MASK);
    	      	//ѡʱӼ
    	      	CKPL==0?(baseadd_B->CTLW0&=~EUSCI_B_CTLW0_CKPL):\
    	      		             (baseadd_B->CTLW0|=EUSCI_B_CTLW0_CKPL);
    	      	//ѡʱλ
    	      	CKPH==0?(baseadd_B->CTLW0&=~EUSCI_B_CTLW0_CKPH):\
    	      		  			  (baseadd_B->CTLW0|=EUSCI_B_CTLW0_CKPH);
    	      	baseadd_B->CTLW0&=~EUSCI_B_CTLW0_SWRST;//λʹSPIģ
    	     }
       }
}

//=====================================================================
//ƣSPI_send1.
//˵SPIһֽݡ
//NoģţȡֵSPI_A0SPI_A1SPI_A2SPI_A3SPI_B0SPI_B1SPI_B2SPI_B3
//       data     Ҫ͵һֽݡ
//أ
//=====================================================================
void SPI_send1(uint8_t No,uint8_t data)
{
	//λ󣬷жϱ־λΪ10ʾ1ʾգдԶ巢жϱ־λ
	if(No<=3)//Aģ
	{
		while (((SPIA_baseadd(No))->IFG&EUSCI_A_IFG_TXIFG)==0);  //ȴһֽڷ
		(SPIA_baseadd(No))->TXBUF=data;
	}
	else//Bģ
	{
		while (((SPIB_baseadd(No))->IFG&EUSCI_B_IFG_TXIFG)==0);  //ȴһֽڷ
		(SPIB_baseadd(No))->TXBUF=data;
	}
}

//=====================================================================
//ƣSPI_sendN.
//˵SPIݡ
//NoģţȡֵSPI_A0SPI_A1SPI_A2SPI_A3SPI_B0SPI_B1SPI_B2SPI_B3
//       n:     Ҫ͵ֽڸΧΪ(1~255)
//       data[]:׵ַ
//أޡ
//=====================================================================
void SPI_sendN(uint8_t No,uint8_t n,uint8_t data[])
{
	uint8_t i;
	for (i = 0; i < n; i++)
	{
	   SPI_send1(No, data[i]);
	}
}

//=====================================================================
//ƣSPI_receive1.
//˵SPIһֽڵ
//NoģţȡֵSPI_A0SPI_A1SPI_A2SPI_A3SPI_B0SPI_B1SPI_B2SPI_B3
//أյݡ
//=====================================================================
uint8_t SPI_receive1(uint8_t No)
{
	uint8_t c;
	//λ󣬽жϱ־λΪ00ʾգ1ʾԶжϱ־
	if(No<=3)//Aģ
	{
		while (((SPIA_baseadd(No))->IFG&EUSCI_A_IFG_RXIFG)==0);  // ȴյһֽ
		c=(SPIA_baseadd(No))->RXBUF;
		return c;
	}
	else//Bģ
	{
		while (((SPIB_baseadd(No))->IFG&EUSCI_B_IFG_RXIFG)==0);  // ȴյһֽ
		c=(SPIB_baseadd(No))->RXBUF;
		return c;
	}
}

//=====================================================================
//ƣSPI_receiveN.
//˵SPIݡn=1ʱǽһֽڵݡ
//NoģţȡֵSPI_A0SPI_A1SPI_A2SPI_A3SPI_B0SPI_B1SPI_B2SPI_B3
//          n:    Ҫ͵ֽڸΧΪ(1~255),
//       data[]:յݴŵ׵ַ
//أ1ճɹ,0ʧܡ
//=====================================================================
uint8_t SPI_receiveN(uint8_t No,uint8_t n,uint8_t data[])
{
	uint8_t i;
	for (i = 0; i < n; i++)
	{
		data[i]=SPI_receive1(No);
	}
	if(i<n)
	    return 0;    //ʧ
	else
	    return 1;    //ճɹ
}
//=====================================================================
//ƣSPI_enable_re_int
//˵SPIжϡ
//NoģţȡֵSPI_A0SPI_A1SPI_A2SPI_A3SPI_B0SPI_B1SPI_B2SPI_B3
//أޡ
//=====================================================================
void SPI_enable_re_int(uint8_t No)
{
    if(No<=3)//Aģ
    {
    	EUSCI_A_SPI_Type *baseadd_A=SPIA_baseadd(No);
    	//ʹܽж
    	baseadd_A->IE|=EUSCI_A_IE_RXIE;
        //ʹģж
        NVIC_EnableIRQ(table_irq_SPI[No]);
    }
    else//Bģ
    {
    	EUSCI_B_SPI_Type *baseadd_B=SPIB_baseadd(No);
    	//ʹܽж
    	baseadd_B->IE|=EUSCI_B_IE_RXIE;
    	//ʹģж
    	NVIC_EnableIRQ(table_irq_SPI[No]);
    }
}


//=====================================================================
//ƣSPI_disable_re_int
//˵رSPIжϡ
//NoģţȡֵSPI_A0SPI_A1SPI_A2SPI_A3SPI_B0SPI_B1SPI_B2SPI_B3
//أޡ
//=====================================================================
void SPI_disable_re_int(uint8_t No)
{
	if(No<=3)//Aģ
	{
		EUSCI_A_SPI_Type *baseadd_A=SPIA_baseadd(No);
		//ֹж
		baseadd_A->IE&=~EUSCI_A_IE_RXIE;
		//ֹģж
		NVIC_DisableIRQ(table_irq_SPI[No]);
	}
	else
	{
		EUSCI_B_SPI_Type *baseadd_B=SPIB_baseadd(No);
		//ֹж
		baseadd_B->IE&=~EUSCI_B_IE_RXIE;
		//ֹģж
		NVIC_DisableIRQ(table_irq_SPI[No]);
	}
}

