//===========================================================================
//ļƣdma.h
//ܸҪdmaײԴļ
//ȨУݴѧǶʽ(sumcu.suda.edu.cn)
//¼¼2017-12-09  V1.0
//===========================================================================

#ifndef DMA_H_
#define DMA_H_

#include "mcu.h"

//DMAƽṹ ԴַĿַͨģʽԼδʹò
typedef struct _DMA_ControlTable
{
	//srcEndAddr Դַ
    volatile void *srcEndAddr;
    //dstEndAddr Ŀַ
    volatile void *dstEndAddr;
    //ģʽ
    volatile uint32_t control;
    //ֶ
    volatile uint32_t spare;
} DMA_ControlTable;

#define DMA_TaskStructEntry(transferCount,                                     \
                            itemSize,                                          \
                            srcIncrement,                                      \
                            srcAddr,                                           \
                            dstIncrement,                                      \
                            dstAddr,                                           \
                            arbSize,                                           \
                            mode)                                              \
    {                                                                          \
        (((srcIncrement) == UDMA_SRC_INC_NONE) ? (void *)(srcAddr) :           \
            ((void *)(&((uint8_t *)(srcAddr))[((transferCount) <<              \
                                         ((srcIncrement) >> 26)) - 1]))),      \
            (((dstIncrement) == UDMA_DST_INC_NONE) ? (void *)(dstAddr) :       \
            ((void *)(&((uint8_t *)(dstAddr))[((transferCount) <<              \
                                         ((dstIncrement) >> 30)) - 1]))),      \
        (srcIncrement) | (dstIncrement) | (itemSize) | (arbSize) |             \
        (((transferCount) - 1) << 4) |                                         \
        ((((mode) == UDMA_MODE_MEM_SCATTER_GATHER) ||                          \
          ((mode) == UDMA_MODE_PER_SCATTER_GATHER)) ?                          \
                (mode) | UDMA_MODE_ALT_SELECT : (mode)), 0                     \
    }
//*****************************************************************************
// DMAͨԱ־
//*****************************************************************************
#define UDMA_ATTR_USEBURST      0x00000001
#define UDMA_ATTR_ALTSELECT     0x00000002
#define UDMA_ATTR_HIGH_PRIORITY 0x00000004
#define UDMA_ATTR_REQMASK       0x00000008
#define UDMA_ATTR_ALL           0x0000000F

//*****************************************************************************
// DMAͨģʽ
//*****************************************************************************
#define UDMA_MODE_STOP          0x00000000
#define UDMA_MODE_BASIC         0x00000001
#define UDMA_MODE_AUTO          0x00000002
#define UDMA_MODE_PINGPONG      0x00000003
#define UDMA_MODE_MEM_SCATTER_GATHER                                          \
                                0x00000004
#define UDMA_MODE_PER_SCATTER_GATHER                                          \
                                0x00000006
#define UDMA_MODE_ALT_SELECT    0x00000001

//*****************************************************************************
// DMAͨ
//*****************************************************************************
#define UDMA_DST_INC_8          0x00000000
#define UDMA_DST_INC_16         0x40000000
#define UDMA_DST_INC_32         0x80000000
#define UDMA_DST_INC_NONE       0xc0000000
#define UDMA_SRC_INC_8          0x00000000
#define UDMA_SRC_INC_16         0x04000000
#define UDMA_SRC_INC_32         0x08000000
#define UDMA_SRC_INC_NONE       0x0c000000
#define UDMA_SIZE_8             0x00000000
#define UDMA_SIZE_16            0x11000000
#define UDMA_SIZE_32            0x22000000
#define UDMA_DST_PROT_PRIV      0x00200000
#define UDMA_SRC_PROT_PRIV      0x00040000
#define UDMA_ARB_1              0x00000000
#define UDMA_ARB_2              0x00004000
#define UDMA_ARB_4              0x00008000
#define UDMA_ARB_8              0x0000c000
#define UDMA_ARB_16             0x00010000
#define UDMA_ARB_32             0x00014000
#define UDMA_ARB_64             0x00018000
#define UDMA_ARB_128            0x0001c000
#define UDMA_ARB_256            0x00020000
#define UDMA_ARB_512            0x00024000
#define UDMA_ARB_1024           0x00028000
#define UDMA_NEXT_USEBURST      0x00000008

//*****************************************************************************
// Ƿʹõַ
//*****************************************************************************
#define UDMA_PRI_SELECT         0x00000000
#define UDMA_ALT_SELECT         0x00000008

//
// Channel 0
//
#define DMA_CH0_RESERVED0          0x00000000
#define DMA_CH0_EUSCIA0TX          0x01000000
#define DMA_CH0_EUSCIB0TX0         0x02000000
#define DMA_CH0_EUSCIB3TX1         0x03000000
#define DMA_CH0_EUSCIB2TX2         0x04000000
#define DMA_CH0_EUSCIB1TX3         0x05000000
#define DMA_CH0_TIMERA0CCR0        0x06000000
#define DMA_CH0_AESTRIGGER0        0x07000000

//
// Channel 1
//
#define DMA_CH1_RESERVED0          0x00000001
#define DMA_CH1_EUSCIA0RX          0x01000001
#define DMA_CH1_EUSCIB0RX0         0x02000001
#define DMA_CH1_EUSCIB3RX1         0x03000001
#define DMA_CH1_EUSCIB2RX2         0x04000001
#define DMA_CH1_EUSCIB1RX3         0x05000001
#define DMA_CH1_TIMERA0CCR2        0x06000001
#define DMA_CH1_AESTRIGGER1        0x07000001

//
// Channel 2
//
#define DMA_CH2_RESERVED0          0x00000002
#define DMA_CH2_EUSCIA1TX          0x01000002
#define DMA_CH2_EUSCIB1TX0         0x02000002
#define DMA_CH2_EUSCIB0TX1         0x03000002
#define DMA_CH2_EUSCIB3TX2         0x04000002
#define DMA_CH2_EUSCIB2TX3         0x05000002
#define DMA_CH2_TIMERA1CCR0        0x06000002
#define DMA_CH2_AESTRIGGER2        0x07000002

//
// Channel 3
//
#define DMA_CH3_RESERVED0          0x00000003
#define DMA_CH3_EUSCIA1RX          0x01000003
#define DMA_CH3_EUSCIB1RX0         0x02000003
#define DMA_CH3_EUSCIB0RX1         0x03000003
#define DMA_CH3_EUSCIB3RX2         0x04000003
#define DMA_CH3_EUSCIB2RX3         0x05000003
#define DMA_CH3_TIMERA1CCR2        0x06000003
#define DMA_CH3_RESERVED1          0x07000003

//
// Channel 4
//
#define DMA_CH4_RESERVED0          0x00000004
#define DMA_CH4_EUSCIA2TX          0x01000004
#define DMA_CH4_EUSCIB2TX0         0x02000004
#define DMA_CH4_EUSCIB1TX1         0x03000004
#define DMA_CH4_EUSCIB0TX2         0x04000004
#define DMA_CH4_EUSCIB3TX3         0x05000004
#define DMA_CH4_TIMERA2CCR0        0x06000004
#define DMA_CH4_RESERVED1          0x07000004

//
// Channel 5
//
#define DMA_CH5_RESERVED0          0x00000005
#define DMA_CH5_EUSCIA2RX          0x01000005
#define DMA_CH5_EUSCIB2RX0         0x02000005
#define DMA_CH5_EUSCIB1RX1         0x03000005
#define DMA_CH5_EUSCIB0RX2         0x04000005
#define DMA_CH5_EUSCIB3RX3         0x05000005
#define DMA_CH5_TIMERA2CCR2        0x06000005
#define DMA_CH5_RESERVED1          0x07000005

//
// Channel 6
//
#define DMA_CH6_RESERVED0          0x00000006
#define DMA_CH6_EUSCIA3TX          0x01000006
#define DMA_CH6_EUSCIB3TX0         0x02000006
#define DMA_CH6_EUSCIB2TX1         0x03000006
#define DMA_CH6_EUSCIB1TX2         0x04000006
#define DMA_CH6_EUSCIB0TX3         0x05000006
#define DMA_CH6_TIMERA3CCR0        0x06000006
#define DMA_CH6_EXTERNALPIN        0x07000006

//
// Channel 7
//
#define DMA_CH7_RESERVED0          0x00000007
#define DMA_CH7_EUSCIA3RX          0x01000007
#define DMA_CH7_EUSCIB3RX0         0x02000007
#define DMA_CH7_EUSCIB2RX1         0x03000007
#define DMA_CH7_EUSCIB1RX2         0x04000007
#define DMA_CH7_EUSCIB0RX3         0x05000007
#define DMA_CH7_TIMERA3CCR2        0x06000007
#define DMA_CH7_ADC14              0x07000007

//
//  DMAж
//
#define DMA_INT0   (50)
#define DMA_INT1   (49)
#define DMA_INT2   (48)
#define DMA_INT3   (47)
#define DMA_INTERR INT_DMA_ERR

#define DMA_CHANNEL_0       0
#define DMA_CHANNEL_1       1
#define DMA_CHANNEL_2       2
#define DMA_CHANNEL_3       3
#define DMA_CHANNEL_4       4
#define DMA_CHANNEL_5       5
#define DMA_CHANNEL_6       6
#define DMA_CHANNEL_7       7

//===========================================================================
//ƣdma_init
//أ
//˵channelStructIndexͨṹUDMA_PRI_SELECTUDMA_ALT_SELECT
//		 controlģʽѡ
//		 controlTableDMAƱ
//ܸҪʼdma
//===========================================================================
void dma_init(uint32_t channelStructIndex, uint32_t control,void *controlTable);

//===========================================================================
//ƣdma_enable
//أ
//˵channelNum ͨΪ 0~7
//ܸҪʹdmaͨ
//===========================================================================
void dma_enableCh(uint8_t channelNum);

//===========================================================================
//ƣdma_disable
//أ
//˵channelNum ͨΪ 0~7
//ܸҪرdmaͨ
//===========================================================================
void dma_disableCh(uint8_t channelNum);

//===========================================================================
//ƣdma_enable_int
//أ
//˵
//ܸҪdmaжϹ
//===========================================================================
void dma_enable_int(uint32_t interruptNumber, uint32_t channelNum);

//===========================================================================
//ƣdma_disable_int
//أ
//˵
//ܸҪرdmaжϹ
//===========================================================================
void dma_disable_int(uint32_t interruptNumber, uint32_t channelNum);

//===========================================================================
//ƣdma_setChannelTransfer
//أ
//˵channelStructIndexͨṹUDMA_PRI_SELECTUDMA_ALT_SELECT
//        modeģʽѡѡԶģʽUDMA_MODE_AUTO
//        srcAddrԴַ
//        dstAddrĿַ
//        transferSizeС
//ܸҪͨ
//===========================================================================
void dma_setChannelTransfer(uint32_t channelStructIndex, uint32_t mode,
        void *srcAddr, void *dstAddr, uint32_t transferSize);

//===========================================================================
//ƣdma_requestSoftwareTransfer
//أ
//˵channelNum ͨΪ 0~7
//ܸҪͨ
//===========================================================================
void dma_requestSoftwareTransfer(uint32_t channelNum);
//////
extern const uint8_t data_array[];
#endif
