//ͷļ
#include "flash.h"

//=================ڲú=========================================
//======================================================================
//ƣflash_init
//أ
//˵
//ܸҪʼflashģ
//======================================================================
void flash_init(void)
{
    // ʳ־λ
    FLCTL->PRG_CTLSTAT=1;//ֲ־
    FLCTL->ERASE_CTLSTAT=(1<<18);//ղ־
    FLCTL->IFG = (1<<9);//дԽ־
}

//======================================================================
//ƣflash_erase
//أִִ״̬0=1=쳣
//˵sectĿ0-63
//======================================================================
uint8_t flash_erase(uint16_t sect)
{
	uint32_t  word;
	uint8_t bank;
	uint8_t type=0;
	uint8_t sector;
	if(sect>=32)
	{
		bank=1;
		sector=sect-32;
	}
	else
	{
		bank=0;
		sector=sect;
	}
    if(bank>1 || type>1 || sector>31 || (type&&(sector>1))  )//жϸֵĲǷϷ
    	return 1;
    while(!((FLCTL->ERASE_CTLSTAT & FLCTL_ERASE_CTLSTAT_STATUS_MASK)
            == FLCTL_ERASE_CTLSTAT_STATUS_0));//жĴǷڿ״̬
    FLCTL->ERASE_CTLSTAT=FLCTL->ERASE_CTLSTAT|FLCTL_ERASE_CTLSTAT_MODE;//ģʽΪ
//ݽϢҪʼַòԼò֤
    if(type==(0<<8))
    {
    	if(bank==(0<<16))
    	{
    		word  = (uint32_t)(sector*(1<<12));
    		FLCTL->BANK0_RDCTL=FLCTL->BANK0_RDCTL|FLCTL_BANK0_RDCTL_RD_MODE_STATUS_4;
    	}
    	else
    	{
    		word  = (uint32_t)((sector+32)*(1<<12));
    		FLCTL->BANK1_RDCTL=FLCTL->BANK1_RDCTL|FLCTL_BANK1_RDCTL_RD_MODE_STATUS_4;
    	}
    	FLCTL->ERASE_CTLSTAT=FLCTL->ERASE_CTLSTAT|FLCTL_ERASE_CTLSTAT_TYPE_0;
    }
    else
    {
    	if(bank==(0<<16))
    	{
    	    word  = (uint32_t)(0x00200000+(sector*(1<<12)));
    	    FLCTL->BANK0_RDCTL=FLCTL->BANK0_RDCTL|FLCTL_BANK0_RDCTL_RD_MODE_STATUS_4;
    	}
    	else
    	{
    	    word  = (uint32_t)(0x00202000+(sector*(1<<12)));
    	    FLCTL->BANK1_RDCTL=FLCTL->BANK1_RDCTL|FLCTL_BANK1_RDCTL_RD_MODE_STATUS_4;
    	}
    	FLCTL->ERASE_CTLSTAT=FLCTL->ERASE_CTLSTAT|FLCTL_ERASE_CTLSTAT_TYPE_1;
    }
    FLCTL->ERASE_SECTADDR=word;// Ŀַ
    FLCTL->ERASE_CTLSTAT=FLCTL->ERASE_CTLSTAT|1;// 
//жϲǷɣû


    while(!((FLCTL->ERASE_CTLSTAT & FLCTL_ERASE_CTLSTAT_STATUS_MASK)
            == FLCTL_ERASE_CTLSTAT_STATUS_3));
//ɺжɵǴֹǳɹ
    if ((((FLCTL->ERASE_CTLSTAT) & (FLCTL_ERASE_CTLSTAT_ADDR_ERR))==FLCTL_ERASE_CTLSTAT_ADDR_ERR))
    	return 1;
//ɹʩв0
   // FLCTL->ERASE_CTLSTAT=FLCTL->ERASE_CTLSTAT&(~(FLCTL_ERASE_CTLSTAT_STATUS_MASK));
    FLCTL->ERASE_CTLSTAT|=FLCTL_ERASE_CTLSTAT_CLR_STAT;
    return 0;

}

//======================================================================
//ƣflash_write
//أִ״̬0=1=쳣
//˵bank_type_sectĿţΧȡʵоƬMSP432P401R
//bank0-_main 0~31, bank1-_main 0~31, bank0-_info 0~1, bank1-_info 0~1ÿ4KB
//        NдֽĿ
//        bufԴݻ׵ַ
//ܸҪbufʼNֽд뵽flash洢sect offset
//=======================================================================
uint8_t flash_write(uint16_t sect,uint16_t offset,uint16_t N,uint8_t *buf)
{
    uint32_t word;
	uint8_t  bank;
	uint8_t  type=0;
	uint8_t  sector;
	uint32_t data;
	if(sect>=32)
		{
			bank=1;
			sector=sect-32;
		}
		else
		{
			bank=0;
			sector=sect;
		}
    if(bank>1 || type>1 || sector>31 || (type&&(sector>1)) ||( offset+N)>4095 )//жϸֵĲǷϷ
    	return 1;
    //ַ
    if(type==(0<<8))
        {
        	if(bank==(0<<16))
        	{
        		word  = (uint32_t)(sector*(1<<12)+offset);
        	}
        	else
        	{
        		word  = (uint32_t)((sector+32)*(1<<12)+offset);

        	}

        }
        else
        {
        	if(bank==(0<<16))
        	{
        	    word  = (uint32_t)(0x00200000+(sector*(1<<12))+offset);

        	}
        	else
        	{
        	    word  = (uint32_t)(0x00202000+(sector*(1<<12))+offset);

        	}

        }
//־λ
    FLCTL->IFG |= (FLCTL_IFG_PRG_ERR | FLCTL_IFG_PRG);
//ֲλԼдģʽΪд
    BSET(FLCTL_PRG_CTLSTAT_ENABLE_OFS,FLCTL->PRG_CTLSTAT);
    BCLR(FLCTL_PRG_CTLSTAT_MODE_OFS,FLCTL->PRG_CTLSTAT);
//ԵַûжĲֽеֽд봦
    while ((word & 0x03)&&N > 0)
       {
    	data=HWREG8(buf);
        HWREG8(word)=data;
    	while (BGET(FLCTL_IFG_PRG_OFS,FLCTL->IFG)==0);//Ƿ
        	   buf++;
        	   word++;
               N--;
       }
//ַÿֽд
    while ((word & 0x0F) && (N > 3))
       {
    	       data=HWREG32(buf);
    	       HWREG32(word)=data;
    	while (BGET(FLCTL_IFG_PRG_OFS,FLCTL->IFG)==0);
    	       buf += 4;
    	       word += 4;
               N -= 4;
           }
//δĲ֣еֽд
    while (N > 0)
       {
    	data=HWREG8(buf);
        HWREG8(word)=data;
    	while (BGET(FLCTL_IFG_PRG_OFS,FLCTL->IFG)==0);
        	   buf++;
        	   word++;
               N--;
       }
    return 0;
    }




uint8_t flash_write_physical(uint32_t destaddr,uint16_t N,uint8_t *buf)
{
    uint32_t word;
	uint8_t  sector;
	uint32_t data;
	word=destaddr;
	sector=word>>12;
	if(destaddr>0x1FFFF)
	{
		sector-=32;
		flash_unprotect((1<<16)|(0<<8)|(sector+1));
		flash_unprotect((1<<16)|(0<<8)|sector);
	}
	else {
		flash_unprotect((0<<16)|(0<<8)|(sector+1));
		flash_unprotect((0<<16)|(0<<8)|sector);
	}
//־λ
    FLCTL->IFG |= (FLCTL_IFG_PRG_ERR | FLCTL_IFG_PRG);
//ֲλԼдģʽΪд
    BSET(FLCTL_PRG_CTLSTAT_ENABLE_OFS,FLCTL->PRG_CTLSTAT);
    BCLR(FLCTL_PRG_CTLSTAT_MODE_OFS,FLCTL->PRG_CTLSTAT);
//ԵַûжĲֽеֽд봦
    while ((word & 0x03)&&N > 0)
       {
    	data=HWREG8(buf);
        HWREG8(word)=data;
    	while (BGET(FLCTL_IFG_PRG_OFS,FLCTL->IFG)==0);//Ƿ
        	   buf++;
        	   word++;
               N--;
       }
//ַÿֽд
    while ((word & 0x0F) && (N > 3))
       {
    	       data=HWREG32(buf);
    	       HWREG32(word)=data;
    	while (BGET(FLCTL_IFG_PRG_OFS,FLCTL->IFG)==0);
    	       buf += 4;
    	       word += 4;
               N -= 4;
           }
//δĲ֣еֽд
    while (N > 0)
       {
    	data=HWREG8(buf);
        HWREG8(word)=data;
    	while (BGET(FLCTL_IFG_PRG_OFS,FLCTL->IFG)==0);
        	   buf++;
        	   word++;
               N--;
       }
	if(destaddr>0x1FFFF)
	{
		flash_protect((1<<16)|(0<<8)|(sector+1));
		flash_protect((1<<16)|(0<<8)|sector);
	}
	else {
		flash_protect((0<<16)|(0<<8)|(sector+1));
		flash_protect((0<<16)|(0<<8)|sector);
	}

    return 0;
    }

//======================================================================
//ƣflash_read_physical
//أ
//˵destݴŴַĿǴݣRAM
//       addrĿַҪΪ4ı磺0x00000004
//       NֽĿ1~1024
//ܸҪȡflashַָ
//======================================================================
void flash_read_physical(uint8_t *dest,uint32_t addr,uint16_t N)
{
	uint8_t *src;
    src=(uint8_t *)addr;
    memcpy(dest,src,N);//srcNֽݵdest
}

//=====================================================================
//ƣflash_read_logic
//أ
//˵destݴŴַĿǴݣRAM
//       sectorţΧȡʵоƬKL250~127ÿ1KB
//       offset:ڲƫƵַ0~1020ҪΪ0,48,12......
//       NֽĿ1~1024
//ܸҪȡflash洢sect offsetʼNֽڣRAMdest
//======================================================================
void flash_read_logic(uint8_t *dest,uint16_t sect,uint16_t offset,uint16_t N)
{
	uint8_t  bank;
	uint8_t  type=0;
	uint8_t  sector;
	uint8_t *src;
    uint32_t addrbase;

    if(sect>=32)
    		{
    			bank=1;
    			sector=sect-32;
    		}
    		else
    		{
    			bank=0;
    			sector=sect;
    		}
    if(bank>1 || type>1 || sector>31 || (type&&(sector>1)) )//жϸֵĲǷϷ
    {
    	//ֵʱ0xFF
    	while(N)
    	{
    		*dest=0xFF;
    		dest++;
    		N--;
    	}
    	return;
    }
    //ַ
    if(sect>=32)
    		{
    	addrbase=0x00020000;
    		}
    		else
    		{
    			addrbase=0x00000000;
    		}

    src=(uint8_t *)(sector*4096+offset+addrbase);//ַ
    memcpy(dest,src,N);//srcNֽݵdest
}

//========================================================================
//ƣflash_protect
//أ
//˵bank_type_sect
//ܸҪflash
//˵        ÿñһΣһ
//========================================================================
void flash_protect(uint8_t sect)
{

	uint8_t  bank;
	uint8_t  type=0;
	uint8_t  sector;
	if(sect>=32)
			{
				bank=1;
				sector=sect-32;
			}
			else
			{
				bank=0;
				sector=sect;
			}
    if(bank>1 || type>1 || sector>31 || (type&&(sector>1)) )//жϸֵĲǷϷ
    	return;

	//FLCTL_PRG_CTLSTAT  FLCTL_PRGBRST_CTLSTAT FLCTL_ERASE_CTLSTAT ȫʾΪ״̬
	while(  (FLCTL->PRG_CTLSTAT & FLCTL_PRG_CTLSTAT_STATUS_MASK  )            ||
			(FLCTL->PRGBRST_CTLSTAT & FLCTL_PRGBRST_CTLSTAT_BURST_STATUS_MASK)||
			(FLCTL->ERASE_CTLSTAT & FLCTL_ERASE_CTLSTAT_STATUS_MASK));

	//дĴsectλλ ʹsectڰȫ״̬


    if(sect>=32)
    		{
    	BSET(sector,FLCTL->BANK1_MAIN_WEPROT);
    		}
    		else
    		{
    			BSET(sector,FLCTL->BANK0_MAIN_WEPROT);
    		}
}

//========================================================================
//ƣflash_unprotect
//أ
//˵ҪⱣ
//ܸҪflashⱣ
//========================================================================
void flash_unprotect(uint16_t sect)
{
	uint8_t  bank;
	uint8_t  type=0;
	uint8_t  sector;
	if(sect>=32)
			{
				bank=1;
				sector=sect-32;
			}
			else
			{
				bank=0;
				sector=sect;
			}
    if(bank>1 || type>1 || sector>31 || (type&&(sector>1))  )//жϸֵĲǷϷ
    	return;

	//FLCTL_PRG_CTLSTAT  FLCTL_PRGBRST_CTLSTAT FLCTL_ERASE_CTLSTAT ȫʾΪ״̬
	while(  (FLCTL->PRG_CTLSTAT & FLCTL_PRG_CTLSTAT_STATUS_MASK  )            ||
			(FLCTL->PRGBRST_CTLSTAT & FLCTL_PRGBRST_CTLSTAT_BURST_STATUS_MASK)||
			(FLCTL->ERASE_CTLSTAT & FLCTL_ERASE_CTLSTAT_STATUS_MASK));

	//дĴsectλ ʹsectڲȫ״̬

    if(sect>=32)
    		{
    	BCLR(sector,FLCTL->BANK1_MAIN_WEPROT);
    		}
    		else
    		{
    			BCLR(sector,FLCTL->BANK0_MAIN_WEPROT);
    		}
}

//========================================================================
//ƣflashCtl_issectorProtected
//أ1=0=δ
//˵Ҫ
//ܸҪжflashǷ񱻱
//========================================================================
uint8_t flash_isSectorProtected(uint16_t sect)
{
	uint8_t  bank;
	uint8_t  type=0;
	uint8_t  sector;
	if(sect>=32)
			{
				bank=1;
				sector=sect-32;
			}
			else
			{
				bank=0;
				sector=sect;
			}
    if(bank>1 || type>1 || sector>31 || (type&&(sector>1))  )//жϸֵĲǷϷ
    	return 1;

    if(sect>=32)
    		{
    	return ((FLCTL->BANK1_MAIN_WEPROT)>>sector);
    		}
    		else
    		{
    			return ((FLCTL->BANK0_MAIN_WEPROT)>>sector);
    		}
}

//======================================================================
//ƣflash_isempty
//أ1=ĿΪգ0=Ŀǿա
//˵Ҫ̽flashʼַ
//ܸҪflashпղ
//======================================================================
uint8_t flash_isempty(uint16_t sect,uint16_t offset,uint16_t N)
{
    uint16_t i;
	uint8_t  bank;
	uint8_t  type=0;
	uint8_t  sector;
	uint8_t *src;
    uint32_t addrbase;
    uint8_t  flag;
    if(sect>=32)
    		{
    			bank=1;
    			sector=sect-32;
    		}
    		else
    		{
    			bank=0;
    			sector=sect;
    		}
   if(bank>1 || type>1 || sector>31 || (type&&(sector>1)) || offset>4095 )//жϸֵĲǷϷ
	   return 1;


   if(sect>=32)
   		{
	   addrbase=0x00020000;
   		}
   		else
   		{
   			addrbase=0x00000000;
   		}



   flag=1;
   src=(uint8_t *)(sector*4096+offset+addrbase);//ַ
   for(i = 0; i<N; i++)   //ֽ
   {
      if(src[i]!=0xff)   //ǿ
      {
          flag=0;
          break;
       }
   }
   return flag;
}

