//===========================================================================
//ļƣgpio.H
//ܸҪGPIOײԴļ
//ȨУݴѧǶʽ(sumcu.suda.edu.cn)
//¼¼2017-11-09  V1.0
//===========================================================================

#ifndef GPIO_H_      //ֹظ壨_GPIO_H  ͷ)
#define GPIO_H_

#include "mcu.h"   //Ҫͷļ
#include "string.h"

// ˿ںŵַƫ궨
#define PT1    (0<<8) //1˿
#define PT2    (1<<8) //2˿
#define PT3    (2<<8) //3˿
#define PT4    (3<<8) //4˿
#define PT5    (4<<8) //5˿
#define PT6    (5<<8) //6˿
#define PT7    (6<<8) //7˿
#define PT8    (7<<8) //8˿
#define PT9    (8<<8) //9˿
#define PT10   (9<<8) //10˿
#define PTJ    (10<<8) //J˿

// GPIOŷ궨
#define GPIO_IN      0
#define GPIO_OUTPUT  1

// GPIOжͺ궨
#define RISING_EDGE  (0)      //ش
#define FALLING_EDGE (1)     //½ش
//===========================================================================
//ƣgpio_init
//أ
//˵port_pin(˿ں)|(ź)PORT1|(5) ʾΪ15Žţ
//          dirŷ0=룬1=,ŷ궨壩
//          state˿ųʼ״̬0=͵ƽ1=ߵƽ
//ܸҪʼָ˿ΪGPIOŹܣΪ
//          ָʼ״̬ǵ͵ƽߵƽ
//===========================================================================
void gpio_init(uint16_t port_pin, uint8_t dir, uint8_t state);

//===========================================================================
//ƣgpio_set
//أ
//˵port_pin(˿ں)|(ź)PORT1|(5) ʾΪ15Žţ
//          stateϣõĶ˿״̬0=͵ƽ1=ߵƽ
//ܸҪָ˿űΪGPIOΪʱ趨״̬
//===========================================================================
void gpio_set(uint16_t port_pin, uint8_t state);

//===========================================================================
//ƣgpio_get
//أָ˿ŵ״̬10
//˵port_pin(˿ں)|(ź)PORT1|(5) ʾΪ15Žţ
//ܸҪָ˿űΪGPIOΪʱȡָ״̬
//===========================================================================
uint8_t gpio_get(uint16_t port_pin);

//===========================================================================
//ƣgpio_reverse
//أ
//˵port_pin(˿ں)|(ź)PORT1|(5) ʾΪ15Žţ
//ܸҪָ˿űΪGPIOΪʱת״̬
//===========================================================================
void gpio_reverse(uint16_t port_pin);

//===========================================================================
//ƣgpio_pull
//أ
//˵port_pin(˿ں)|(ź)PORT1|(5) ʾΪ15Žţ
//          pullselect/0=1=
//ܸҪָ˿űΪGPIOΪʱ/
//===========================================================================
void gpio_pull(uint16_t port_pin, uint8_t pullselect);

//===========================================================================
//ƣgpio_enable_int
//أ
//˵port_pin(˿ں)|(ź)PORT1|(5) ʾΪ15Žţ
//          irqtypeжͣɺ궨ٴо£
//                  RISING_EDGE  0      //ش
//                  FALLING_EDGE 1     //½ش
//ܸҪָ˿űΪGPIOΪʱжϣ
//          жϴ
//ע          ⣺ MP432P401RоƬֻPORT1~PORT6ھGPIOжϹ
//
//===========================================================================
void gpio_enable_int(uint16_t port_pin,uint8_t irqtype);

//===========================================================================
//ƣgpio_disable_int
//أ
//˵port_pin(˿ں)|(ź)PORT1|(5) ʾΪ15Žţ
//ܸҪָ˿űΪGPIOΪʱرж
//ע          ⣺ MP432P401RоƬֻPORT1~PORT6ھGPIOжϹ
//
//===========================================================================
void gpio_disable_int(uint16_t port_pin);

//===========================================================================
//ƣgpio_drive_strength
//أ
//˵port_pin(˿ں)|(ź)PORT1|(0) ʾΪ10Žţ
//       controlŵűΪʱDSE=1DSE=0
//                
//ܸҪָĳһmAλ5mA,
//        18mA        űΪʱ,ŵãֻPTB0,PTB1,PTD6,
//        PTD7ͬʱи,ЩſֱLEDMOSFET볡Ч
//        ܣ磬úֻ4š
//===========================================================================
void gpio_drive_strength(uint16_t port_pin, uint8_t control);

#endif
