//===========================================================================
//ļƣdma.c
//ܸҪdmaײԴļ
//ȨУݴѧǶʽ(sumcu.suda.edu.cn)
//¼¼2017-12-09  V1.0
//===========================================================================

#include "dma.h"   //ͷļ

//===========================================================================
//ƣdma_init
//أ
//˵channelStructIndexͨṹUDMA_PRI_SELECTUDMA_ALT_SELECT
//		 controlģʽѡ
//		 controlTableDMAƱ
//ܸҪʼdma
//===========================================================================
void dma_init(uint32_t channelStructIndex, uint32_t control,void *controlTable)
{
	//ֲ
	DMA_ControlTable *pCtl;
	channelStructIndex &= 0x3f;
	//DMA
	DMA_Control->CFG = DMA_CFG_MASTEN;
	//õַ
	DMA_Control->CTLBASE = (uint32_t)controlTable;
	pCtl = (DMA_ControlTable *) DMA_Control->CTLBASE;
	//Զ㹩ӦĿƱýгʼ
	pCtl[channelStructIndex].control = ((pCtl[channelStructIndex].control
	            & ~(UDMA_CHCTL_DSTINC_M | UDMA_CHCTL_DSTSIZE_M | UDMA_CHCTL_SRCINC_M
	                    | UDMA_CHCTL_SRCSIZE_M | UDMA_CHCTL_ARBSIZE_M
	                    | UDMA_CHCTL_NXTUSEBURST)) | control);

}

//===========================================================================
//ƣdma_setChannelTransfer
//أ
//˵channelStructIndexͨṹUDMA_PRI_SELECTUDMA_ALT_SELECT
//        modeģʽѡѡԶģʽUDMA_MODE_AUTO
//        srcAddrԴַ
//        dstAddrĿַ
//        transferSizeС
//ܸҪͨ
//===========================================================================
void dma_setChannelTransfer(uint32_t channelStructIndex, uint32_t mode,
        void *srcAddr, void *dstAddr, uint32_t transferSize)
{
	//ֲ
    DMA_ControlTable *controlTable;
    uint32_t control;
    uint32_t increment;
    uint32_t bufferBytes;

    channelStructIndex &= 0x3f;
    //ȡǰƱ
    controlTable = (DMA_ControlTable *) DMA_Control->CTLBASE;

    //ȡǰͨģʽ
    control = (controlTable[channelStructIndex].control
            & ~(UDMA_CHCTL_XFERSIZE_M | UDMA_CHCTL_XFERMODE_M));

    //ģʽʱALTģʽĳPERģʽ
    if (channelStructIndex & UDMA_ALT_SELECT)
    {
        if ((mode == UDMA_MODE_MEM_SCATTER_GATHER)
                || (mode == UDMA_MODE_PER_SCATTER_GATHER))
        {
            mode |= UDMA_MODE_ALT_SELECT;
        }
    }

    //ģʽԼݴС
    control |= mode | ((transferSize - 1) << 4);

    //ȡǰַ
    increment = (control & UDMA_CHCTL_SRCINC_M);

    //βַ
    if (increment != UDMA_SRC_INC_NONE)
    {
        increment = increment >> 26;
        bufferBytes = transferSize << increment;
        srcAddr = (void *) ((uint32_t) srcAddr + bufferBytes - 1);
    }

    //ַԴβַ
    controlTable[channelStructIndex].srcEndAddr = srcAddr;

    //ȡĿַ
    increment = control & UDMA_CHCTL_DSTINC_M;

    //Ŀַβַ
    if (increment != UDMA_DST_INC_NONE)
    {
        //
        // µļ
        //
        if ((mode == UDMA_MODE_MEM_SCATTER_GATHER)
                || (mode == UDMA_MODE_PER_SCATTER_GATHER))
        {
            dstAddr = (void *) &controlTable[channelStructIndex
                    | UDMA_ALT_SELECT].spare;
        }
        // 
        else
        {
            increment = increment >> 30;
            bufferBytes = transferSize << increment;
            dstAddr = (void *) ((uint32_t) dstAddr + bufferBytes - 1);
        }
    }
    // װĿַdstEndAddr
    controlTable[channelStructIndex].dstEndAddr = dstAddr;

    controlTable[channelStructIndex].control = control;
}


//===========================================================================
//ƣdma_enable_int
//أ
//˵
//ܸҪdmaжϹ
//===========================================================================
void dma_enable_int(uint32_t interruptNumber, uint32_t channelNum)
{
	if (interruptNumber == DMA_INT1)
	    {
	        DMA_Channel->INT1_SRCCFG = (DMA_Channel->INT1_SRCCFG
	                & ~DMA_INT1_SRCCFG_INT_SRC_MASK) | channelNum;
	    } else if (interruptNumber == DMA_INT2)
	    {
	        DMA_Channel->INT2_SRCCFG = (DMA_Channel->INT2_SRCCFG
	                & ~DMA_INT1_SRCCFG_INT_SRC_MASK) | channelNum;
	    } else if (interruptNumber == DMA_INT3)
	    {
	        DMA_Channel->INT3_SRCCFG = (DMA_Channel->INT3_SRCCFG
	                & ~DMA_INT1_SRCCFG_INT_SRC_MASK) | channelNum;
	    }

    if (interruptNumber == DMA_INT1)
    {
        DMA_Channel->INT1_SRCCFG |= DMA_INT1_SRCCFG_EN;
        NVIC_EnableIRQ((IRQn_Type)49);
    } else if (interruptNumber == DMA_INT2)
    {
        DMA_Channel->INT2_SRCCFG |= DMA_INT2_SRCCFG_EN;
        NVIC_EnableIRQ((IRQn_Type)48);
    } else if (interruptNumber == DMA_INT3)
    {
        DMA_Channel->INT3_SRCCFG |= DMA_INT3_SRCCFG_EN;
        NVIC_EnableIRQ((IRQn_Type)47);
    }

}

//===========================================================================
//ƣdma_enable
//أ
//˵channelNum ͨΪ 0~7
//ܸҪʹdmaͨ
//===========================================================================
void dma_enableCh(uint8_t channelNum)
{
	DMA_Control->ENASET = 1 << (channelNum & 0x0F);
}

//===========================================================================
//ƣdma_disable
//أ
//˵channelNum ͨΪ 0~7
//ܸҪرdmaͨ
//===========================================================================
void dma_disableCh(uint8_t channelNum)
{
	DMA_Control->ENACLR = 1 << (channelNum & 0x0F);
}

//===========================================================================
//ƣdma_requestSoftwareTransfer
//أ
//˵channelNum ͨΪ 0~7
//ܸҪͨ
//===========================================================================
void dma_requestSoftwareTransfer(uint32_t channelNum)
{
    DMA_Channel->SW_CHTRIG |= (1 << channelNum);
}

const uint8_t data_array[] =
{
        0x2E, 0x06, 0x7D, 0x3C, 0x1F, 0x42, 0xAE, 0x39, 0xCE, 0x0F, 0x1E, 0x53,
        0x82, 0x4E, 0xAE, 0x39, 0x4F, 0x0E, 0x4F, 0x0D, 0x00, 0x18, 0x5F, 0x52,
        0xA6, 0x39, 0xE2, 0x4F, 0x2E, 0x06, 0x6F, 0x3C, 0x00, 0x18, 0xC2, 0x93,
        0xAA, 0x39, 0x04, 0x20, 0xD2, 0x42, 0x2C, 0x06, 0xB0, 0x39, 0x67, 0x3C,
        0x1F, 0x42, 0xAE, 0x39, 0xCE, 0x0F, 0x1E, 0x53, 0x82, 0x4E, 0xAE, 0x39,
        0x4F, 0x0E, 0x4F, 0x0D, 0x00, 0x18, 0x5F, 0x52, 0xAA, 0x39, 0xDF, 0x42,
        0x2C, 0x06, 0x00, 0x00, 0x58, 0x3C, 0xF2, 0xC2, 0x3D, 0x06, 0x5F, 0x42,
        0x94, 0x39, 0x1F, 0x83, 0x08, 0x24, 0x1F, 0x83, 0x0B, 0x20, 0x1C, 0x42,
        0xAE, 0x39, 0x4D, 0x43, 0x80, 0x13, 0x9A, 0x39, 0x05, 0x3C, 0x1C, 0x42,
        0xAE, 0x39, 0x4D, 0x43, 0x80, 0x13, 0x96, 0x39, 0xC2, 0x43, 0x94, 0x39,
        0x42, 0x3C, 0xE2, 0xC2, 0x3D, 0x06, 0x5F, 0x42, 0x94, 0x39, 0x1F, 0x83,
        0x0E, 0x24, 0x1F, 0x83, 0x17, 0x20, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06,
        0x02, 0x20, 0x5D, 0x43, 0x01, 0x3C, 0x6D, 0x43, 0x1C, 0x42, 0xAE, 0x39,
        0x80, 0x13, 0x9A, 0x39, 0x0B, 0x3C, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06,
        0x02, 0x20, 0x5D, 0x43, 0x01, 0x3C, 0x6D, 0x43, 0x1C, 0x42, 0xAE, 0x39,
        0x80, 0x13, 0x96, 0x39, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06, 0x1B, 0x24,
        0x00, 0x18, 0xC2, 0x93, 0xA6, 0x39, 0x05, 0x20, 0xC2, 0x43, 0x94, 0x39,
        0xF2, 0xD2, 0x20, 0x06, 0x16, 0x3C, 0xE2, 0x43, 0x94, 0x39, 0x82, 0x43,
        0xAE, 0x39, 0x1F, 0x42, 0xAE, 0x39, 0xCE, 0x0F, 0x1E, 0x53, 0x82, 0x4E,
        0xAE, 0x39, 0x4F, 0x0E, 0x4F, 0x0D, 0x00, 0x18, 0x5F, 0x52, 0xA6, 0x39,
        0xE2, 0x4F, 0x2E, 0x06, 0x04, 0x3C, 0xD2, 0x43, 0x94, 0x39, 0x82, 0x43,
        0xAE, 0x39, 0x00, 0x18, 0xC2, 0x93, 0x9E, 0x39, 0x08, 0x24, 0x2C, 0x00,
        0x9E, 0x39, 0x1D, 0x42, 0xA2, 0x39, 0x1E, 0x42, 0xA4, 0x39, 0xB1, 0x13,
        0x62, 0x74, 0xB1, 0xC0, 0xF0, 0x00, 0x14, 0x00, 0x4B, 0x16, 0x00, 0x13,
        0x1F, 0x14, 0x1F, 0x42, 0xFE, 0x05, 0x2F, 0x82, 0x58, 0x24, 0x3F, 0x80,
        0x06, 0x00, 0x3D, 0x24, 0x2F, 0x83, 0x57, 0x20, 0xE2, 0xC3, 0xFD, 0x05,
        0x1F, 0x42, 0xDE, 0x39, 0x1F, 0x83, 0x1E, 0x24, 0x1F, 0x83, 0x4F, 0x20,
        0xC2, 0x93, 0xE1, 0x39, 0x13, 0x24, 0x82, 0x93, 0xE6, 0x39, 0x05, 0x20,
        0x82, 0x43, 0xDE, 0x39, 0xE2, 0xD2, 0xE0, 0x05, 0x44, 0x3C, 0x2F, 0x00,
        0xE2, 0x39, 0x6F, 0x4F, 0x00, 0x18, 0xD2, 0x53, 0xE2, 0x39, 0x92, 0x83,
        0xE6, 0x39, 0xC2, 0x4F, 0xEE, 0x05, 0x39, 0x3C, 0xD2, 0x43, 0xE1, 0x39,
        0xD2, 0x42, 0xE0, 0x39, 0xEE, 0x05, 0x33, 0x3C, 0xC2, 0x93, 0xE1, 0x39,
        0x80, 0x13, 0x9A, 0x39, 0x0B, 0x3C, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06,
        0x02, 0x20, 0x5D, 0x43, 0x01, 0x3C, 0x6D, 0x43, 0x1C, 0x42, 0xAE, 0x39,
        0x80, 0x13, 0x96, 0x39, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06, 0x1B, 0x24,
        0x00, 0x18, 0xC2, 0x93, 0xA6, 0x39, 0x05, 0x20, 0xC2, 0x43, 0x94, 0x39,
        0xF2, 0xD2, 0x20, 0x06, 0x16, 0x3C, 0xE2, 0x43, 0x94, 0x39, 0x82, 0x43,
        0xAE, 0x39, 0x1F, 0x42, 0xAE, 0x39, 0xCE, 0x0F, 0x1E, 0x53, 0x82, 0x4E,
        0xAE, 0x39, 0x4F, 0x0E, 0x4F, 0x0D, 0x00, 0x18, 0x5F, 0x52, 0xA6, 0x39,
        0xE2, 0x4F, 0x2E, 0x06, 0x04, 0x3C, 0xD2, 0x43, 0x94, 0x39, 0x82, 0x43,
        0xAE, 0x39, 0x00, 0x18, 0xC2, 0x93, 0x9E, 0x39, 0x08, 0x24, 0x2C, 0x00,
        0x9E, 0x39, 0x1D, 0x42, 0xA2, 0x39, 0x1E, 0x42, 0xA4, 0x39, 0xB1, 0x13,
        0x62, 0x74, 0xB1, 0xC0, 0xF0, 0x00, 0x14, 0x00, 0x4B, 0x16, 0x00, 0x13,
        0x1F, 0x14, 0x1F, 0x42, 0xFE, 0x05, 0x2F, 0x82, 0x58, 0x24, 0x3F, 0x80,
        0x06, 0x00, 0x3D, 0x24, 0x2F, 0x83, 0x57, 0x20, 0xE2, 0xC3, 0xFD, 0x05,
        0x1F, 0x42, 0xDE, 0x39, 0x1F, 0x83, 0x1E, 0x24, 0x1F, 0x83, 0x4F, 0x20,
        0xC2, 0x93, 0xE1, 0x39, 0x13, 0x24, 0x82, 0x93, 0xE6, 0x39, 0x05, 0x20,
        0x82, 0x43, 0xDE, 0x39, 0xE2, 0xD2, 0xE0, 0x05, 0x44, 0x3C, 0x2F, 0x00,
        0xE2, 0x39, 0x6F, 0x4F, 0x00, 0x18, 0xD2, 0x53, 0xE2, 0x39, 0x92, 0x83,
        0xE6, 0x39, 0xC2, 0x4F, 0xEE, 0x05, 0x39, 0x3C, 0xD2, 0x43, 0xE1, 0x39,
        0xD2, 0x42, 0xE0, 0x39, 0xEE, 0x05, 0x33, 0x3C, 0xC2, 0x93, 0xE1, 0x39,
        0x80, 0x13, 0x9A, 0x39, 0x0B, 0x3C, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06,
        0x02, 0x20, 0x5D, 0x43, 0x01, 0x3C, 0x6D, 0x43, 0x1C, 0x42, 0xAE, 0x39,
        0x80, 0x13, 0x96, 0x39, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06, 0x1B, 0x24,
        0x00, 0x18, 0xC2, 0x93, 0xA6, 0x39, 0x05, 0x20, 0xC2, 0x43, 0x94, 0x39,
        0xF2, 0xD2, 0x20, 0x06, 0x16, 0x3C, 0xE2, 0x43, 0x94, 0x39, 0x82, 0x43,
        0xAE, 0x39, 0x1F, 0x42, 0xAE, 0x39, 0xCE, 0x0F, 0x1E, 0x53, 0x82, 0x4E,
        0xAE, 0x39, 0x4F, 0x0E, 0x4F, 0x0D, 0x00, 0x18, 0x5F, 0x52, 0xA6, 0x39,
        0xE2, 0x4F, 0x2E, 0x06, 0x04, 0x3C, 0xD2, 0x43, 0x94, 0x39, 0x82, 0x43,
        0xAE, 0x39, 0x00, 0x18, 0xC2, 0x93, 0x9E, 0x39, 0x08, 0x24, 0x2C, 0x00,
        0x9E, 0x39, 0x1D, 0x42, 0xA2, 0x39, 0x1E, 0x42, 0xA4, 0x39, 0xB1, 0x13,
        0x62, 0x74, 0xB1, 0xC0, 0xF0, 0x00, 0x14, 0x00, 0x4B, 0x16, 0x00, 0x13,
        0x1F, 0x14, 0x1F, 0x42, 0xFE, 0x05, 0x2F, 0x82, 0x58, 0x24, 0x3F, 0x80,
        0x06, 0x00, 0x3D, 0x24, 0x2F, 0x83, 0x57, 0x20, 0xE2, 0xC3, 0xFD, 0x05,
        0x1F, 0x42, 0xDE, 0x39, 0x1F, 0x83, 0x1E, 0x24, 0x1F, 0x83, 0x4F, 0x20,
        0xC2, 0x93, 0xE1, 0x39, 0x13, 0x24, 0x82, 0x93, 0xE6, 0x39, 0x05, 0x20,
        0x82, 0x43, 0xDE, 0x39, 0xE2, 0xD2, 0xE0, 0x05, 0x44, 0x3C, 0x2F, 0x00,
        0xE2, 0x39, 0x6F, 0x4F, 0x00, 0x18, 0xD2, 0x53, 0xE2, 0x39, 0x92, 0x83,
        0xE6, 0x39, 0xC2, 0x4F, 0xEE, 0x05, 0x39, 0x3C, 0xD2, 0x43, 0xE1, 0x39,
        0xD2, 0x42, 0xE0, 0x39, 0xEE, 0x05, 0x33, 0x3C, 0xC2, 0x93, 0xE1, 0x39,
        0x80, 0x13, 0x9A, 0x39, 0x0B, 0x3C, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06,
        0x02, 0x20, 0x5D, 0x43, 0x01, 0x3C, 0x6D, 0x43, 0x1C, 0x42, 0xAE, 0x39,
        0x80, 0x13, 0x96, 0x39, 0xF2, 0xB0, 0x10, 0x00, 0x20, 0x06, 0x1B, 0x24,
        0x00, 0x18, 0xC2, 0x93, 0xA6, 0x39, 0x05, 0x20, 0xC2, 0x43, 0x94, 0x39,
        0xF2, 0xD2, 0x20, 0x06, 0x16, 0x3C, 0xE2, 0x43, 0x94, 0x39, 0x82, 0x43,
        0xAE, 0x39, 0x1F, 0x42, 0xAE, 0x39, 0xCE, 0x0F, 0x1E, 0x53, 0x82, 0x4E,
        0xAE, 0x39, 0x4F, 0x0E, 0x4F, 0x0D, 0x00, 0x18, 0x5F, 0x52, 0xA6, 0x39,
        0xE2, 0x4F, 0x2E, 0x06, 0x04, 0x3C, 0xD2, 0x43, 0x94, 0x39, 0x82, 0x43,
        0xAE, 0x39, 0x00, 0x18, 0xC2, 0x93, 0x9E, 0x39, 0x08, 0x24, 0x2C, 0x00,
        0x9E, 0x39, 0x1D, 0x42, 0xA2, 0x39, 0x1E, 0x42, 0xA4, 0x39, 0xB1, 0x13,
        0x62, 0x74, 0xB1, 0xC0, 0xF0, 0x00, 0x14, 0x00, 0x4B, 0x16, 0x00, 0x13,
        0x1F, 0x14, 0x1F, 0x42, 0xFE, 0x05, 0x2F, 0x82, 0x58, 0x24, 0x3F, 0x80,
        0x06, 0x00, 0x3D, 0x24, 0x2F, 0x83, 0x57, 0x20, 0xE2, 0xC3, 0xFD, 0x05,
        0x1F, 0x42, 0xDE, 0x39, 0x1F, 0x83, 0x1E, 0x24, 0x1F, 0x83, 0x4F, 0x20,
        0xC2, 0x93, 0xE1, 0x39, 0x13, 0x24, 0x82, 0x93, 0xE6, 0x39, 0x05, 0x20,
        0xCA, 0xFE, 0xBE, 0xEF
};